/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.exceptions.DriverInternalError;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

class DirectedGraph<V> {
    final Map<V, Integer> vertices;
    final Multimap<V, V> adjacencyList;
    boolean wasSorted;
    final Comparator<V> comparator;

    DirectedGraph(Comparator<V> comparator, List<V> vertices) {
        this.comparator = comparator;
        this.vertices = Maps.newHashMapWithExpectedSize(vertices.size());
        this.adjacencyList = HashMultimap.create();
        for (V vertex : vertices) {
            this.vertices.put((Integer)vertex, 0);
        }
    }

    DirectedGraph(Comparator<V> comparator, V ... vertices) {
        this(comparator, Arrays.asList(vertices));
    }

    void addEdge(V from, V to) {
        Preconditions.checkArgument(this.vertices.containsKey(from) && this.vertices.containsKey(to));
        this.adjacencyList.put(from, to);
        this.vertices.put((Integer)to, this.vertices.get(to) + 1);
    }

    List<V> topologicalSort() {
        Preconditions.checkState(!this.wasSorted);
        this.wasSorted = true;
        LinkedList queue = new LinkedList();
        ArrayList<V> orderedVertices = new ArrayList<V>(this.vertices.keySet());
        Collections.sort(orderedVertices, this.comparator);
        for (Object v : orderedVertices) {
            if (this.vertices.get(v) != 0) continue;
            queue.add(v);
        }
        ArrayList result = Lists.newArrayList();
        while (!queue.isEmpty()) {
            Object vertex = queue.remove();
            result.add(vertex);
            ArrayList<V> adjacentVertices = new ArrayList<V>(this.adjacencyList.get(vertex));
            Collections.sort(adjacentVertices, this.comparator);
            for (Object successor : adjacentVertices) {
                if (this.decrementAndGetCount(successor) != 0) continue;
                queue.add(successor);
            }
        }
        if (result.size() != this.vertices.size()) {
            throw new DriverInternalError("failed to perform topological sort, graph has a cycle");
        }
        return result;
    }

    private int decrementAndGetCount(V vertex) {
        Integer count = this.vertices.get(vertex);
        count = count - 1;
        this.vertices.put((Integer)vertex, count);
        return count;
    }
}

