/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.tool.service.eclipse.ui;

import org.apache.axis2.tool.service.bean.WSDLFileLocationBean;
import org.apache.axis2.tool.service.eclipse.plugin.ServiceArchiver;
import org.apache.axis2.tool.service.eclipse.ui.AbstractServiceWizardPage;
import org.apache.axis2.tool.service.eclipse.ui.ServiceArchiveWizard;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class WSDLFileSelectionPage
extends AbstractServiceWizardPage {
    private Text wsdlTextBox;
    private Label selectionLabel;
    private Button browseButton;
    private Button skipWSDLCheckButton;
    private Button selectWSDLCheckButton;

    public WSDLFileSelectionPage() {
        super("page5");
    }

    @Override
    protected void initializeDefaultSettings() {
        this.settings.put("WSDL_FILE_NAME", "");
        this.settings.put("WSDL_GEN", true);
        this.settings.put("SKIP_WSDL", false);
        this.settings.put("SELECT_WSDL", false);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        container.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd = new GridData();
        gd.horizontalSpan = 3;
        this.skipWSDLCheckButton = new Button(container, 32);
        this.skipWSDLCheckButton.setText(ServiceArchiver.getResourceString("page5.skipWSDL.caption"));
        this.skipWSDLCheckButton.setLayoutData((Object)gd);
        this.skipWSDLCheckButton.setSelection(this.settings.getBoolean("SKIP_WSDL"));
        this.skipWSDLCheckButton.setEnabled(true);
        this.skipWSDLCheckButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WSDLFileSelectionPage.this.handleSkip();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        new Label(container, 0);
        gd = new GridData();
        gd.horizontalSpan = 3;
        this.selectWSDLCheckButton = new Button(container, 32);
        this.selectWSDLCheckButton.setText(ServiceArchiver.getResourceString("page5.selectWSDL.caption"));
        this.selectWSDLCheckButton.setLayoutData((Object)gd);
        this.selectWSDLCheckButton.setSelection(this.settings.getBoolean("SELECT_WSDL"));
        this.selectWSDLCheckButton.setEnabled(true);
        this.selectWSDLCheckButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WSDLFileSelectionPage.this.handleSelect();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        gd = new GridData(768);
        this.selectionLabel = new Label(container, 0);
        this.selectionLabel.setText(ServiceArchiver.getResourceString("page5.selectwsdl.caption"));
        this.wsdlTextBox = new Text(container, 2048);
        this.wsdlTextBox.setLayoutData((Object)gd);
        this.wsdlTextBox.setText(this.settings.get("WSDL_FILE_NAME"));
        this.wsdlTextBox.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WSDLFileSelectionPage.this.handleModify();
            }
        });
        this.browseButton = new Button(container, 8);
        this.browseButton.setText(ServiceArchiver.getResourceString("general.browse"));
        this.browseButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                WSDLFileSelectionPage.this.handleBrowse();
            }
        });
        this.setControl((Control)container);
        if (this.restoredFromPreviousSettings) {
            this.handleSkip();
            if (!this.skipWSDLCheckButton.getSelection()) {
                this.handleSelect();
            }
        }
    }

    private void handleSkip() {
        if (this.skipWSDLCheckButton.getSelection()) {
            this.changeManualSelectionStatus(false);
            this.updateStatus(null);
            this.settings.put("SKIP_WSDL", true);
            this.selectWSDLCheckButton.setSelection(false);
        } else if (!this.selectWSDLCheckButton.getSelection()) {
            this.skipWSDLCheckButton.setSelection(true);
            this.changeManualSelectionStatus(false);
            this.updateStatus(null);
            this.settings.put("SKIP_WSDL", true);
            this.selectWSDLCheckButton.setSelection(false);
        }
    }

    private void handleSelect() {
        if (this.selectWSDLCheckButton.getSelection()) {
            this.changeManualSelectionStatus(true);
            this.updateStatus(null);
            this.skipWSDLCheckButton.setSelection(false);
        } else if (!this.skipWSDLCheckButton.getSelection()) {
            this.selectWSDLCheckButton.setSelection(true);
            this.changeManualSelectionStatus(true);
            this.updateStatus(null);
            this.skipWSDLCheckButton.setSelection(false);
        }
    }

    private void handleBrowse() {
        FileDialog fileDialog = new FileDialog(this.getShell());
        fileDialog.setFilterExtensions(new String[]{"*.wsdl"});
        String returnFileName = fileDialog.open();
        if (returnFileName != null) {
            this.wsdlTextBox.setText(returnFileName);
        }
    }

    private void handleModify() {
        String text = this.wsdlTextBox.getText();
        this.settings.put("WSDL_FILE_NAME", text);
        if ("".equals(text)) {
            this.updateStatus(ServiceArchiver.getResourceString("page5.error.wsdlnameempty"));
        } else if (!text.endsWith(".wsdl")) {
            this.updateStatus(ServiceArchiver.getResourceString("page5.error.wsdlnamewrong"));
        } else {
            this.updateStatus(null);
        }
    }

    private void updateRecommendation(String message) {
        ServiceArchiveWizard wizard = (ServiceArchiveWizard)this.getWizard();
        wizard.updateWsdlFileGenerationStatus(message);
    }

    private void changeManualSelectionStatus(boolean state) {
        this.wsdlTextBox.setEnabled(state);
        this.browseButton.setEnabled(state);
        this.selectionLabel.setEnabled(state);
    }

    public boolean isAutoGenerate() {
        return false;
    }

    @Override
    public boolean isSkipNext() {
        return false;
    }

    public WSDLFileLocationBean getBean() {
        WSDLFileLocationBean locationBean = new WSDLFileLocationBean();
        locationBean.setManual(!this.isAutoGenerate());
        locationBean.setWSDLFileName(this.wsdlTextBox.getText());
        locationBean.setSkip(this.skipWSDLCheckButton.getSelection());
        return locationBean;
    }

    @Override
    protected boolean getWizardComplete() {
        return false;
    }
}

