/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javac.code;

import java.util.EnumSet;
import java.util.Locale;
import java.util.Set;
import org.openjdk.source.tree.MemberReferenceTree;
import org.openjdk.tools.javac.api.Formattable;
import org.openjdk.tools.javac.api.Messages;
import org.openjdk.tools.javac.code.Symbol;
import org.openjdk.tools.javac.code.Type;
import org.openjdk.tools.javac.code.TypeTag;

public class Kinds {
    private Kinds() {
    }

    public static KindName kindName(MemberReferenceTree.ReferenceMode referenceMode) {
        switch (referenceMode) {
            case INVOKE: {
                return KindName.METHOD;
            }
            case NEW: {
                return KindName.CONSTRUCTOR;
            }
        }
        throw new AssertionError((Object)("Unexpected mode: " + (Object)((Object)referenceMode)));
    }

    public static KindName kindName(Symbol symbol) {
        switch (symbol.getKind()) {
            case PACKAGE: {
                return KindName.PACKAGE;
            }
            case ENUM: {
                return KindName.ENUM;
            }
            case ANNOTATION_TYPE: 
            case CLASS: {
                return KindName.CLASS;
            }
            case INTERFACE: {
                return KindName.INTERFACE;
            }
            case TYPE_PARAMETER: {
                return KindName.TYPEVAR;
            }
            case ENUM_CONSTANT: 
            case FIELD: 
            case PARAMETER: 
            case LOCAL_VARIABLE: 
            case EXCEPTION_PARAMETER: 
            case RESOURCE_VARIABLE: {
                return KindName.VAR;
            }
            case CONSTRUCTOR: {
                return KindName.CONSTRUCTOR;
            }
            case METHOD: {
                return KindName.METHOD;
            }
            case STATIC_INIT: {
                return KindName.STATIC_INIT;
            }
            case INSTANCE_INIT: {
                return KindName.INSTANCE_INIT;
            }
        }
        throw new AssertionError((Object)("Unexpected kind: " + (Object)((Object)symbol.getKind())));
    }

    public static KindName typeKindName(Type type) {
        if (type.hasTag(TypeTag.TYPEVAR) || type.hasTag(TypeTag.CLASS) && (type.tsym.flags() & 0x1000000L) != 0L) {
            return KindName.BOUND;
        }
        if (type.hasTag(TypeTag.PACKAGE)) {
            return KindName.PACKAGE;
        }
        if ((type.tsym.flags_field & 0x2000L) != 0L) {
            return KindName.ANNOTATION;
        }
        if ((type.tsym.flags_field & 0x200L) != 0L) {
            return KindName.INTERFACE;
        }
        return KindName.CLASS;
    }

    public static enum KindName implements Formattable
    {
        ANNOTATION("kindname.annotation"),
        CONSTRUCTOR("kindname.constructor"),
        INTERFACE("kindname.interface"),
        ENUM("kindname.enum"),
        STATIC("kindname.static"),
        TYPEVAR("kindname.type.variable"),
        BOUND("kindname.type.variable.bound"),
        VAR("kindname.variable"),
        VAL("kindname.value"),
        METHOD("kindname.method"),
        CLASS("kindname.class"),
        STATIC_INIT("kindname.static.init"),
        INSTANCE_INIT("kindname.instance.init"),
        PACKAGE("kindname.package"),
        MODULE("kindname.module");

        private final String name;

        private KindName(String string2) {
            this.name = string2;
        }

        public String toString() {
            return this.name;
        }

        @Override
        public String getKind() {
            return "Kindname";
        }

        @Override
        public String toString(Locale locale, Messages messages) {
            String string = this.toString();
            return messages.getLocalizedString(locale, "compiler.misc." + string, new Object[0]);
        }
    }

    public static class KindSelector {
        public static final KindSelector NIL = new KindSelector(0);
        public static final KindSelector PCK = new KindSelector(1);
        public static final KindSelector TYP = new KindSelector(2);
        public static final KindSelector VAR = new KindSelector(4);
        public static final KindSelector VAL = new KindSelector(12);
        public static final KindSelector MTH = new KindSelector(16);
        public static final KindSelector POLY = new KindSelector(32);
        public static final KindSelector MDL = new KindSelector(64);
        public static final KindSelector ERR = new KindSelector(127);
        public static final KindSelector ASG = new KindSelector(132);
        public static final KindSelector TYP_PCK = KindSelector.of(TYP, PCK);
        public static final KindSelector VAL_MTH = KindSelector.of(VAL, MTH);
        public static final KindSelector VAL_POLY = KindSelector.of(VAL, POLY);
        public static final KindSelector VAL_TYP = KindSelector.of(VAL, TYP);
        public static final KindSelector VAL_TYP_PCK = KindSelector.of(VAL, TYP, PCK);
        private final byte data;

        private KindSelector(int n) {
            this.data = (byte)n;
        }

        public static KindSelector of(KindSelector ... kindSelectorArray) {
            int n = 0;
            for (KindSelector kindSelector : kindSelectorArray) {
                n = (byte)(n | kindSelector.data);
            }
            return new KindSelector(n);
        }

        public boolean subset(KindSelector kindSelector) {
            return (this.data & ~kindSelector.data) == 0;
        }

        public boolean contains(KindSelector kindSelector) {
            return (this.data & kindSelector.data) != 0;
        }

        public Set<KindName> kindNames() {
            EnumSet<KindName> enumSet = EnumSet.noneOf(KindName.class);
            if ((this.data & KindSelector.VAL.data) != 0) {
                if ((this.data & KindSelector.VAL.data) == KindSelector.VAR.data) {
                    enumSet.add(KindName.VAR);
                } else {
                    enumSet.add(KindName.VAL);
                }
            }
            if ((this.data & KindSelector.MTH.data) != 0) {
                enumSet.add(KindName.METHOD);
            }
            if ((this.data & KindSelector.TYP.data) != 0) {
                enumSet.add(KindName.CLASS);
            }
            if ((this.data & KindSelector.PCK.data) != 0) {
                enumSet.add(KindName.PACKAGE);
            }
            if ((this.data & KindSelector.MDL.data) != 0) {
                enumSet.add(KindName.MODULE);
            }
            return enumSet;
        }
    }

    public static enum Kind {
        NIL(Category.BASIC, KindSelector.NIL),
        PCK(Category.BASIC, KindName.PACKAGE, KindSelector.PCK),
        TYP(Category.BASIC, KindName.CLASS, KindSelector.TYP),
        VAR(Category.BASIC, KindName.VAR, KindSelector.VAR),
        MTH(Category.BASIC, KindName.METHOD, KindSelector.MTH),
        POLY(Category.BASIC, KindSelector.POLY),
        MDL(Category.BASIC, KindSelector.MDL),
        ERR(Category.ERROR, KindSelector.ERR),
        AMBIGUOUS(Category.RESOLUTION_TARGET),
        HIDDEN(Category.RESOLUTION_TARGET),
        STATICERR(Category.RESOLUTION_TARGET),
        MISSING_ENCL(Category.RESOLUTION),
        ABSENT_VAR(Category.RESOLUTION_TARGET, KindName.VAR),
        WRONG_MTHS(Category.RESOLUTION_TARGET, KindName.METHOD),
        WRONG_MTH(Category.RESOLUTION_TARGET, KindName.METHOD),
        ABSENT_MTH(Category.RESOLUTION_TARGET, KindName.METHOD),
        ABSENT_TYP(Category.RESOLUTION_TARGET, KindName.CLASS);

        private final KindName kindName;
        private final KindName absentKind;
        private final KindSelector selector;
        private final Category category;

        private Kind(Category category) {
            this(category, null, null, null);
        }

        private Kind(Category category, KindSelector kindSelector) {
            this(category, null, null, kindSelector);
        }

        private Kind(Category category, KindName kindName) {
            this(category, null, kindName, null);
        }

        private Kind(Category category, KindName kindName, KindSelector kindSelector) {
            this(category, kindName, null, kindSelector);
        }

        private Kind(Category category, KindName kindName, KindName kindName2, KindSelector kindSelector) {
            this.category = category;
            this.kindName = kindName;
            this.absentKind = kindName2;
            this.selector = kindSelector;
        }

        public KindSelector toSelector() {
            return this.selector;
        }

        public boolean matches(KindSelector kindSelector) {
            return this.selector.contains(kindSelector);
        }

        public boolean isResolutionError() {
            return this.category == Category.RESOLUTION || this.category == Category.RESOLUTION_TARGET;
        }

        public boolean isResolutionTargetError() {
            return this.category == Category.RESOLUTION_TARGET;
        }

        public boolean isValid() {
            return this.category == Category.BASIC;
        }

        public boolean betterThan(Kind kind) {
            return this.ordinal() < kind.ordinal();
        }

        public KindName kindName() {
            if (this.kindName == null) {
                throw new AssertionError((Object)("Unexpected kind: " + (Object)((Object)this)));
            }
            return this.kindName;
        }

        public KindName absentKind() {
            if (this.absentKind == null) {
                throw new AssertionError((Object)("Unexpected kind: " + (Object)((Object)this)));
            }
            return this.absentKind;
        }

        private static enum Category {
            BASIC,
            ERROR,
            RESOLUTION,
            RESOLUTION_TARGET;

        }
    }
}

