/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.terminal;

import com.github.ajalt.mordant.internal.MppImplKt;
import com.github.ajalt.mordant.internal.Size;
import com.github.ajalt.mordant.rendering.AnsiLevel;
import com.github.ajalt.mordant.terminal.TerminalInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0002J\b\u0010\b\u001a\u00020\u0004H\u0002J\b\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u0004\u0018\u00010\nJ=\u0010\f\u001a\u00020\r2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0012J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0006H\u0002J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0015H\u0002J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0015H\u0002J\b\u0010\u0018\u001a\u00020\u0004H\u0002J\b\u0010\u0019\u001a\u00020\u0004H\u0002J\b\u0010\u001a\u001a\u00020\u0004H\u0002J\b\u0010\u001b\u001a\u00020\u0004H\u0002J\b\u0010\u001c\u001a\u00020\u0004H\u0002J\b\u0010\u001d\u001a\u00020\u0004H\u0002J\b\u0010\u001e\u001a\u00020\u0004H\u0002J\b\u0010\u001f\u001a\u00020\u0004H\u0002\u00a8\u0006 "}, d2={"Lcom/github/ajalt/mordant/terminal/TerminalDetection;", "", "()V", "ansiHyperLinks", "", "ansiLevel", "Lcom/github/ajalt/mordant/rendering/AnsiLevel;", "interactive", "ciSupportsColor", "detectInitialSize", "Lcom/github/ajalt/mordant/internal/Size;", "detectSize", "detectTerminal", "Lcom/github/ajalt/mordant/terminal/TerminalInfo;", "width", "", "height", "hyperlinks", "(Lcom/github/ajalt/mordant/rendering/AnsiLevel;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Boolean;Ljava/lang/Boolean;)Lcom/github/ajalt/mordant/terminal/TerminalInfo;", "forcedColor", "getColorTerm", "", "getTerm", "getTermProgram", "iTermVersionSupportsTruecolor", "isCI", "isDomTerm", "isIntellijRunActionConsole", "isJediTerm", "isVsCodeTerminal", "isWindowsTerminal", "minttyVersionSupportsHyperlinks", "mordant"})
@SourceDebugExtension(value={"SMAP\nTerminalDetection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalDetection.kt\ncom/github/ajalt/mordant/terminal/TerminalDetection\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,199:1\n1#2:200\n1#2:211\n1603#3,9:201\n1855#3:210\n1856#3:212\n1612#3:213\n1747#3,3:214\n*S KotlinDebug\n*F\n+ 1 TerminalDetection.kt\ncom/github/ajalt/mordant/terminal/TerminalDetection\n*L\n168#1:211\n168#1:201,9\n168#1:210\n168#1:212\n168#1:213\n190#1:214,3\n*E\n"})
public final class TerminalDetection {
    @NotNull
    public static final TerminalDetection INSTANCE = new TerminalDetection();

    private TerminalDetection() {
    }

    @NotNull
    public final TerminalInfo detectTerminal(@Nullable AnsiLevel ansiLevel, @Nullable Integer width, @Nullable Integer height, @Nullable Boolean hyperlinks, @Nullable Boolean interactive) {
        boolean outputInteractive;
        boolean ij = this.isIntellijRunActionConsole();
        Boolean bl = interactive;
        boolean inputInteractive = bl != null ? bl : ij || MppImplKt.stdinInteractive();
        Boolean bl2 = interactive;
        boolean bl3 = outputInteractive = bl2 != null ? bl2 : ij || MppImplKt.stdoutInteractive();
        AnsiLevel ansiLevel2 = ansiLevel;
        if (ansiLevel2 == null) {
            ansiLevel2 = this.ansiLevel(outputInteractive);
        }
        AnsiLevel level = ansiLevel2;
        Boolean bl4 = hyperlinks;
        boolean ansiHyperLinks = bl4 != null ? bl4 : outputInteractive && level != AnsiLevel.NONE && this.ansiHyperLinks();
        Size size2 = this.detectInitialSize();
        int w = size2.component1();
        int h = size2.component2();
        Integer n = width;
        Integer n2 = height;
        return new TerminalInfo(n != null ? n : w, n2 != null ? n2 : h, level, ansiHyperLinks, outputInteractive, inputInteractive, ij);
    }

    @Nullable
    public final Size detectSize() {
        return MppImplKt.getTerminalSize();
    }

    private final Size detectInitialSize() {
        Size size2 = MppImplKt.getTerminalSize();
        if (size2 == null) {
            Object object;
            Object object2 = MppImplKt.getEnv("COLUMNS");
            size2 = new Size(object2 != null && (object2 = StringsKt.toIntOrNull((String)object2)) != null ? (Integer)object2 : 79, (object = MppImplKt.getEnv("LINES")) != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : 24);
        }
        return size2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean ansiHyperLinks() {
        if (this.forcedColor() == AnsiLevel.NONE) return false;
        if (this.isCI()) {
            return false;
        }
        if (this.isWindowsTerminal()) {
            return true;
        }
        String string = this.getTermProgram();
        if (string != null) {
            switch (string.hashCode()) {
                case 1246525912: {
                    if (string.equals("wezterm")) return true;
                    break;
                }
                case -1987176184: {
                    if (string.equals("iterm.app")) return this.iTermVersionSupportsTruecolor();
                    break;
                }
                case -1074027929: {
                    if (string.equals("mintty")) return this.minttyVersionSupportsHyperlinks();
                    break;
                }
                case 99761772: {
                    if (!string.equals("hyper")) break;
                    return true;
                }
            }
        }
        if (Intrinsics.areEqual(string = this.getTerm(), "xterm-kitty")) {
            return true;
        }
        boolean bl = Intrinsics.areEqual(string, "alacritty");
        if (!bl) return false;
        return true;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final AnsiLevel ansiLevel(boolean interactive) {
        block81: {
            block77: {
                block80: {
                    block78: {
                        block79: {
                            block76: {
                                var2_2 /* !! */  = this.forcedColor();
                                if (var2_2 /* !! */  != null) {
                                    it = var2_2 /* !! */ ;
                                    $i$a$-let-TerminalDetection$ansiLevel$1 = false;
                                    return it;
                                }
                                if (this.isIntellijRunActionConsole() || this.isVsCodeTerminal()) {
                                    return AnsiLevel.TRUECOLOR;
                                }
                                if (!interactive) {
                                    return AnsiLevel.NONE;
                                }
                                if (this.isWindowsTerminal() || this.isDomTerm()) {
                                    return AnsiLevel.TRUECOLOR;
                                }
                                if (this.isJediTerm()) {
                                    return AnsiLevel.TRUECOLOR;
                                }
                                var2_2 /* !! */  = this.getColorTerm();
                                if (var2_2 /* !! */  == null) break block76;
                                switch (var2_2 /* !! */ .hashCode()) {
                                    case 47822731: {
                                        if (!var2_2 /* !! */ .equals("24bit")) {
                                            break;
                                        }
                                        ** GOTO lbl27
                                    }
                                    case 1482504776: {
                                        if (!var2_2 /* !! */ .equals("24bits")) {
                                            break;
                                        }
                                        ** GOTO lbl27
                                    }
                                    case 1350697621: {
                                        if (!var2_2 /* !! */ .equals("truecolor")) break;
lbl27:
                                        // 3 sources

                                        return AnsiLevel.TRUECOLOR;
                                    }
                                }
                            }
                            if (this.isCI()) {
                                return this.ciSupportsColor() != false ? AnsiLevel.ANSI256 : AnsiLevel.NONE;
                            }
                            var2_2 /* !! */  = this.getTermProgram();
                            if (var2_2 /* !! */  == null) break block77;
                            switch (var2_2 /* !! */ .hashCode()) {
                                case 1246525912: {
                                    if (!var2_2 /* !! */ .equals("wezterm")) {
                                        ** break;
                                    }
                                    break block78;
                                }
                                case -1987176184: {
                                    if (!var2_2 /* !! */ .equals("iterm.app")) {
                                        ** break;
                                    }
                                    break block79;
                                }
                                case 1015440833: {
                                    if (var2_2 /* !! */ .equals("apple_terminal")) break;
                                    ** break;
                                }
                                case -1074027929: {
                                    if (!var2_2 /* !! */ .equals("mintty")) {
                                        ** break;
                                    }
                                    break block80;
                                }
                                case 99761772: {
                                    if (!var2_2 /* !! */ .equals("hyper")) ** break;
                                    return AnsiLevel.TRUECOLOR;
                                }
                            }
                            return AnsiLevel.ANSI256;
                        }
                        return this.iTermVersionSupportsTruecolor() != false ? AnsiLevel.TRUECOLOR : AnsiLevel.ANSI256;
                    }
                    return AnsiLevel.TRUECOLOR;
                }
                return AnsiLevel.TRUECOLOR;
            }
            if ((var3_7 = this.getTerm()) == null || (it = StringsKt.split$default((CharSequence)var3_7, (String[])($i$a$-let-TerminalDetection$ansiLevel$1 = new String[]{"-"}), false, 0, 6, null)) == null) ** GOTO lbl-1000
            it = it;
            $i$a$-let-TerminalDetection$ansiLevel$2 = false;
            $i$a$-let-TerminalDetection$ansiLevel$1 = TuplesKt.to(CollectionsKt.firstOrNull(it), CollectionsKt.lastOrNull(it));
            if ($i$a$-let-TerminalDetection$ansiLevel$1 != null) {
                v0 = $i$a$-let-TerminalDetection$ansiLevel$1;
            } else lbl-1000:
            // 2 sources

            {
                v0 = TuplesKt.to(null, null);
            }
            var2_2 /* !! */  = v0;
            term = (String)var2_2 /* !! */ .component1();
            level = (String)var2_2 /* !! */ .component2();
            $i$a$-let-TerminalDetection$ansiLevel$1 = level;
            if ($i$a$-let-TerminalDetection$ansiLevel$1 == null) break block81;
            tmp = -1;
            switch ($i$a$-let-TerminalDetection$ansiLevel$1.hashCode()) {
                case -1619924752: {
                    if ($i$a$-let-TerminalDetection$ansiLevel$1.equals("256color")) {
                        tmp = 1;
                    }
                    break;
                }
                case 47822731: {
                    if ($i$a$-let-TerminalDetection$ansiLevel$1.equals("24bit")) {
                        tmp = 2;
                    }
                    break;
                }
                case 49747: {
                    if ($i$a$-let-TerminalDetection$ansiLevel$1.equals("256")) {
                        tmp = 1;
                    }
                    break;
                }
                case 1482504776: {
                    if ($i$a$-let-TerminalDetection$ansiLevel$1.equals("24bits")) {
                        tmp = 2;
                    }
                    break;
                }
                case 1350697621: {
                    if ($i$a$-let-TerminalDetection$ansiLevel$1.equals("truecolor")) {
                        tmp = 2;
                    }
                    break;
                }
                case 1321940355: {
                    if ($i$a$-let-TerminalDetection$ansiLevel$1.equals("256colors")) {
                        tmp = 1;
                    }
                    break;
                }
                case -1331586071: {
                    if ($i$a$-let-TerminalDetection$ansiLevel$1.equals("direct")) {
                        tmp = 2;
                    }
                    break;
                }
            }
            switch (tmp) {
                case 1: {
                    return AnsiLevel.ANSI256;
                }
                case 2: {
                    return AnsiLevel.TRUECOLOR;
                }
            }
        }
        if (Intrinsics.areEqual(term, "xterm")) {
            v1 = MppImplKt.getEnv("XTERM_VERSION");
            if (v1 == null) {
                return AnsiLevel.ANSI16;
            }
            xtermVersion = v1;
            v2 = Regex.find$default(new Regex("\\((\\d+)\\)"), xtermVersion, 0, 2, null);
            if (v2 == null) {
                return AnsiLevel.ANSI16;
            }
            m = v2;
            v = Integer.parseInt(m.getGroupValues().get(1));
            if (v >= 331) {
                return AnsiLevel.TRUECOLOR;
            }
            if (v >= 122) {
                return AnsiLevel.ANSI256;
            }
            return AnsiLevel.ANSI16;
        }
        var5_6 = term;
        if (var5_6 == null) ** GOTO lbl-1000
        tmp = -1;
        switch (var5_6.hashCode()) {
            case 3515268: {
                if (var5_6.equals("rxvt")) {
                    tmp = 1;
                }
                break;
            }
            case -1345749109: {
                if (var5_6.equals("cygwin")) {
                    tmp = 2;
                }
                break;
            }
            case 94842723: {
                if (var5_6.equals("color")) {
                    tmp = 1;
                }
                break;
            }
            case 112480882: {
                if (var5_6.equals("vt220")) {
                    tmp = 1;
                }
                break;
            }
            case 112479859: {
                if (var5_6.equals("vt100")) {
                    tmp = 1;
                }
                break;
            }
            case 102977780: {
                if (var5_6.equals("linux")) {
                    tmp = 1;
                }
                break;
            }
            case -538394785: {
                if (var5_6.equals("konsole")) {
                    tmp = 1;
                }
                break;
            }
            case -907689876: {
                if (var5_6.equals("screen")) {
                    tmp = 1;
                }
                break;
            }
            case 3564252: {
                if (var5_6.equals("tmux")) {
                    tmp = 1;
                }
                break;
            }
            case 2999107: {
                if (var5_6.equals("ansi")) {
                    tmp = 1;
                }
                break;
            }
        }
        switch (tmp) {
            case 2: {
                v3 = AnsiLevel.TRUECOLOR;
                break;
            }
            case 1: {
                v3 = AnsiLevel.ANSI16;
                break;
            }
            default: lbl-1000:
            // 2 sources

            {
                v3 = AnsiLevel.NONE;
            }
        }
        return v3;
    }

    private final String getTerm() {
        String string;
        String string2 = MppImplKt.getEnv("TERM");
        if (string2 != null) {
            String string3 = string2.toLowerCase(Locale.ROOT);
            string = string3;
            Intrinsics.checkNotNullExpressionValue(string3, "toLowerCase(...)");
        } else {
            string = null;
        }
        return string;
    }

    private final String getColorTerm() {
        String string;
        String string2 = MppImplKt.getEnv("COLORTERM");
        if (string2 != null) {
            String string3 = string2.toLowerCase(Locale.ROOT);
            string = string3;
            Intrinsics.checkNotNullExpressionValue(string3, "toLowerCase(...)");
        } else {
            string = null;
        }
        return string;
    }

    /*
     * Unable to fully structure code
     */
    private final AnsiLevel forcedColor() {
        block22: {
            block24: {
                block26: {
                    block25: {
                        block23: {
                            block21: {
                                if (!Intrinsics.areEqual(this.getTerm(), "dumb")) break block21;
                                v0 = AnsiLevel.NONE;
                                break block22;
                            }
                            if (MppImplKt.getEnv("NO_COLOR") == null) break block23;
                            v0 = AnsiLevel.NONE;
                            break block22;
                        }
                        v1 = MppImplKt.getEnv("FORCE_COLOR");
                        if (v1 != null) {
                            v2 = v1.toLowerCase(Locale.ROOT);
                            v3 = v2;
                            Intrinsics.checkNotNullExpressionValue(v2, "toLowerCase(...)");
                        } else {
                            v3 = var1_1 = null;
                        }
                        if (var1_1 == null) break block24;
                        switch (var1_1.hashCode()) {
                            case 48: {
                                if (!var1_1.equals("0")) {
                                    ** break;
                                }
                                ** GOTO lbl57
                            }
                            case 0: {
                                if (var1_1.equals("")) break;
                                ** break;
                            }
                            case -2116143010: {
                                if (var1_1.equals("16color")) break;
                                ** break;
                            }
                            case 49: {
                                if (var1_1.equals("1")) break;
                                ** break;
                            }
                            case -1619924752: {
                                if (!var1_1.equals("256color")) {
                                    ** break;
                                }
                                break block25;
                            }
                            case 50: {
                                if (!var1_1.equals("2")) {
                                    ** break;
                                }
                                break block25;
                            }
                            case 51: {
                                if (!var1_1.equals("3")) {
                                    ** break;
                                }
                                break block26;
                            }
                            case 1350697621: {
                                if (!var1_1.equals("truecolor")) {
                                    ** break;
                                }
                                break block26;
                            }
                            case 97196323: {
                                if (!var1_1.equals("false")) {
                                    ** break;
                                }
                                ** GOTO lbl57
                            }
                            case 3569038: {
                                if (var1_1.equals("true")) break;
                                ** break;
                            }
                            case 3387192: {
                                if (!var1_1.equals("none")) ** break;
lbl57:
                                // 3 sources

                                v0 = AnsiLevel.NONE;
                                break block22;
                            }
                        }
                        v0 = AnsiLevel.ANSI16;
                        break block22;
                    }
                    v0 = AnsiLevel.ANSI256;
                    break block22;
                }
                v0 = AnsiLevel.TRUECOLOR;
                break block22;
            }
            v0 = null;
        }
        return v0;
    }

    private final String getTermProgram() {
        String string;
        String string2 = MppImplKt.getEnv("TERM_PROGRAM");
        if (string2 != null) {
            String string3 = string2.toLowerCase(Locale.ROOT);
            string = string3;
            Intrinsics.checkNotNullExpressionValue(string3, "toLowerCase(...)");
        } else {
            string = null;
        }
        return string;
    }

    private final boolean isVsCodeTerminal() {
        return Intrinsics.areEqual(this.getTermProgram(), "vscode");
    }

    private final boolean isWindowsTerminal() {
        CharSequence charSequence = MppImplKt.getEnv("WT_SESSION");
        return !(charSequence == null || charSequence.length() == 0);
    }

    private final boolean isDomTerm() {
        CharSequence charSequence = MppImplKt.getEnv("DOMTERM");
        return !(charSequence == null || charSequence.length() == 0);
    }

    private final boolean isJediTerm() {
        return Intrinsics.areEqual(MppImplKt.getEnv("TERMINAL_EMULATOR"), "JetBrains-JediTerm");
    }

    private final boolean iTermVersionSupportsTruecolor() {
        String[] stringArray;
        Object object = MppImplKt.getEnv("TERM_PROGRAM_VERSION");
        Integer ver = object != null && (object = StringsKt.split$default((CharSequence)object, stringArray = new String[]{"."}, false, 0, 6, null)) != null && (object = (String)CollectionsKt.firstOrNull(object)) != null ? StringsKt.toIntOrNull((String)object) : null;
        return ver != null && ver >= 3;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean minttyVersionSupportsHyperlinks() {
        List ver;
        List list;
        String[] stringArray;
        Object object = MppImplKt.getEnv("TERM_PROGRAM_VERSION");
        if (object != null && (object = StringsKt.split$default((CharSequence)object, stringArray = new String[]{"."}, false, 0, 6, null)) != null) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = (Iterable)object;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Integer it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                String it = (String)element$iv$iv;
                boolean bl2 = false;
                if (StringsKt.toIntOrNull(it) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        List list2 = ver = list;
        if (!(list2 != null ? list2.size() == 3 : false)) {
            return false;
        }
        return ((Number)ver.get(0)).intValue() > 2 || ((Number)ver.get(0)).intValue() == 2 && ((Number)ver.get(1)).intValue() > 9 || ((Number)ver.get(0)).intValue() == 2 && ((Number)ver.get(1)).intValue() == 9 && ((Number)ver.get(2)).intValue() > 6;
    }

    private final boolean isCI() {
        return MppImplKt.getEnv("CI") != null;
    }

    private final boolean ciSupportsColor() {
        boolean bl;
        block3: {
            String[] stringArray = new String[]{"APPVEYOR", "BUILDKITE", "CIRCLECI", "DRONE", "GITHUB_ACTIONS", "GITLAB_CI", "TRAVIS"};
            Iterable $this$any$iv = CollectionsKt.listOf(stringArray);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!(MppImplKt.getEnv(it) != null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean isIntellijRunActionConsole() {
        return !this.isJediTerm() && MppImplKt.runningInIdeaJavaAgent();
    }
}

