/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.generic;

import com.dickimawbooks.texparserlib.ActiveChar;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import com.dickimawbooks.texparserlib.UndefAction;
import java.io.IOException;

public class UndefinedActiveChar
extends ActiveChar {
    private int charCode;
    private UndefAction action;

    public UndefinedActiveChar(int n) {
        this(n, UndefAction.ERROR);
    }

    public UndefinedActiveChar(int n, UndefAction undefAction) {
        this.charCode = n;
        this.action = undefAction;
    }

    @Override
    public TeXObject clone() {
        return new UndefinedActiveChar(this.charCode, this.action);
    }

    @Override
    public int getCharCode() {
        return this.charCode;
    }

    @Override
    public String toString(TeXParser teXParser) {
        return this.format();
    }

    @Override
    public String format() {
        return new String(Character.toChars(this.charCode));
    }

    protected void errOrMsg(TeXParser teXParser) throws TeXSyntaxException {
        switch (this.action) {
            case ERROR: {
                throw new TeXSyntaxException(teXParser, "tex.error.undefined_char", new String(Character.toChars(this.charCode)));
            }
            case WARN: {
                teXParser.warningMessage("tex.error.undefined_char", new String(Character.toChars(this.charCode)));
                break;
            }
            case MESSAGE: {
                teXParser.message("tex.error.undefined_char", new String(Character.toChars(this.charCode)));
            }
        }
    }

    @Override
    public boolean canExpand() {
        return true;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser) throws IOException {
        this.errOrMsg(teXParser);
        TeXObjectList teXObjectList = new TeXObjectList();
        teXObjectList.add(teXParser.getListener().getOther(this.charCode));
        return teXObjectList;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return this.expandonce(teXParser);
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return this.expandonce(teXParser);
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser) throws IOException {
        return this.expandonce(teXParser);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        this.process(teXParser);
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.errOrMsg(teXParser);
        teXParser.getListener().getWriteable().writeCodePoint(this.charCode);
    }
}

