"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ACTIONS = void 0;
const node_assert_1 = __importDefault(require("node:assert"));
const zigbee_herdsman_1 = require("zigbee-herdsman");
const logger_1 = require("../lib/logger");
const utils = __importStar(require("../lib/utils"));
const NS = "zhc:actions";
/** biome-ignore-end lint/style/useNamingConvention: MQTT convention */
const ClusterHueTouchlink = {
    manuSpecificPhilipsPairing: {
        ID: 0x1000,
        manufacturerCode: zigbee_herdsman_1.Zcl.ManufacturerCode.SIGNIFY_NETHERLANDS_B_V,
        attributes: {},
        commands: {
            hueResetRequest: {
                ID: 0,
                parameters: [
                    { name: "extendedPanId", type: zigbee_herdsman_1.Zcl.DataType.IEEE_ADDR },
                    { name: "serialCount", type: zigbee_herdsman_1.Zcl.DataType.UINT8 },
                    { name: "serialNumbers", type: zigbee_herdsman_1.Zcl.BuffaloZclDataType.LIST_UINT32 },
                ],
            },
        },
        commandsResponse: {},
    },
};
/** biome-ignore-start lint/style/useNamingConvention: MQTT convention */
exports.ACTIONS = {
    raw: async (controller, args) => {
        const payload = args;
        const rawPayload = {
            ieeeAddress: payload.ieee_address,
            networkAddress: payload.network_address,
            groupId: payload.group_id,
            dstEndpoint: payload.dst_endpoint,
            srcEndpoint: payload.src_endpoint,
            interPan: payload.interpan,
            profileId: payload.profile_id,
            clusterKey: payload.cluster_key,
            zdoParams: payload.zdo_params,
            disableResponse: payload.disable_response,
            timeout: payload.timeout,
        };
        if (payload.zcl && typeof payload.zcl === "object") {
            rawPayload.zcl = {
                frameType: payload.zcl.frame_type,
                direction: payload.zcl.direction,
                disableDefaultResponse: payload.zcl.disable_default_response,
                manufacturerCode: payload.zcl.manufacturer_code,
                tsn: payload.zcl.tsn,
                commandKey: payload.zcl.command_key,
                payload: payload.zcl.payload,
            };
        }
        return await controller.sendRaw(rawPayload);
    },
    philips_hue_factory_reset: async (controller, args) => {
        let extendedPanId = args.extended_pan_id;
        if (!extendedPanId) {
            extendedPanId = (await controller.getNetworkParameters()).extendedPanID;
        }
        (0, node_assert_1.default)(typeof extendedPanId === "string" && /^0x[a-f0-9]{16}$/i.test(extendedPanId));
        (0, node_assert_1.default)(Array.isArray(args.serial_numbers) &&
            args.serial_numbers.length > 0 &&
            args.serial_numbers.every((sn) => typeof sn === "string" && /^[a-f0-9]{6}$/i.test(sn)), "serial_numbers must be an array of 6-character hex strings");
        const serialNumbers = args.serial_numbers.map((sn) => Number.parseInt(`0x${sn}`, 16));
        const rawPayload = {
            clusterKey: "manuSpecificPhilipsPairing",
            interPan: true,
            zcl: {
                frameType: zigbee_herdsman_1.Zcl.FrameType.SPECIFIC,
                direction: zigbee_herdsman_1.Zcl.Direction.CLIENT_TO_SERVER,
                disableDefaultResponse: true,
                manufacturerCode: zigbee_herdsman_1.Zcl.ManufacturerCode.SIGNIFY_NETHERLANDS_B_V,
                tsn: 0,
                commandKey: "hueResetRequest",
                payload: { extendedPanId, serialCount: args.serial_numbers.length, serialNumbers },
            },
            disableResponse: true,
        };
        controller.touchlink.lock(true);
        try {
            for (const channel of [11, 15, 20, 25, 12, 13, 14, 16, 17, 18, 19, 21, 22, 23, 24, 26]) {
                await controller.touchlink.setChannelInterPAN(channel);
                try {
                    await controller.sendRaw(rawPayload, ClusterHueTouchlink);
                    // Try not to completely flood the airspace
                    await utils.sleep(1000);
                }
                catch (error) {
                    logger_1.logger.warning(`Hue reset request failed to send: '${error}'`, NS);
                }
            }
        }
        finally {
            controller.touchlink.restoreChannelInterPAN();
            controller.touchlink.lock(false);
        }
    },
};
/** biome-ignore-end lint/style/useNamingConvention: MQTT convention */
//# sourceMappingURL=actions.js.map