/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.log;

import org.apache.juli.logging.Log;

public class UserDataHelper {
    private final Log log;
    private final Config config;
    private final long suppressionTime;
    private volatile long lastInfoTime = 0L;

    public UserDataHelper(Log log) {
        Config config;
        this.log = log;
        String string = System.getProperty("org.apache.juli.logging.UserDataHelper.CONFIG");
        if (string == null) {
            config = Config.INFO_THEN_DEBUG;
        } else {
            try {
                config = Config.valueOf(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                config = Config.INFO_THEN_DEBUG;
            }
        }
        this.suppressionTime = (long)Integer.getInteger("org.apache.juli.logging.UserDataHelper.SUPPRESSION_TIME", 86400).intValue() * 1000L;
        if (this.suppressionTime == 0L) {
            config = Config.INFO_ALL;
        }
        this.config = config;
    }

    public Mode getNextMode() {
        if (Config.NONE == this.config) {
            return null;
        }
        if (Config.DEBUG_ALL == this.config) {
            return this.log.isDebugEnabled() ? Mode.DEBUG : null;
        }
        if (Config.INFO_THEN_DEBUG == this.config) {
            if (this.logAtInfo()) {
                return this.log.isInfoEnabled() ? Mode.INFO_THEN_DEBUG : null;
            }
            return this.log.isDebugEnabled() ? Mode.DEBUG : null;
        }
        if (Config.INFO_ALL == this.config) {
            return this.log.isInfoEnabled() ? Mode.INFO : null;
        }
        return null;
    }

    private boolean logAtInfo() {
        if (this.suppressionTime < 0L && this.lastInfoTime > 0L) {
            return false;
        }
        long l = System.currentTimeMillis();
        if (this.lastInfoTime + this.suppressionTime > l) {
            return false;
        }
        this.lastInfoTime = l;
        return true;
    }

    private static enum Config {
        NONE,
        DEBUG_ALL,
        INFO_THEN_DEBUG,
        INFO_ALL;

    }

    public static enum Mode {
        DEBUG,
        INFO_THEN_DEBUG,
        INFO;

    }
}

