info = {
    "name": "fo",
    "date_order": "DMY",
    "january": [
        "jan",
        "januar"
    ],
    "february": [
        "feb",
        "februar"
    ],
    "march": [
        "mar",
        "mars"
    ],
    "april": [
        "apr",
        "apríl"
    ],
    "may": [
        "mai"
    ],
    "june": [
        "jun",
        "juni"
    ],
    "july": [
        "jul",
        "juli"
    ],
    "august": [
        "aug",
        "august"
    ],
    "september": [
        "sep",
        "september"
    ],
    "october": [
        "okt",
        "oktober"
    ],
    "november": [
        "nov",
        "november"
    ],
    "december": [
        "des",
        "desember"
    ],
    "monday": [
        "mán",
        "mánadagur"
    ],
    "tuesday": [
        "týs",
        "týsdagur"
    ],
    "wednesday": [
        "mik",
        "mikudagur"
    ],
    "thursday": [
        "hós",
        "hósdagur"
    ],
    "friday": [
        "frí",
        "fríggjadagur"
    ],
    "saturday": [
        "ley",
        "leygardagur"
    ],
    "sunday": [
        "sun",
        "sunnudagur"
    ],
    "am": [
        "am"
    ],
    "pm": [
        "pm"
    ],
    "year": [
        "ár"
    ],
    "month": [
        "mnð",
        "mánaður"
    ],
    "week": [
        "v",
        "vi",
        "vika"
    ],
    "day": [
        "d",
        "da",
        "dagur"
    ],
    "hour": [
        "t",
        "tími"
    ],
    "minute": [
        "m",
        "min",
        "minuttur"
    ],
    "second": [
        "s",
        "sek",
        "sekund"
    ],
    "relative-type": {
        "0 day ago": [
            "í dag"
        ],
        "0 hour ago": [
            "hendan tíman"
        ],
        "0 minute ago": [
            "hendan minuttin"
        ],
        "0 month ago": [
            "henda mánaðin"
        ],
        "0 second ago": [
            "nú"
        ],
        "0 week ago": [
            "hesu viku"
        ],
        "0 year ago": [
            "í ár"
        ],
        "1 day ago": [
            "í gjár"
        ],
        "1 month ago": [
            "seinasta mánað"
        ],
        "1 week ago": [
            "seinastu viku"
        ],
        "1 year ago": [
            "í fjør"
        ],
        "in 1 day": [
            "í morgin"
        ],
        "in 1 month": [
            "næsta mánað"
        ],
        "in 1 week": [
            "næstu viku"
        ],
        "in 1 year": [
            "næsta ár"
        ]
    },
    "relative-type-regex": {
        "\\1 day ago": [
            "(\\d+[.,]?\\d*) d síðan",
            "(\\d+[.,]?\\d*) da síðan",
            "(\\d+[.,]?\\d*) dagar síðan",
            "(\\d+[.,]?\\d*) dagur síðan"
        ],
        "\\1 hour ago": [
            "(\\d+[.,]?\\d*) t síðan",
            "(\\d+[.,]?\\d*) tímar síðan",
            "(\\d+[.,]?\\d*) tími síðan"
        ],
        "\\1 minute ago": [
            "(\\d+[.,]?\\d*) m síðan",
            "(\\d+[.,]?\\d*) min síðan",
            "(\\d+[.,]?\\d*) minutt síðan",
            "(\\d+[.,]?\\d*) minuttir síðan"
        ],
        "\\1 month ago": [
            "(\\d+[.,]?\\d*) mnð síðan",
            "(\\d+[.,]?\\d*) mánað síðan",
            "(\\d+[.,]?\\d*) mánaðir síðan"
        ],
        "\\1 second ago": [
            "(\\d+[.,]?\\d*) s síðan",
            "(\\d+[.,]?\\d*) sek síðan",
            "(\\d+[.,]?\\d*) sekund síðan"
        ],
        "\\1 week ago": [
            "(\\d+[.,]?\\d*) v síðan",
            "(\\d+[.,]?\\d*) vi síðan",
            "(\\d+[.,]?\\d*) vika síðan",
            "(\\d+[.,]?\\d*) vikur síðan"
        ],
        "\\1 year ago": [
            "(\\d+[.,]?\\d*) ár síðan"
        ],
        "in \\1 day": [
            "um (\\d+[.,]?\\d*) d",
            "um (\\d+[.,]?\\d*) da",
            "um (\\d+[.,]?\\d*) dag",
            "um (\\d+[.,]?\\d*) dagar"
        ],
        "in \\1 hour": [
            "um (\\d+[.,]?\\d*) t",
            "um (\\d+[.,]?\\d*) tíma",
            "um (\\d+[.,]?\\d*) tímar"
        ],
        "in \\1 minute": [
            "um (\\d+[.,]?\\d*) m",
            "um (\\d+[.,]?\\d*) min",
            "um (\\d+[.,]?\\d*) minutt",
            "um (\\d+[.,]?\\d*) minuttir"
        ],
        "in \\1 month": [
            "um (\\d+[.,]?\\d*) mnð",
            "um (\\d+[.,]?\\d*) mánað",
            "um (\\d+[.,]?\\d*) mánaðir"
        ],
        "in \\1 second": [
            "um (\\d+[.,]?\\d*) s",
            "um (\\d+[.,]?\\d*) sek",
            "um (\\d+[.,]?\\d*) sekund"
        ],
        "in \\1 week": [
            "um (\\d+[.,]?\\d*) v",
            "um (\\d+[.,]?\\d*) vi",
            "um (\\d+[.,]?\\d*) viku",
            "um (\\d+[.,]?\\d*) vikur"
        ],
        "in \\1 year": [
            "um (\\d+[.,]?\\d*) ár"
        ]
    },
    "locale_specific": {
        "fo-DK": {
            "name": "fo-DK"
        }
    },
    "skip": [
        " ",
        "'",
        ",",
        "-",
        ".",
        "/",
        ";",
        "@",
        "[",
        "]",
        "|",
        "，"
    ]
}
