/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.jlanguage.hunspell;

import ai.grazie.spell.lists.hunspell.HunspellWordList;
import com.intellij.openapi.progress.ProgressManager;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.languagetool.rules.spelling.hunspell.HunspellDictionary;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\u0012\u001a\u00020\nH\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/grazie/jlanguage/hunspell/LuceneHunspellDictionary;", "Lorg/languagetool/rules/spelling/hunspell/HunspellDictionary;", "dictionary", "Ljava/nio/file/Path;", "affix", "<init>", "(Ljava/nio/file/Path;Ljava/nio/file/Path;)V", "dict", "Lai/grazie/spell/lists/hunspell/HunspellWordList;", "spell", "", "word", "", "add", "", "suggest", "", "closed", "isClosed", "close", "", "intellij.grazie.core"})
public final class LuceneHunspellDictionary
implements HunspellDictionary {
    @NotNull
    private final HunspellWordList dict;
    private boolean closed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LuceneHunspellDictionary(@NotNull Path dictionary, @NotNull Path affix) {
        HunspellWordList hunspellWordList;
        Intrinsics.checkNotNullParameter((Object)dictionary, (String)"dictionary");
        Intrinsics.checkNotNullParameter((Object)affix, (String)"affix");
        OpenOption[] openOptionArray = new OpenOption[]{};
        InputStream inputStream = Files.newInputStream(affix, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
        Closeable closeable = inputStream;
        LuceneHunspellDictionary luceneHunspellDictionary = this;
        Throwable throwable = null;
        try {
            HunspellWordList hunspellWordList2;
            InputStream affix2 = (InputStream)closeable;
            boolean bl = false;
            OpenOption[] openOptionArray2 = new OpenOption[]{};
            InputStream inputStream2 = Files.newInputStream(dictionary, Arrays.copyOf(openOptionArray2, openOptionArray2.length));
            Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"newInputStream(...)");
            Closeable closeable2 = inputStream2;
            Throwable throwable2 = null;
            try {
                InputStream dictionary2 = (InputStream)closeable2;
                boolean bl2 = false;
                hunspellWordList2 = new HunspellWordList(affix2, dictionary2, LuceneHunspellDictionary::dict$lambda$0$0$0, 0L, 8, null);
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            hunspellWordList = hunspellWordList2;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        luceneHunspellDictionary.dict = hunspellWordList;
    }

    public boolean spell(@NotNull String word) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        return this.dict.contains(word, false);
    }

    @NotNull
    public Void add(@NotNull String word) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        throw new UnsupportedOperationException();
    }

    @NotNull
    public List<String> suggest(@NotNull String word) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        return CollectionsKt.toList((Iterable)this.dict.suggest(word));
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void close() {
        this.closed = true;
    }

    private static final void dict$lambda$0$0$0() {
        ProgressManager.checkCanceled();
    }
}

