/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.LocallyDeletedChange;
import com.intellij.openapi.vcs.changes.LogicalLock;
import com.intellij.openapi.vcs.changes.RemoteRevisionsCache;
import com.intellij.openapi.vcs.changes.ui.ChangeListRemoteState;
import com.intellij.openapi.vcs.changes.ui.ChangeNodeDecorator;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserLocallyDeletedNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserLockedFoldersNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserLogicallyLockedFile;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserSpecificFilesNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserStringNode;
import com.intellij.openapi.vcs.changes.ui.ModifiedWithoutEditingNode;
import com.intellij.openapi.vcs.changes.ui.RemoteStatusChangeNodeDecorator;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.vcs.impl.shared.changes.TreeModelBuilderEx;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcsUtil.VcsUtil;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u0014*\u00020\u00142\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017J\u001e\u0010\u0019\u001a\u00020\u0014*\u00020\u00142\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u00180\u001bJ\u0018\u0010\u001d\u001a\u00020\u0014*\u00020\u00142\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fJ \u0010!\u001a\u00020\u0014*\u00020\u00142\u0014\u0010\"\u001a\u0010\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u001c\u0018\u00010#J\u0018\u0010$\u001a\u00020\u0014*\u00020\u00142\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017J\u001e\u0010&\u001a\u00020\u0014*\u00020\u00142\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020(0#R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/BackendChangesViewModelBuilderService;", "Lcom/intellij/platform/vcs/impl/shared/changes/TreeModelBuilderEx;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "revisionsCache", "Lcom/intellij/openapi/vcs/changes/RemoteRevisionsCache;", "kotlin.jvm.PlatformType", "getChangeNodeInChangelistBaseDecorator", "Lcom/intellij/openapi/vcs/changes/ui/ChangeNodeDecorator;", "listRemoteState", "Lcom/intellij/openapi/vcs/changes/ui/ChangeListRemoteState;", "change", "Lcom/intellij/openapi/vcs/changes/Change;", "index", "", "modifyTreeModelBuilder", "", "modelBuilder", "Lcom/intellij/openapi/vcs/changes/ui/TreeModelBuilder;", "setModifiedWithoutEditing", "modifiedWithoutEditing", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "setSwitchedFiles", "switchedFiles", "Lcom/intellij/util/containers/MultiMap;", "", "setLocallyDeletedPaths", "locallyDeletedChanges", "", "Lcom/intellij/openapi/vcs/changes/LocallyDeletedChange;", "setSwitchedRoots", "switchedRoots", "", "setLockedFolders", "lockedFolders", "setLogicallyLockedFiles", "logicallyLockedFiles", "Lcom/intellij/openapi/vcs/changes/LogicalLock;", "intellij.platform.vcs.impl"})
public final class BackendChangesViewModelBuilderService
implements TreeModelBuilderEx {
    @NotNull
    private final Project project;
    private final RemoteRevisionsCache revisionsCache;

    public BackendChangesViewModelBuilderService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.revisionsCache = RemoteRevisionsCache.getInstance(this.project);
    }

    @NotNull
    public ChangeNodeDecorator getChangeNodeInChangelistBaseDecorator(@NotNull ChangeListRemoteState listRemoteState, @NotNull Change change, int index) {
        Intrinsics.checkNotNullParameter((Object)listRemoteState, (String)"listRemoteState");
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        RemoteRevisionsCache remoteRevisionsCache = this.revisionsCache;
        Intrinsics.checkNotNullExpressionValue((Object)remoteRevisionsCache, (String)"revisionsCache");
        return new RemoteStatusChangeNodeDecorator(remoteRevisionsCache, listRemoteState, index);
    }

    public void modifyTreeModelBuilder(@NotNull TreeModelBuilder modelBuilder) {
        Intrinsics.checkNotNullParameter((Object)modelBuilder, (String)"modelBuilder");
        ChangeListManagerImpl changeListManager = ChangeListManagerImpl.getInstanceImpl(this.project);
        List<LocallyDeletedChange> list = changeListManager.getDeletedFiles();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getDeletedFiles(...)");
        TreeModelBuilder treeModelBuilder = this.setLocallyDeletedPaths(modelBuilder, (Collection<? extends LocallyDeletedChange>)list);
        List<VirtualFile> list2 = changeListManager.getModifiedWithoutEditing();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getModifiedWithoutEditing(...)");
        TreeModelBuilder treeModelBuilder2 = this.setModifiedWithoutEditing(treeModelBuilder, list2);
        MultiMap<String, VirtualFile> multiMap = changeListManager.getSwitchedFilesMap();
        Intrinsics.checkNotNullExpressionValue(multiMap, (String)"getSwitchedFilesMap(...)");
        TreeModelBuilder treeModelBuilder3 = this.setSwitchedRoots(this.setSwitchedFiles(treeModelBuilder2, multiMap), changeListManager.getSwitchedRoots());
        List<VirtualFile> list3 = changeListManager.getLockedFolders();
        Intrinsics.checkNotNullExpressionValue(list3, (String)"getLockedFolders(...)");
        TreeModelBuilder treeModelBuilder4 = this.setLockedFolders(treeModelBuilder3, list3);
        Map<VirtualFile, LogicalLock> map = changeListManager.getLogicallyLockedFolders();
        Intrinsics.checkNotNullExpressionValue(map, (String)"getLogicallyLockedFolders(...)");
        this.setLogicallyLockedFiles(treeModelBuilder4, map);
    }

    @NotNull
    public final TreeModelBuilder setModifiedWithoutEditing(@NotNull TreeModelBuilder $this$setModifiedWithoutEditing, @NotNull List<? extends VirtualFile> modifiedWithoutEditing) {
        Intrinsics.checkNotNullParameter((Object)$this$setModifiedWithoutEditing, (String)"<this>");
        Intrinsics.checkNotNullParameter(modifiedWithoutEditing, (String)"modifiedWithoutEditing");
        if (ContainerUtil.isEmpty((Collection)modifiedWithoutEditing)) {
            return $this$setModifiedWithoutEditing;
        }
        ModifiedWithoutEditingNode node = new ModifiedWithoutEditingNode(this.project, modifiedWithoutEditing);
        TreeModelBuilder treeModelBuilder = $this$setModifiedWithoutEditing.insertSpecificFileNodeToModel(modifiedWithoutEditing, (ChangesBrowserSpecificFilesNode)node);
        Intrinsics.checkNotNullExpressionValue((Object)treeModelBuilder, (String)"insertSpecificFileNodeToModel(...)");
        return treeModelBuilder;
    }

    @NotNull
    public final TreeModelBuilder setSwitchedFiles(@NotNull TreeModelBuilder $this$setSwitchedFiles, @NotNull MultiMap<String, VirtualFile> switchedFiles) {
        Intrinsics.checkNotNullParameter((Object)$this$setSwitchedFiles, (String)"<this>");
        Intrinsics.checkNotNullParameter(switchedFiles, (String)"switchedFiles");
        if (switchedFiles.isEmpty()) {
            return $this$setSwitchedFiles;
        }
        ChangesBrowserNode changesBrowserNode = $this$setSwitchedFiles.createTagNode(ChangesBrowserNode.SWITCHED_FILES_TAG);
        Intrinsics.checkNotNullExpressionValue((Object)changesBrowserNode, (String)"createTagNode(...)");
        ChangesBrowserNode subtreeRoot = changesBrowserNode;
        for (String branchName : switchedFiles.keySet()) {
            Collection collection = switchedFiles.get((Object)branchName);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"get(...)");
            Iterable iterable = collection;
            Comparator comparator = TreeModelBuilder.FILE_COMPARATOR;
            Intrinsics.checkNotNullExpressionValue((Object)comparator, (String)"FILE_COMPARATOR");
            List switchedFileList = CollectionsKt.sortedWith((Iterable)iterable, (Comparator)comparator);
            if (switchedFileList.isEmpty()) continue;
            ChangesBrowserStringNode branchNode = new ChangesBrowserStringNode(branchName);
            branchNode.markAsHelperNode();
            $this$setSwitchedFiles.insertSubtreeRoot((ChangesBrowserNode)branchNode, subtreeRoot);
            for (VirtualFile file : switchedFileList) {
                $this$setSwitchedFiles.insertChangeNode(file, (ChangesBrowserNode)branchNode, ChangesBrowserNode.createFile((Project)this.project, (VirtualFile)file));
            }
        }
        return $this$setSwitchedFiles;
    }

    @NotNull
    public final TreeModelBuilder setLocallyDeletedPaths(@NotNull TreeModelBuilder $this$setLocallyDeletedPaths, @NotNull Collection<? extends LocallyDeletedChange> locallyDeletedChanges) {
        Intrinsics.checkNotNullParameter((Object)$this$setLocallyDeletedPaths, (String)"<this>");
        Intrinsics.checkNotNullParameter(locallyDeletedChanges, (String)"locallyDeletedChanges");
        if (locallyDeletedChanges.isEmpty()) {
            return $this$setLocallyDeletedPaths;
        }
        ChangesBrowserNode changesBrowserNode = $this$setLocallyDeletedPaths.createTagNode(ChangesBrowserNode.LOCALLY_DELETED_NODE_TAG);
        Intrinsics.checkNotNullExpressionValue((Object)changesBrowserNode, (String)"createTagNode(...)");
        ChangesBrowserNode subtreeRoot = changesBrowserNode;
        Iterable iterable = locallyDeletedChanges;
        Comparator comparator = TreeModelBuilder.PATH_COMPARATOR;
        Intrinsics.checkNotNullExpressionValue((Object)comparator, (String)"PATH_COMPARATOR");
        Comparator comparator2 = comparator;
        for (LocallyDeletedChange change : CollectionsKt.sortedWith((Iterable)iterable, (Comparator)new Comparator(comparator2){
            final /* synthetic */ Comparator $comparator;
            {
                this.$comparator = $comparator;
            }

            public final int compare(T a, T b) {
                LocallyDeletedChange locallyDeletedChange = (LocallyDeletedChange)a;
                Comparator comparator = this.$comparator;
                boolean bl = false;
                LocallyDeletedChange it = (LocallyDeletedChange)b;
                FilePath filePath = it.getPath();
                bl = false;
                FilePath filePath2 = it.getPath();
                return comparator.compare(filePath, filePath2);
            }
        })) {
            $this$setLocallyDeletedPaths.insertChangeNode(change.getPath(), subtreeRoot, (ChangesBrowserNode)new ChangesBrowserLocallyDeletedNode(change));
        }
        return $this$setLocallyDeletedPaths;
    }

    @NotNull
    public final TreeModelBuilder setSwitchedRoots(@NotNull TreeModelBuilder $this$setSwitchedRoots, @Nullable Map<VirtualFile, String> switchedRoots) {
        Intrinsics.checkNotNullParameter((Object)$this$setSwitchedRoots, (String)"<this>");
        if (switchedRoots == null || switchedRoots.isEmpty()) {
            return $this$setSwitchedRoots;
        }
        ChangesBrowserNode changesBrowserNode = $this$setSwitchedRoots.createTagNode(ChangesBrowserNode.SWITCHED_ROOTS_TAG, SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES, true);
        Intrinsics.checkNotNullExpressionValue((Object)changesBrowserNode, (String)"createTagNode(...)");
        ChangesBrowserNode rootsHeadNode = changesBrowserNode;
        Comparator comparator = TreeModelBuilder.FILE_COMPARATOR;
        Intrinsics.checkNotNullExpressionValue((Object)comparator, (String)"FILE_COMPARATOR");
        for (Map.Entry entry : ((Map)MapsKt.toSortedMap(switchedRoots, (Comparator)comparator)).entrySet()) {
            VirtualFile vf = (VirtualFile)entry.getKey();
            String branchName = (String)entry.getValue();
            CurrentContentRevision cr = new CurrentContentRevision(VcsUtil.getFilePath((VirtualFile)vf));
            Change change = new Change((ContentRevision)cr, (ContentRevision)cr, FileStatus.NOT_CHANGED);
            $this$setSwitchedRoots.insertChangeNode(vf, rootsHeadNode, $this$setSwitchedRoots.createChangeNode(change, new ChangeNodeDecorator(branchName){
                final /* synthetic */ String $branchName;
                {
                    this.$branchName = $branchName;
                }

                public void decorate(Change change1, SimpleColoredComponent component, boolean isShowFlatten) {
                    Intrinsics.checkNotNullParameter((Object)change1, (String)"change1");
                    Intrinsics.checkNotNullParameter((Object)component, (String)"component");
                }

                public void preDecorate(Change change1, ChangesBrowserNodeRenderer renderer, boolean showFlatten) {
                    Intrinsics.checkNotNullParameter((Object)change1, (String)"change1");
                    Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
                    renderer.append("[" + this.$branchName + "] ", SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES);
                }
            }));
        }
        return $this$setSwitchedRoots;
    }

    @NotNull
    public final TreeModelBuilder setLockedFolders(@NotNull TreeModelBuilder $this$setLockedFolders, @NotNull List<? extends VirtualFile> lockedFolders) {
        Intrinsics.checkNotNullParameter((Object)$this$setLockedFolders, (String)"<this>");
        Intrinsics.checkNotNullParameter(lockedFolders, (String)"lockedFolders");
        if (lockedFolders.isEmpty()) {
            return $this$setLockedFolders;
        }
        $this$setLockedFolders.insertFilesIntoNode((Collection)lockedFolders, (ChangesBrowserNode)new ChangesBrowserLockedFoldersNode(this.project));
        return $this$setLockedFolders;
    }

    @NotNull
    public final TreeModelBuilder setLogicallyLockedFiles(@NotNull TreeModelBuilder $this$setLogicallyLockedFiles, @NotNull Map<VirtualFile, LogicalLock> logicallyLockedFiles) {
        Intrinsics.checkNotNullParameter((Object)$this$setLogicallyLockedFiles, (String)"<this>");
        Intrinsics.checkNotNullParameter(logicallyLockedFiles, (String)"logicallyLockedFiles");
        if (logicallyLockedFiles.isEmpty()) {
            return $this$setLogicallyLockedFiles;
        }
        ChangesBrowserNode changesBrowserNode = $this$setLogicallyLockedFiles.createTagNode(ChangesBrowserNode.LOGICALLY_LOCKED_TAG);
        Intrinsics.checkNotNullExpressionValue((Object)changesBrowserNode, (String)"createTagNode(...)");
        ChangesBrowserNode subtreeRoot = changesBrowserNode;
        Comparator comparator = TreeModelBuilder.FILE_COMPARATOR;
        Intrinsics.checkNotNullExpressionValue((Object)comparator, (String)"FILE_COMPARATOR");
        for (Map.Entry entry : ((Map)MapsKt.toSortedMap(logicallyLockedFiles, (Comparator)comparator)).entrySet()) {
            VirtualFile file = (VirtualFile)entry.getKey();
            LogicalLock lock = (LogicalLock)entry.getValue();
            $this$setLogicallyLockedFiles.insertChangeNode(file, subtreeRoot, (ChangesBrowserNode)new ChangesBrowserLogicallyLockedFile(this.project, file, lock));
        }
        return $this$setLogicallyLockedFiles;
    }
}

