/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.iotdb.model;

import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBDatabaseException;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.iotdb.IoTDBPrivilegeInfo;
import org.jkiss.dbeaver.ext.iotdb.model.IoTDBDataSource;
import org.jkiss.dbeaver.ext.iotdb.model.IoTDBGrant;
import org.jkiss.dbeaver.ext.iotdb.model.IoTDBPrivilege;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPQualifiedObject;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPSaveableObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.access.DBARole;
import org.jkiss.dbeaver.model.access.DBAUser;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class IoTDBAbstractUser
implements DBAUser,
DBARole,
DBPRefreshableObject,
DBPSaveableObject,
DBPQualifiedObject {
    private static final Log log = Log.getLog(IoTDBAbstractUser.class);
    protected IoTDBDataSource dataSource;
    public String userName;
    protected boolean persisted;
    protected List<IoTDBGrant> globalPrivileges;
    protected List<IoTDBGrant> schemaPrivileges;

    public IoTDBAbstractUser(IoTDBDataSource dataSource, String userName) {
        this.dataSource = dataSource;
        this.persisted = true;
        this.userName = userName;
    }

    public DBSObject getParentObject() {
        return this.dataSource.getContainer();
    }

    public IoTDBDataSource getDataSource() {
        return this.dataSource;
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.userName;
    }

    @NotNull
    public String getFullyQualifiedName(@NotNull DBPEvaluationContext dbpEvaluationContext) {
        return "";
    }

    @Nullable
    public String getDescription() {
        return null;
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    public void setPersisted(boolean b) {
        this.persisted = b;
        DBUtils.fireObjectUpdate((DBSObject)this);
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void loadGrants(DBRProgressMonitor monitor) throws DBException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Load Grants");){
                String sql = String.format("list privileges of user %s", this.userName);
                JDBCStatement stmt = session.createStatement();
                JDBCResultSet rs = stmt.executeQuery(sql);
                ArrayList<IoTDBGrant> globalPri = new ArrayList<IoTDBGrant>();
                ArrayList<IoTDBGrant> schemaPri = new ArrayList<IoTDBGrant>();
                while (rs.next()) {
                    ArrayList<IoTDBPrivilege> privileges = new ArrayList<IoTDBPrivilege>();
                    String privilegeName = rs.getString("Privileges");
                    IoTDBPrivilege pri = this.dataSource.getPrivilege(monitor, privilegeName);
                    privileges.add(pri);
                    String role = rs.getString("Role");
                    String scope = rs.getString("Scope");
                    boolean grantOption = rs.getBoolean("GrantOption");
                    if (pri.kind == IoTDBPrivilegeInfo.Kind.GLOBAL) {
                        globalPri.add(new IoTDBGrant(this, privileges, role, scope, grantOption));
                        continue;
                    }
                    schemaPri.add(new IoTDBGrant(this, privileges, role, scope, grantOption));
                }
                this.globalPrivileges = globalPri;
                this.schemaPrivileges = schemaPri;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            log.error((Object)"Error loading grants", (Throwable)e);
            throw new DBDatabaseException((Throwable)e, (DBPDataSource)this.getDataSource());
        }
    }

    public List<IoTDBGrant> getGrants(DBRProgressMonitor monitor) throws DBException {
        ArrayList<IoTDBGrant> grants = new ArrayList<IoTDBGrant>();
        if (this.globalPrivileges == null) {
            this.loadGrants(monitor);
        }
        grants.addAll(this.getGlobalPrivileges(monitor));
        grants.addAll(this.getSchemaPrivileges(monitor));
        return grants;
    }

    public List<IoTDBGrant> getGlobalPrivileges(DBRProgressMonitor monitor) throws DBException {
        if (this.globalPrivileges != null) {
            return this.globalPrivileges;
        }
        if (!this.isPersisted()) {
            this.globalPrivileges = new ArrayList<IoTDBGrant>();
            return this.globalPrivileges;
        }
        this.loadGrants(monitor);
        return this.globalPrivileges;
    }

    public List<IoTDBGrant> getSchemaPrivileges(DBRProgressMonitor monitor) throws DBException {
        if (this.schemaPrivileges != null) {
            return this.schemaPrivileges;
        }
        if (!this.isPersisted()) {
            this.schemaPrivileges = new ArrayList<IoTDBGrant>();
            return this.schemaPrivileges;
        }
        this.loadGrants(monitor);
        return this.schemaPrivileges;
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor dbrProgressMonitor) throws DBException {
        this.globalPrivileges = null;
        this.schemaPrivileges = null;
        this.loadGrants(dbrProgressMonitor);
        return this;
    }
}

