# 2023-01-24 Triage Log

Largely a win for compiler performance with 100 test cases in real-world crates showing some sort of change in performance with an average 1% improvement. These wins were a combination of many different changes including how `doc(hidden)` gets more efficiently encoded in metadata, some optimizations in the borrow checker, and simplification of the output from `derive(Debug)` for fieldless enums.

Triage done by **@rylev**.
Revision range: [1f72129f..c8e6a9e8](https://perf.rust-lang.org/?start=1f72129ffe5e8c495113f9a2d4e1730f7fad3209&end=c8e6a9e8b6251bbc8276cb78cabe1998deecbed7&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range           | count |
|:----------------------------------:|:-----:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4%  | [0.2%, 0.7%]    | 19    |
| Regressions ❌ <br /> (secondary)  | 0.9%  | [0.2%, 1.5%]    | 34    |
| Improvements ✅ <br /> (primary)   | -1.3% | [-17.2%, -0.2%] | 81    |
| Improvements ✅ <br /> (secondary) | -2.1% | [-7.1%, -0.2%]  | 64    |
| All ❌✅ (primary)                 | -1.0% | [-17.2%, 0.7%]  | 100   |


2 Regressions, 5 Improvements, 3 Mixed; 1 of them in rollups
34 artifact comparisons made in total

#### Regressions

Check ADT fields for copy implementations considering regions [#105102](https://github.com/rust-lang/rust/pull/105102) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=5ce39f42bd2c8bca9c570f0560ebe1fce4eddb14&end=94a300b9b8eb253c1b809fc44b8c213fd591c537&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.5% | [0.4%, 0.5%] | 6     |
| Regressions ❌ <br /> (secondary)  | 1.7% | [1.4%, 2.0%] | 3     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.5% | [0.4%, 0.5%] | 6     |
- Soundness fix, combined with a small regression means we likely don't need to worry too much about this one.
- [Asked the author and reviewer to comment.](https://github.com/rust-lang/rust/pull/105102#issuecomment-1403713334)


ci: upgrade mingw-check to ubuntu:22.04 [#106948](https://github.com/rust-lang/rust/pull/106948) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=52372f9c71d8ade4cb815524f179119656f0aa2e&end=1c394e1b9abf83f26d68f441e9f0ef0062bde703&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3% | [0.3%, 0.3%] | 2     |
| Regressions ❌ <br /> (secondary)  | 0.7% | [0.6%, 0.8%] | 6     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.3% | [0.3%, 0.3%] | 2     |
- This is noise correcting from [spurious improvements in the previous run](https://perf.rust-lang.org/compare.html?start=005fc0f00f2d4ceaf523b67a8f9c5665b8ac5baf&end=52372f9c71d8ade4cb815524f179119656f0aa2e&stat=instructions:u).


#### Improvements

rustdoc: Revert #104889 [#107083](https://github.com/rust-lang/rust/pull/107083) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=a2bf475d01d0112ded3aa17e40cb335e1524aa8f&end=51d50ea96ecc9c681a0054e5eb8e5e1d4ab38906&stat=instructions:u)

| (instructions:u)                   | mean  | range           | count |
|:----------------------------------:|:-----:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -               | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -               | 0     |
| Improvements ✅ <br /> (primary)   | -4.4% | [-15.7%, -0.5%] | 7     |
| Improvements ✅ <br /> (secondary) | -1.5% | [-1.6%, -1.4%]  | 3     |
| All ❌✅ (primary)                 | -4.4% | [-15.7%, -0.5%] | 7     |


Remove some `ref` patterns from the compiler [#106090](https://github.com/rust-lang/rust/pull/106090) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=51d50ea96ecc9c681a0054e5eb8e5e1d4ab38906&end=56ee85274e5a3a4dda92f3bf73d1664c74ff9c15&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.2% | [-0.2%, -0.1%] | 3     |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.5%, -0.3%] | 5     |
| All ❌✅ (primary)                 | -0.2% | [-0.2%, -0.1%] | 3     |


Lazy dominator tree construction in borrowck [#106976](https://github.com/rust-lang/rust/pull/106976) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=b22aa57fd54c240131c9a31b78213de9f3bee64b&end=21f683935257713eae8549e8b328367006097053&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.4% | [-0.6%, -0.3%] | 26    |
| Improvements ✅ <br /> (secondary) | -0.7% | [-1.0%, -0.3%] | 14    |
| All ❌✅ (primary)                 | -0.4% | [-0.6%, -0.3%] | 26    |


Remap paths in UI tests by default [#105924](https://github.com/rust-lang/rust/pull/105924) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=005fc0f00f2d4ceaf523b67a8f9c5665b8ac5baf&end=52372f9c71d8ade4cb815524f179119656f0aa2e&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.3%, -0.3%] | 2     |
| Improvements ✅ <br /> (secondary) | -0.6% | [-0.8%, -0.3%] | 7     |
| All ❌✅ (primary)                 | -0.3% | [-0.3%, -0.3%] | 2     |


rustc_metadata: Encode `doc(hidden)` flag to metadata [#107136](https://github.com/rust-lang/rust/pull/107136) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=6b3cd03fdb285781c60f5962194719fdfd46d910&end=5bef91c6e902f3bded724713bd2a64ea50abbd25&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.2%  | [0.2%, 0.2%]   | 1     |
| Improvements ✅ <br /> (primary)   | -1.9% | [-5.7%, -0.5%] | 18    |
| Improvements ✅ <br /> (secondary) | -3.3% | [-5.8%, -0.8%] | 28    |
| All ❌✅ (primary)                 | -1.9% | [-5.7%, -0.5%] | 18    |


#### Mixed

Rollup of 9 pull requests [#107143](https://github.com/rust-lang/rust/pull/107143) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=0726909f6d219951ba15ac2f65656eff96bb1867&end=e098eb17e1514bcd604ac4bd57cec362944687af&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3%  | [0.2%, 0.8%]   | 57    |
| Regressions ❌ <br /> (secondary)  | 0.5%  | [0.2%, 1.4%]   | 28    |
| Improvements ✅ <br /> (primary)   | -0.7% | [-1.1%, -0.3%] | 2     |
| Improvements ✅ <br /> (secondary) | -0.7% | [-1.2%, -0.5%] | 8     |
| All ❌✅ (primary)                 | 0.3%  | [-1.1%, 0.8%]  | 59    |
- This rollup contains a perf regression due to #104672
- Probably caused by some changes to inlining. 


Simplify `derive(Debug)` output for fieldless enums [#106884](https://github.com/rust-lang/rust/pull/106884) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=e098eb17e1514bcd604ac4bd57cec362944687af&end=b22aa57fd54c240131c9a31b78213de9f3bee64b&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.8%  | [0.7%, 1.0%]   | 7     |
| Improvements ✅ <br /> (primary)   | -0.5% | [-1.7%, -0.2%] | 22    |
| Improvements ✅ <br /> (secondary) | -1.7% | [-2.9%, -0.5%] | 8     |
| All ❌✅ (primary)                 | -0.5% | [-1.7%, -0.2%] | 22    |
- Improvements outweigh the regressions so I think it's fine if we just take this performance as is.


Use UnordMap and UnordSet for id collections (DefIdMap, LocalDefIdMap, etc) [#106977](https://github.com/rust-lang/rust/pull/106977) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=21f683935257713eae8549e8b328367006097053&end=005fc0f00f2d4ceaf523b67a8f9c5665b8ac5baf&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3%  | [0.2%, 0.3%]   | 2     |
| Regressions ❌ <br /> (secondary)  | 0.6%  | [0.4%, 0.8%]   | 7     |
| Improvements ✅ <br /> (primary)   | -0.5% | [-0.5%, -0.5%] | 3     |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.7%, -0.2%] | 20    |
| All ❌✅ (primary)                 | -0.2% | [-0.5%, 0.3%]  | 5     |
- perf got slightly worse from the original perf run, but it's still enough of a wash that I don't think it needs investigating.
