/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import java.io.Serializable;
import org.apache.spark.SparkException;
import org.apache.spark.ml.feature.FeatureHasher;
import org.apache.spark.ml.util.DefaultParamsReadable;
import org.apache.spark.ml.util.MLReadable;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.mllib.feature.HashingTF$;
import org.apache.spark.unsafe.hash.Murmur3_x86_32;
import org.apache.spark.unsafe.types.UTF8String;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class FeatureHasher$
implements DefaultParamsReadable<FeatureHasher>,
Serializable {
    public static final FeatureHasher$ MODULE$ = new FeatureHasher$();
    private static final int seed;

    static {
        MLReadable.$init$(MODULE$);
        DefaultParamsReadable.$init$(MODULE$);
        seed = HashingTF$.MODULE$.seed();
    }

    @Override
    public MLReader<FeatureHasher> read() {
        return DefaultParamsReadable.read$(this);
    }

    @Override
    public FeatureHasher load(String path) {
        return (FeatureHasher)MLReadable.load$(this, path);
    }

    private int seed() {
        return seed;
    }

    public int murmur3Hash(Object term) {
        int n;
        Object object = term;
        if (object == null) {
            n = this.seed();
        } else if (object instanceof Boolean) {
            boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
            n = Murmur3_x86_32.hashInt((int)(bl ? 1 : 0), (int)this.seed());
        } else if (object instanceof Byte) {
            byte by = BoxesRunTime.unboxToByte((Object)object);
            n = Murmur3_x86_32.hashInt((int)by, (int)this.seed());
        } else if (object instanceof Short) {
            short s = BoxesRunTime.unboxToShort((Object)object);
            n = Murmur3_x86_32.hashInt((int)s, (int)this.seed());
        } else if (object instanceof Integer) {
            int n2 = BoxesRunTime.unboxToInt((Object)object);
            n = Murmur3_x86_32.hashInt((int)n2, (int)this.seed());
        } else if (object instanceof Long) {
            long l = BoxesRunTime.unboxToLong((Object)object);
            n = Murmur3_x86_32.hashLong((long)l, (int)this.seed());
        } else if (object instanceof Float) {
            float f = BoxesRunTime.unboxToFloat((Object)object);
            n = Murmur3_x86_32.hashInt((int)Float.floatToIntBits(f), (int)this.seed());
        } else if (object instanceof Double) {
            double d = BoxesRunTime.unboxToDouble((Object)object);
            n = Murmur3_x86_32.hashLong((long)Double.doubleToLongBits(d), (int)this.seed());
        } else if (object instanceof String) {
            String string = (String)object;
            UTF8String utf8 = UTF8String.fromString((String)string);
            n = Murmur3_x86_32.hashUnsafeBytes2((Object)utf8.getBaseObject(), (long)utf8.getBaseOffset(), (int)utf8.numBytes(), (int)this.seed());
        } else {
            throw new SparkException(new StringBuilder(46).append("FeatureHasher with murmur3 algorithm does not ").append(new StringBuilder(28).append("support type ").append(term.getClass().getCanonicalName()).append(" of input data.").toString()).toString());
        }
        return n;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(FeatureHasher$.class);
    }

    private FeatureHasher$() {
    }
}

