/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.gdal;

import java.lang.invoke.LambdaMetafactory;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.gdal.GDAL;
import org.apache.sis.storage.gdal.GDALStore;
import org.apache.sis.storage.gdal.Subdataset;
import org.apache.sis.util.collection.BackingStoreException;
import org.opengis.util.GenericName;
import org.opengis.util.NameFactory;

final class SubdatasetList
extends AbstractList<Subdataset> {
    private static final int URL = 0;
    private static final int DESCRIPTION = 1;
    private final GDALStore parent;
    private final String[] urls;
    private final String[] descriptions;
    private final Subdataset[] components;
    private final String driver;

    SubdatasetList(GDAL gdal, GDALStore parent, String driver, List<String> metadata) throws DataStoreException {
        this.parent = parent;
        this.driver = driver;
        LinkedHashMap<String, String[]> subdatasets = new LinkedHashMap<String, String[]>(metadata.size());
        for (String item : metadata) {
            String value;
            int splitAt = item.indexOf(61);
            if (splitAt <= 0) continue;
            int index = 0;
            String key = SubdatasetList.separateKey(item, splitAt, "_NAME");
            if (key == null) {
                key = SubdatasetList.separateKey(item, splitAt, "_DESC");
                if (key == null) continue;
                index = 1;
            }
            subdatasets.computeIfAbsent(key, (Function<String, String[]>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$new$0(java.lang.String ), (Ljava/lang/String;)[Ljava/lang/String;)())[index] = value = item.substring(splitAt + 1).trim();
        }
        int i = subdatasets.size();
        this.urls = new String[i];
        this.descriptions = new String[i];
        this.components = new Subdataset[i];
        i = 0;
        for (String[] entry : subdatasets.values()) {
            this.urls[i] = entry[0];
            this.descriptions[i++] = entry[1];
        }
    }

    private static String separateKey(String item, int splitAt, String suffix) {
        int length = suffix.length();
        if (item.regionMatches(true, splitAt -= length, suffix, 0, length)) {
            return item.substring(0, splitAt).trim().toUpperCase(Locale.US);
        }
        return null;
    }

    @Override
    public int size() {
        return this.components.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Subdataset get(int index) {
        GDALStore gDALStore = this.parent;
        synchronized (gDALStore) {
            Subdataset component = this.components[index];
            if (component == null) {
                try {
                    String identifier;
                    String url = this.urls[index];
                    component = new Subdataset(this.parent, url, this.driver);
                    component.description = this.descriptions[index];
                    int splitAt = url.lastIndexOf(58);
                    if (splitAt >= 0 && !(identifier = url.substring(splitAt + 1).trim()).isBlank()) {
                        NameFactory factory = this.parent.factory;
                        component.namespace = factory.createNameSpace((GenericName)factory.createLocalName(this.parent.namespace, (CharSequence)identifier), null);
                    }
                    this.components[index] = component;
                }
                catch (DataStoreException e) {
                    throw new BackingStoreException((Throwable)e);
                }
            }
            return component;
        }
    }

    final List<Subdataset> getOpenedComponents() {
        return Arrays.asList(this.components);
    }

    private static /* synthetic */ String[] lambda$new$0(String string) {
        return new String[2];
    }
}

