/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.domain;

import org.springframework.data.domain.AbstractPageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.lang.CheckReturnValue;
import org.springframework.lang.Contract;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class PageRequest
extends AbstractPageRequest {
    private static final long serialVersionUID = -4541509938956089562L;
    private final Sort sort;

    protected PageRequest(int pageNumber, int pageSize, Sort sort) {
        super(pageNumber, pageSize);
        Assert.notNull((Object)sort, (String)"Sort must not be null");
        this.sort = sort;
    }

    public static PageRequest of(int pageNumber, int pageSize) {
        return PageRequest.of(pageNumber, pageSize, Sort.unsorted());
    }

    public static PageRequest of(int pageNumber, int pageSize, Sort sort) {
        return new PageRequest(pageNumber, pageSize, sort);
    }

    public static PageRequest of(int pageNumber, int pageSize, Sort.Direction direction, String ... properties) {
        return PageRequest.of(pageNumber, pageSize, Sort.by(direction, properties));
    }

    public static PageRequest ofSize(int pageSize) {
        return PageRequest.of(0, pageSize);
    }

    @Override
    public Sort getSort() {
        return this.sort;
    }

    @Override
    @Contract(value="_ -> new")
    @CheckReturnValue
    public PageRequest next() {
        return new PageRequest(this.getPageNumber() + 1, this.getPageSize(), this.getSort());
    }

    @Override
    @Contract(value="_ -> new")
    @CheckReturnValue
    public PageRequest previous() {
        return this.getPageNumber() == 0 ? this : new PageRequest(this.getPageNumber() - 1, this.getPageSize(), this.getSort());
    }

    @Override
    @Contract(value="_ -> new")
    @CheckReturnValue
    public PageRequest first() {
        return new PageRequest(0, this.getPageSize(), this.getSort());
    }

    @Override
    @Contract(value="_ -> new")
    @CheckReturnValue
    public PageRequest withPage(int pageNumber) {
        return new PageRequest(pageNumber, this.getPageSize(), this.getSort());
    }

    @Contract(value="_, _ -> new")
    @CheckReturnValue
    public PageRequest withSort(Sort.Direction direction, String ... properties) {
        return new PageRequest(this.getPageNumber(), this.getPageSize(), Sort.by(direction, properties));
    }

    @Contract(value="_ -> new")
    @CheckReturnValue
    public PageRequest withSort(Sort sort) {
        return new PageRequest(this.getPageNumber(), this.getPageSize(), sort);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PageRequest)) {
            return false;
        }
        PageRequest that = (PageRequest)o;
        if (!super.equals(o)) {
            return false;
        }
        return ObjectUtils.nullSafeEquals((Object)this.sort, (Object)that.sort);
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 31 + ObjectUtils.nullSafeHash((Object[])new Object[]{this.sort});
    }

    public String toString() {
        return String.format("Page request [number: %d, size %d, sort: %s]", this.getPageNumber(), this.getPageSize(), this.sort);
    }
}

