/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authorization;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.springframework.security.access.hierarchicalroles.NullRoleHierarchy;
import org.springframework.security.access.hierarchicalroles.RoleHierarchy;
import org.springframework.security.authorization.AuthorityAuthorizationDecision;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.util.Assert;

public final class AllAuthoritiesAuthorizationManager<T>
implements AuthorizationManager<T> {
    private static final String ROLE_PREFIX = "ROLE_";
    private RoleHierarchy roleHierarchy = new NullRoleHierarchy();
    private final List<String> requiredAuthorities;

    private AllAuthoritiesAuthorizationManager(String ... requiredAuthorities) {
        Assert.notEmpty((Object[])requiredAuthorities, (String)"requiredAuthorities cannot be empty");
        this.requiredAuthorities = Arrays.asList(requiredAuthorities);
    }

    public void setRoleHierarchy(RoleHierarchy roleHierarchy) {
        Assert.notNull((Object)roleHierarchy, (String)"roleHierarchy cannot be null");
        this.roleHierarchy = roleHierarchy;
    }

    @Override
    public AuthorityAuthorizationDecision authorize(Supplier<? extends @Nullable Authentication> authentication, T object) {
        List<String> authenticatedAuthorities = this.getGrantedAuthorities(authentication.get());
        ArrayList<String> missingAuthorities = new ArrayList<String>(this.requiredAuthorities);
        missingAuthorities.removeIf(authenticatedAuthorities::contains);
        return new AuthorityAuthorizationDecision(missingAuthorities.isEmpty(), AuthorityUtils.createAuthorityList(missingAuthorities));
    }

    private List<String> getGrantedAuthorities(Authentication authentication) {
        if (authentication == null || !authentication.isAuthenticated()) {
            return Collections.emptyList();
        }
        return this.roleHierarchy.getReachableGrantedAuthorities(authentication.getAuthorities()).stream().map(GrantedAuthority::getAuthority).toList();
    }

    public static <T> AllAuthoritiesAuthorizationManager<T> hasAllRoles(String ... roles) {
        return AllAuthoritiesAuthorizationManager.hasAllPrefixedAuthorities(ROLE_PREFIX, roles);
    }

    public static <T> AllAuthoritiesAuthorizationManager<T> hasAllPrefixedAuthorities(String prefix, String ... authorities) {
        Assert.notNull((Object)prefix, (String)"rolePrefix cannot be null");
        Assert.notEmpty((Object[])authorities, (String)"roles cannot be empty");
        Assert.noNullElements((Object[])authorities, (String)"roles cannot contain null values");
        return AllAuthoritiesAuthorizationManager.hasAllAuthorities(AllAuthoritiesAuthorizationManager.toNamedRolesArray(prefix, authorities));
    }

    public static <T> AllAuthoritiesAuthorizationManager<T> hasAllAuthorities(String ... authorities) {
        Assert.notEmpty((Object[])authorities, (String)"authorities cannot be empty");
        Assert.noNullElements((Object[])authorities, (String)"authorities cannot contain null values");
        return new AllAuthoritiesAuthorizationManager<T>(authorities);
    }

    public static <T> AllAuthoritiesAuthorizationManager<T> hasAllAuthorities(List<String> authorities) {
        Assert.notEmpty(authorities, (String)"authorities cannot be empty");
        Assert.noNullElements(authorities, (String)"authorities cannot contain null values");
        return new AllAuthoritiesAuthorizationManager<T>(authorities.toArray(new String[0]));
    }

    private static String[] toNamedRolesArray(String rolePrefix, String[] roles) {
        String[] result = new String[roles.length];
        for (int i = 0; i < roles.length; ++i) {
            String role = roles[i];
            Assert.isTrue((rolePrefix.isEmpty() || !role.startsWith(rolePrefix) ? 1 : 0) != 0, () -> role + " should not start with " + rolePrefix + " since " + rolePrefix + " is automatically prepended when using hasAnyRole. Consider using hasAnyAuthority instead.");
            result[i] = rolePrefix + role;
        }
        return result;
    }
}

