/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee11.annotations;

import jakarta.servlet.AsyncListener;
import jakarta.servlet.Filter;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContextAttributeListener;
import jakarta.servlet.ServletContextListener;
import jakarta.servlet.ServletRequestAttributeListener;
import jakarta.servlet.ServletRequestListener;
import jakarta.servlet.http.HttpSessionAttributeListener;
import jakarta.servlet.http.HttpSessionIdListener;
import jakarta.servlet.http.HttpSessionListener;
import jakarta.servlet.http.HttpUpgradeHandler;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jetty.ee11.servlet.BaseHolder;
import org.eclipse.jetty.ee11.servlet.Source;
import org.eclipse.jetty.ee11.webapp.WebAppContext;
import org.eclipse.jetty.ee11.webapp.WebDescriptor;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.thread.AutoLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationIntrospector {
    private static final Logger LOG = LoggerFactory.getLogger(AnnotationIntrospector.class);
    private final AutoLock _lock = new AutoLock();
    private final Set<Class<?>> _introspectedClasses = new HashSet();
    private final List<IntrospectableAnnotationHandler> _handlers = new ArrayList<IntrospectableAnnotationHandler>();
    private final WebAppContext _context;

    public AnnotationIntrospector(WebAppContext context) {
        this._context = Objects.requireNonNull(context);
    }

    public void registerHandler(IntrospectableAnnotationHandler handler) {
        this._handlers.add(handler);
    }

    public boolean isIntrospectable(Object o, Object metaInfo) {
        Source.Origin origin;
        BaseHolder holder;
        if (o == null) {
            return false;
        }
        if (metaInfo == null) {
            return true;
        }
        try {
            holder = (BaseHolder)metaInfo;
        }
        catch (ClassCastException e) {
            LOG.warn("Not introspectable {}", (Object)metaInfo.getClass().getName(), (Object)e);
            return true;
        }
        Source.Origin origin2 = origin = holder.getSource() == null ? null : holder.getSource().getOrigin();
        if (origin == null) {
            return true;
        }
        switch (origin) {
            case EMBEDDED: 
            case JAKARTA_API: {
                return true;
            }
            case ANNOTATION: {
                return true;
            }
        }
        if (this._context.getMetaData().isMetaDataComplete()) {
            return false;
        }
        Resource descriptorLocation = holder.getSource().getResource();
        if (descriptorLocation == null) {
            return true;
        }
        return !WebDescriptor.isMetaDataComplete((WebDescriptor)this._context.getMetaData().getFragmentDescriptor(descriptorLocation));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void introspect(Object o, Object metaInfo) {
        if (!this.isIntrospectable(o, metaInfo)) {
            return;
        }
        Class<?> clazz = o.getClass();
        try (AutoLock ignored = this._lock.lock();){
            if (!this._introspectedClasses.add(clazz)) return;
            for (IntrospectableAnnotationHandler handler : this._handlers) {
                try {
                    handler.handle(clazz);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                    return;
                }
            }
        }
    }

    public static interface IntrospectableAnnotationHandler {
        public void handle(Class<?> var1);
    }

    public static abstract class AbstractIntrospectableAnnotationHandler
    implements IntrospectableAnnotationHandler {
        protected boolean _introspectAncestors;
        protected WebAppContext _context;

        public abstract void doHandle(Class<?> var1);

        public AbstractIntrospectableAnnotationHandler(boolean introspectAncestors, WebAppContext context) {
            this._context = Objects.requireNonNull(context);
            this._introspectAncestors = introspectAncestors;
        }

        protected static boolean isAnnotatableServletClass(Class<?> c) {
            return Servlet.class.isAssignableFrom(c) || Filter.class.isAssignableFrom(c) || ServletContextListener.class.isAssignableFrom(c) || ServletContextAttributeListener.class.isAssignableFrom(c) || ServletRequestListener.class.isAssignableFrom(c) || ServletRequestAttributeListener.class.isAssignableFrom(c) || HttpSessionListener.class.isAssignableFrom(c) || HttpSessionAttributeListener.class.isAssignableFrom(c) || HttpSessionIdListener.class.isAssignableFrom(c) || AsyncListener.class.isAssignableFrom(c) || HttpUpgradeHandler.class.isAssignableFrom(c);
        }

        @Override
        public void handle(Class<?> clazz) {
            for (Class<?> c = clazz; c != null && !c.equals(Object.class); c = c.getSuperclass()) {
                this.doHandle(c);
                if (!this._introspectAncestors) break;
            }
        }

        public WebAppContext getContext() {
            return this._context;
        }
    }
}

