/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.annotation;

import java.util.function.Predicate;
import org.apache.juneau.annotation.ExternalDocs;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.commons.annotation.AnnotationObject;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.jsonschema.SchemaUtils;
import org.apache.juneau.parser.ParseException;

public class ExternalDocsAnnotation {
    public static final ExternalDocs DEFAULT = ExternalDocsAnnotation.create().build();

    public static Builder create() {
        return new Builder();
    }

    public static boolean empty(ExternalDocs a) {
        return a == null || DEFAULT.equals(a);
    }

    public static JsonMap merge(JsonMap m, ExternalDocs a) throws ParseException {
        if (ExternalDocsAnnotation.empty(a)) {
            return m;
        }
        Predicate<String> ne = Utils::ne;
        return m.appendIf(ne, "description", SchemaUtils.joinnl(new String[][]{a.description()})).appendIf(ne, "url", a.url());
    }

    public static class Builder
    extends AnnotationObject.Builder {
        private String[] description = new String[0];
        private String url = "";

        protected Builder() {
            super(ExternalDocs.class);
        }

        public ExternalDocs build() {
            return new Object(this);
        }

        public Builder description(String ... value) {
            this.description = value;
            return this;
        }

        public Builder url(String value) {
            this.url = value;
            return this;
        }
    }

    private static class Object
    extends AnnotationObject
    implements ExternalDocs {
        private final String[] description;
        private final String url;

        Object(Builder b) {
            super(b);
            this.description = CollectionUtils.copyOf(b.description);
            this.url = b.url;
        }

        @Override
        public String url() {
            return this.url;
        }

        @Override
        public String[] description() {
            return this.description;
        }
    }
}

