/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.commons.utils;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Scanner;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.apache.juneau.commons.io.FileReaderBuilder;
import org.apache.juneau.commons.io.FileWriterBuilder;
import org.apache.juneau.commons.io.PathReaderBuilder;
import org.apache.juneau.commons.utils.SystemUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;

public class IoUtils {
    public static final Charset UTF8 = StandardCharsets.UTF_8;
    public static final InputStream EMPTY_INPUT_STREAM = new InputStream(){

        @Override
        public int read() {
            return -1;
        }
    };
    private static final int BUFF_SIZE = 1024;
    private static final ThreadLocal<byte[]> BYTE_BUFFER_CACHE = Boolean.getBoolean("juneau.disableIoBufferReuse") ? null : new ThreadLocal();
    private static final ThreadLocal<char[]> CHAR_BUFFER_CACHE = Boolean.getBoolean("juneau.disableIoBufferReuse") ? null : new ThreadLocal();
    static final AtomicInteger BYTE_BUFFER_CACHE_HITS = new AtomicInteger();
    static final AtomicInteger BYTE_BUFFER_CACHE_MISSES = new AtomicInteger();
    static final AtomicInteger CHAR_BUFFER_CACHE_HITS = new AtomicInteger();
    static final AtomicInteger CHAR_BUFFER_CACHE_MISSES = new AtomicInteger();
    public static final Reader EMPTY_READER;

    public static void close(Object ... o) throws IOException {
        IOException ex = null;
        for (Object o2 : o) {
            try {
                Closeable o3;
                if (o2 instanceof InputStream) {
                    o3 = (InputStream)o2;
                    ((InputStream)o3).close();
                }
                if (o2 instanceof OutputStream) {
                    o3 = (OutputStream)o2;
                    ((OutputStream)o3).close();
                }
                if (o2 instanceof Reader) {
                    o3 = (Reader)o2;
                    ((Reader)o3).close();
                }
                if (!(o2 instanceof Writer)) continue;
                o3 = (Writer)o2;
                ((Writer)o3).close();
            }
            catch (IOException e) {
                ex = e;
            }
        }
        if (Utils.nn(ex)) {
            throw ex;
        }
    }

    public static void closeQuietly(InputStream is) {
        if (Utils.nn(is)) {
            Utils.safe(() -> is.close());
        }
    }

    public static void closeQuietly(Object ... o) {
        for (Object o2 : o) {
            Closeable o3;
            if (o2 instanceof InputStream) {
                o3 = (InputStream)o2;
                IoUtils.closeQuietly(o3);
            }
            if (o2 instanceof OutputStream) {
                o3 = (OutputStream)o2;
                IoUtils.closeQuietly((OutputStream)o3);
            }
            if (o2 instanceof Reader) {
                o3 = (Reader)o2;
                IoUtils.closeQuietly((Reader)o3);
            }
            if (!(o2 instanceof Writer)) continue;
            o3 = (Writer)o2;
            IoUtils.closeQuietly((Writer)o3);
        }
    }

    public static void closeQuietly(OutputStream os) {
        if (Utils.nn(os)) {
            Utils.quiet(() -> os.close());
        }
    }

    public static void closeQuietly(Reader r) {
        if (Utils.nn(r)) {
            Utils.quiet(() -> r.close());
        }
    }

    public static void closeQuietly(Writer w) {
        if (Utils.nn(w)) {
            Utils.quiet(() -> w.close());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long count(InputStream is) throws IOException {
        if (is == null) {
            return 0L;
        }
        long c = 0L;
        long i = 0L;
        try {
            while ((i = is.skip(1024L)) != 0L) {
                c += i;
            }
        }
        finally {
            is.close();
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long count(Reader r) throws IOException {
        if (r == null) {
            return 0L;
        }
        long c = 0L;
        long i = 0L;
        try {
            while ((i = r.skip(1024L)) != 0L) {
                c += i;
            }
        }
        finally {
            r.close();
        }
        return c;
    }

    public static void flush(Object ... o) throws IOException {
        IOException ex = null;
        for (Object o2 : o) {
            try {
                Closeable o3;
                if (o2 instanceof OutputStream) {
                    o3 = (OutputStream)o2;
                    ((OutputStream)o3).flush();
                }
                if (!(o2 instanceof Writer)) continue;
                o3 = (Writer)o2;
                ((Writer)o3).flush();
            }
            catch (IOException e) {
                ex = e;
            }
        }
        if (Utils.nn(ex)) {
            throw ex;
        }
    }

    public static String loadSystemResourceAsString(String name, String ... paths) throws IOException {
        for (String path : paths) {
            File f;
            File p = new File(path);
            if (!p.exists() || !(f = new File(p, name)).exists() || !f.canRead()) continue;
            return IoUtils.read(f);
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        for (String path : paths) {
            String n = ".".equals(path) ? name : path + "/" + name;
            try (InputStream is = cl.getResourceAsStream(n);){
                if (Utils.nn(is)) {
                    String string = IoUtils.read(is);
                    return string;
                }
            }
            is = ClassLoader.getSystemResourceAsStream(n);
            try {
                if (!Utils.nn(is)) continue;
                String string = IoUtils.read(is);
                return string;
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        return null;
    }

    public static long pipe(byte[] in, OutputStream out, int maxBytes) throws IOException {
        if (in == null || out == null) {
            return 0L;
        }
        int length = maxBytes < 0 || maxBytes > in.length ? in.length : maxBytes;
        out.write(in, 0, length);
        return length;
    }

    public static long pipe(InputStream in, OutputStream out) throws IOException {
        try (InputStream in2 = in;){
            long l = IoUtils.pipe(in, out, -1L);
            return l;
        }
    }

    public static long pipe(InputStream in, OutputStream out, Consumer<IOException> onException) {
        long l;
        block8: {
            InputStream in2 = in;
            try {
                l = IoUtils.pipe(in, out, -1L);
                if (in2 == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in2 != null) {
                        try {
                            in2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    onException.accept(e);
                    return -1L;
                }
            }
            in2.close();
        }
        return l;
    }

    public static long pipe(InputStream in, OutputStream out, long maxBytes) throws IOException {
        if (in == null || out == null) {
            return 0L;
        }
        byte[] buffer = IoUtils.byteBuffer((int)maxBytes);
        long total = 0L;
        if (maxBytes < 0L) {
            int readLen;
            while ((readLen = in.read(buffer)) != -1) {
                out.write(buffer, 0, readLen);
                total += (long)readLen;
            }
        } else {
            int readLen;
            for (long remaining = maxBytes; remaining > 0L && (readLen = in.read(buffer, 0, IoUtils.buffSize(remaining))) != -1; remaining -= (long)readLen) {
                out.write(buffer, 0, readLen);
                total += (long)readLen;
            }
        }
        out.flush();
        return total;
    }

    public static long pipe(InputStream in, Writer out) throws IOException {
        if (in == null || out == null) {
            return 0L;
        }
        return IoUtils.pipe((Reader)new InputStreamReader(in, UTF8), out);
    }

    public static long pipe(InputStream in, Writer out, Consumer<IOException> onException) {
        try {
            if (in == null || out == null) {
                return 0L;
            }
            return IoUtils.pipe((Reader)new InputStreamReader(in, UTF8), out);
        }
        catch (IOException e) {
            onException.accept(e);
            return -2L;
        }
    }

    public static long pipe(Reader in, File out) throws IOException {
        if (out == null || in == null) {
            return 0L;
        }
        try (Writer w = FileWriterBuilder.create(out).buffered().build();){
            long l = IoUtils.pipe(in, w);
            return l;
        }
    }

    public static long pipe(Reader in, OutputStream out) throws IOException {
        if (in == null || out == null) {
            return 0L;
        }
        long total = 0L;
        try (Reader in2 = in;){
            OutputStreamWriter osw = new OutputStreamWriter(out, UTF8);
            int i = 0;
            char[] b = IoUtils.charBuffer(-1);
            while ((i = in.read(b)) > 0) {
                total += (long)i;
                osw.write(b, 0, i);
            }
            osw.flush();
        }
        return total;
    }

    public static long pipe(Reader in, OutputStream out, Consumer<IOException> onException) {
        try {
            return IoUtils.pipe(in, out);
        }
        catch (IOException e) {
            onException.accept(e);
            return -1L;
        }
    }

    public static long pipe(Reader in, Writer out) throws IOException {
        if (out == null || in == null) {
            return 0L;
        }
        long total = 0L;
        try (Reader in2 = in;){
            int readLen;
            char[] buffer = IoUtils.charBuffer(-1);
            while ((readLen = in.read(buffer)) != -1) {
                out.write(buffer, 0, readLen);
                total += (long)readLen;
            }
        }
        out.flush();
        return total;
    }

    public static long pipe(Reader in, Writer out, Consumer<IOException> onException) {
        try {
            return IoUtils.pipe(in, out);
        }
        catch (IOException e) {
            onException.accept(e);
            return -1L;
        }
    }

    public static long pipeLines(Reader in, Writer out) throws IOException {
        if (in == null || out == null) {
            return 0L;
        }
        long total = 0L;
        try (Reader in2 = in;
             Scanner s = new Scanner(in2);){
            while (s.hasNextLine()) {
                String l = s.nextLine();
                if (!Utils.nn(l)) continue;
                out.write(l);
                out.write("\n");
                out.flush();
                total += (long)(l.length() + 1);
            }
        }
        return total;
    }

    public static String read(byte[] in) {
        return IoUtils.read(in, UTF8);
    }

    public static String read(byte[] in, Charset charset) {
        if (in == null) {
            return null;
        }
        return new String(in, charset);
    }

    public static String read(File in) throws IOException {
        if (in == null || !in.exists()) {
            return null;
        }
        try (Reader r = FileReaderBuilder.create(in).build();){
            String string = IoUtils.read(r, in.length());
            return string;
        }
    }

    public static String read(InputStream in) throws IOException {
        return IoUtils.read(in, UTF8);
    }

    public static String read(InputStream in, Charset cs) throws IOException {
        if (in == null) {
            return null;
        }
        try (InputStreamReader isr = new InputStreamReader(in, cs);){
            String string = IoUtils.read(isr);
            return string;
        }
    }

    public static String read(InputStream in, Charset cs, Consumer<IOException> onException) {
        String string;
        if (in == null) {
            return null;
        }
        InputStreamReader isr = new InputStreamReader(in, cs);
        try {
            string = IoUtils.read(isr);
        }
        catch (Throwable throwable) {
            try {
                try {
                    isr.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                onException.accept(e);
                return null;
            }
        }
        isr.close();
        return string;
    }

    public static String read(InputStream in, Consumer<IOException> onException) {
        return IoUtils.read(in, UTF8, onException);
    }

    public static String read(InputStream in, int maxBytes) throws IOException {
        return IoUtils.read(in, maxBytes, UTF8);
    }

    public static String read(InputStream in, int maxBytes, Charset cs) throws IOException {
        if (in == null) {
            return null;
        }
        try (InputStream in2 = in;){
            byte[] bytes = IoUtils.readBytes(in2, maxBytes);
            String string = new String(bytes, cs);
            return string;
        }
    }

    public static String read(InputStream in, long maxBytes) throws IOException {
        if (maxBytes > Integer.MAX_VALUE) {
            maxBytes = Integer.MAX_VALUE;
        }
        return IoUtils.read(in, (int)maxBytes, UTF8);
    }

    public static String read(Object in) throws IOException {
        if (in == null) {
            return null;
        }
        if (in instanceof Reader) {
            Reader in2 = (Reader)in;
            return IoUtils.read(in2);
        }
        if (in instanceof InputStream) {
            InputStream in2 = (InputStream)in;
            return IoUtils.read(in2);
        }
        if (in instanceof File) {
            File in2 = (File)in;
            return IoUtils.read(in2);
        }
        if (in instanceof byte[]) {
            byte[] in2 = (byte[])in;
            return IoUtils.read(in2);
        }
        throw ThrowableUtils.illegalArg("Invalid type passed to read:  {0}", Utils.cn(in));
    }

    public static String read(Path in) throws IOException {
        if (in == null || !Files.exists(in, new LinkOption[0])) {
            return null;
        }
        try (Reader r = PathReaderBuilder.create(in).build();){
            String string = IoUtils.read(r, Files.size(in));
            return string;
        }
    }

    public static String read(Reader in) throws IOException {
        try (Reader in2 = in;){
            String string = IoUtils.read(in, -1L);
            return string;
        }
    }

    public static String read(Reader in, Consumer<IOException> onException) {
        String string;
        block8: {
            Reader in2 = in;
            try {
                string = IoUtils.read(in, -1L);
                if (in2 == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in2 != null) {
                        try {
                            in2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    onException.accept(e);
                    return null;
                }
            }
            in2.close();
        }
        return string;
    }

    public static String read(Reader in, long expectedLength) throws IOException {
        if (in == null) {
            return null;
        }
        try (Reader in2 = in;){
            StringBuilder sb = new StringBuilder(IoUtils.buffSize(expectedLength));
            char[] buf = IoUtils.charBuffer((int)expectedLength);
            int i = 0;
            while ((i = in2.read(buf)) != -1) {
                sb.append(buf, 0, i);
            }
            String string = sb.toString();
            return string;
        }
    }

    public static byte[] readBytes(File in) throws IOException {
        return IoUtils.readBytes(in, -1);
    }

    public static byte[] readBytes(File in, int maxBytes) throws IOException {
        if (in == null || !in.exists() || !in.canRead()) {
            return new byte[0];
        }
        try (FileInputStream is = new FileInputStream(in);){
            byte[] byArray = IoUtils.readBytes(is, maxBytes);
            return byArray;
        }
    }

    public static byte[] readBytes(InputStream in) throws IOException {
        try (InputStream in2 = in;){
            byte[] byArray = IoUtils.readBytes(in2, -1);
            return byArray;
        }
    }

    public static byte[] readBytes(InputStream in, int maxBytes) throws IOException {
        if (in == null) {
            return new byte[0];
        }
        ByteArrayOutputStream buff = new ByteArrayOutputStream(IoUtils.buffSize(maxBytes));
        int nRead = 0;
        byte[] b = IoUtils.byteBuffer(maxBytes);
        while ((nRead = in.read(b, 0, b.length)) != -1) {
            buff.write(b, 0, nRead);
        }
        buff.flush();
        return buff.toByteArray();
    }

    public static byte[] readBytes(Reader in) throws IOException {
        if (in == null) {
            return new byte[0];
        }
        try (Reader in2 = in;){
            byte[] byArray = IoUtils.read(in2, -1L).getBytes();
            return byArray;
        }
    }

    public static Reader toBufferedReader(Reader r) {
        if (r == null || r instanceof BufferedReader || r instanceof StringReader) {
            return r;
        }
        return new BufferedReader(r);
    }

    private static int buffSize(long max) {
        return max > 0L && max < 1024L ? (int)max : 1024;
    }

    private static byte[] byteBuffer(int maxBytes) {
        if (Utils.nn(BYTE_BUFFER_CACHE)) {
            byte[] x = BYTE_BUFFER_CACHE.get();
            if (x == null) {
                x = new byte[1024];
                BYTE_BUFFER_CACHE.set(x);
                BYTE_BUFFER_CACHE_MISSES.incrementAndGet();
            } else {
                BYTE_BUFFER_CACHE_HITS.incrementAndGet();
            }
            return x;
        }
        return new byte[IoUtils.buffSize(maxBytes)];
    }

    private static char[] charBuffer(int maxChars) {
        if (Utils.nn(CHAR_BUFFER_CACHE)) {
            char[] x = CHAR_BUFFER_CACHE.get();
            if (x == null) {
                x = new char[1024];
                CHAR_BUFFER_CACHE.set(x);
                CHAR_BUFFER_CACHE_MISSES.incrementAndGet();
            } else {
                CHAR_BUFFER_CACHE_HITS.incrementAndGet();
            }
            return x;
        }
        return new char[IoUtils.buffSize(maxChars)];
    }

    protected IoUtils() {
    }

    static {
        SystemUtils.shutdownMessage(() -> "Byte buffer cache:  hits=" + BYTE_BUFFER_CACHE_HITS.get() + ", misses=" + String.valueOf(BYTE_BUFFER_CACHE_MISSES));
        SystemUtils.shutdownMessage(() -> "Char buffer cache:  hits=" + CHAR_BUFFER_CACHE_HITS.get() + ", misses=" + String.valueOf(CHAR_BUFFER_CACHE_MISSES));
        EMPTY_READER = new Reader(){

            @Override
            public void close() throws IOException {
            }

            @Override
            public int read() {
                return -1;
            }

            @Override
            public int read(char[] cbuf, int off, int len) throws IOException {
                return -1;
            }
        };
    }
}

