/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.header;

import java.util.NoSuchElementException;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;

public class BasicHeaderIterator
implements HeaderIterator {
    private final Header[] entries;
    private final String name;
    private final boolean caseSensitive;
    private int currentIndex;

    public BasicHeaderIterator(Header[] headers, String name, boolean caseSensitive) {
        this.entries = AssertionUtils.assertArgNotNull("headers", headers);
        this.name = name;
        this.caseSensitive = caseSensitive;
        this.currentIndex = this.findNext(-1);
    }

    public boolean hasNext() {
        return this.currentIndex >= 0;
    }

    public final Object next() throws NoSuchElementException {
        return this.nextHeader();
    }

    public Header nextHeader() throws NoSuchElementException {
        int current = this.currentIndex;
        if (current < 0) {
            throw new NoSuchElementException("Iteration already finished.");
        }
        this.currentIndex = this.findNext(current);
        return this.entries[current];
    }

    public void remove() {
        throw ThrowableUtils.unsupportedOp();
    }

    private boolean eq(String s1, String s2) {
        return Utils.eq(!this.caseSensitive, s1, s2);
    }

    private boolean filter(int index) {
        return this.name == null || this.eq(this.name, this.entries[index].getName());
    }

    private int findNext(int pos) {
        int from = pos;
        int to = this.entries.length - 1;
        boolean found = false;
        while (!found && from < to) {
            found = this.filter(++from);
        }
        return found ? from : -1;
    }
}

