/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.bean.swagger.ui;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.juneau.BeanSession;
import org.apache.juneau.MediaType;
import org.apache.juneau.bean.html5.Div;
import org.apache.juneau.bean.html5.HtmlBuilder;
import org.apache.juneau.bean.html5.HtmlElement;
import org.apache.juneau.bean.html5.Select;
import org.apache.juneau.bean.html5.Span;
import org.apache.juneau.bean.html5.Table;
import org.apache.juneau.bean.html5.Td;
import org.apache.juneau.bean.swagger.Contact;
import org.apache.juneau.bean.swagger.ExternalDocumentation;
import org.apache.juneau.bean.swagger.Info;
import org.apache.juneau.bean.swagger.License;
import org.apache.juneau.bean.swagger.Operation;
import org.apache.juneau.bean.swagger.ParameterInfo;
import org.apache.juneau.bean.swagger.ResponseInfo;
import org.apache.juneau.bean.swagger.SchemaInfo;
import org.apache.juneau.bean.swagger.Swagger;
import org.apache.juneau.bean.swagger.Tag;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.cp.BeanStore;
import org.apache.juneau.cp.FileFinder;
import org.apache.juneau.swap.ObjectSwap;

public class SwaggerUI
extends ObjectSwap<Swagger, Div> {
    static final FileFinder RESOURCES = (FileFinder)FileFinder.create((BeanStore)BeanStore.INSTANCE).cp(SwaggerUI.class, null, true).dir(",").caching(Boolean.getBoolean("RestContext.disableClasspathResourceCaching.b") ? -1L : 1000000L).build();
    private static final Set<String> STANDARD_METHODS = CollectionUtils.set((Object[])new String[]{"get", "put", "post", "delete", "options"});

    private static Div examples(Session s, ParameterInfo pi) {
        boolean isBody = "body".equals(pi.getIn());
        JsonMap m = new JsonMap();
        try {
            if (isBody) {
                SchemaInfo si = pi.getSchema();
                if (Utils.nn((Object)si)) {
                    m.put("model", (Object)si.copy().resolveRefs(s.swagger, new ArrayDeque<String>(), s.resolveRefsMaxDepth));
                }
            } else {
                JsonMap m2 = pi.copy().resolveRefs(s.swagger, new ArrayDeque<String>(), s.resolveRefsMaxDepth).asMap().keepAll(new String[]{"format", "pattern", "collectionFormat", "maximum", "minimum", "multipleOf", "maxLength", "minLength", "maxItems", "minItems", "allowEmptyValue", "exclusiveMaximum", "exclusiveMinimum", "uniqueItems", "items", "default", "enum"});
                m.put("model", m2.isEmpty() ? HtmlBuilder.i((Object[])new Object[]{"none"}) : m2);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (m.isEmpty()) {
            return null;
        }
        return SwaggerUI.examplesDiv(m);
    }

    private static Div examples(Session s, ResponseInfo ri) {
        SchemaInfo si = ri.getSchema();
        JsonMap m = new JsonMap();
        try {
            Map<String, Object> examples;
            if (Utils.nn((Object)si)) {
                si = si.copy().resolveRefs(s.swagger, new ArrayDeque<String>(), s.resolveRefsMaxDepth);
                m.put("model", (Object)si);
            }
            if (Utils.nn(examples = ri.getExamples())) {
                examples.forEach((arg_0, arg_1) -> ((JsonMap)m).put(arg_0, arg_1));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (m.isEmpty()) {
            return null;
        }
        return SwaggerUI.examplesDiv(m);
    }

    private static Div examplesDiv(JsonMap m) {
        if (m.isEmpty()) {
            return null;
        }
        Select select = null;
        if (m.size() > 1) {
            select = HtmlBuilder.select().onchange("selectExample(this)")._class("example-select");
        }
        Div div = HtmlBuilder.div((Object[])new Object[]{select})._class("examples");
        if (Utils.nn((Object)select)) {
            select.child((Object)HtmlBuilder.option((Object)"model", (Object)"model"));
        }
        div.child((Object)HtmlBuilder.div((Object[])new Object[]{m.remove((Object)"model")})._class("model active").attr("data-name", (Object)"model"));
        Select select2 = select;
        m.forEach((k, v) -> {
            if (Utils.nn((Object)select2)) {
                select2.child((Object)HtmlBuilder.option((Object)k, (Object)k));
            }
            div.child((Object)HtmlBuilder.div((Object[])new Object[]{v.toString().replace("\\n", "\n")})._class("example").attr("data-name", k));
        });
        return div;
    }

    private static Table header(Session s) {
        Table table = HtmlBuilder.table()._class("header");
        Info info = s.swagger.getInfo();
        if (Utils.nn((Object)info)) {
            String child;
            ExternalDocumentation ed;
            License l;
            Contact c;
            if (Utils.nn((Object)info.getDescription())) {
                table.child((Object)HtmlBuilder.tr((Object[])new Object[]{HtmlBuilder.th((Object[])new Object[]{"Description:"}), HtmlBuilder.td((Object[])new Object[]{SwaggerUI.toBRL(info.getDescription())})}));
            }
            if (Utils.nn((Object)info.getVersion())) {
                table.child((Object)HtmlBuilder.tr((Object[])new Object[]{HtmlBuilder.th((Object[])new Object[]{"Version:"}), HtmlBuilder.td((Object[])new Object[]{info.getVersion()})}));
            }
            if (Utils.nn((Object)(c = info.getContact()))) {
                Table t2 = HtmlBuilder.table();
                if (Utils.nn((Object)c.getName())) {
                    t2.child((Object)HtmlBuilder.tr((Object[])new Object[]{HtmlBuilder.th((Object[])new Object[]{"Name:"}), HtmlBuilder.td((Object[])new Object[]{c.getName()})}));
                }
                if (Utils.nn((Object)c.getUrl())) {
                    t2.child((Object)HtmlBuilder.tr((Object[])new Object[]{HtmlBuilder.th((Object[])new Object[]{"URL:"}), HtmlBuilder.td((Object[])new Object[]{HtmlBuilder.a((Object)c.getUrl(), (Object[])new Object[]{c.getUrl()})})}));
                }
                if (Utils.nn((Object)c.getEmail())) {
                    t2.child((Object)HtmlBuilder.tr((Object[])new Object[]{HtmlBuilder.th((Object[])new Object[]{"Email:"}), HtmlBuilder.td((Object[])new Object[]{HtmlBuilder.a((Object)("mailto:" + c.getEmail()), (Object[])new Object[]{c.getEmail()})})}));
                }
                table.child((Object)HtmlBuilder.tr((Object[])new Object[]{HtmlBuilder.th((Object[])new Object[]{"Contact:"}), HtmlBuilder.td((Object[])new Object[]{t2})}));
            }
            if (Utils.nn((Object)(l = info.getLicense()))) {
                Object content = Utils.nn((Object)l.getName()) ? l.getName() : l.getUrl();
                String child2 = Utils.nn((Object)l.getUrl()) ? HtmlBuilder.a((Object)l.getUrl(), (Object[])new Object[]{content}) : l.getName();
                table.child((Object)HtmlBuilder.tr((Object[])new Object[]{HtmlBuilder.th((Object[])new Object[]{"License:"}), HtmlBuilder.td((Object[])new Object[]{child2})}));
            }
            if (Utils.nn((Object)(ed = s.swagger.getExternalDocs()))) {
                Object content = Utils.nn((Object)ed.getDescription()) ? ed.getDescription() : ed.getUrl();
                child = Utils.nn((Object)ed.getUrl()) ? HtmlBuilder.a((Object)ed.getUrl(), (Object[])new Object[]{content}) : ed.getDescription();
                table.child((Object)HtmlBuilder.tr((Object[])new Object[]{HtmlBuilder.th((Object[])new Object[]{"Docs:"}), HtmlBuilder.td((Object[])new Object[]{child})}));
            }
            if (Utils.nn((Object)info.getTermsOfService())) {
                String tos = info.getTermsOfService();
                child = StringUtils.isUri((String)tos) ? HtmlBuilder.a((Object)tos, (Object[])new Object[]{tos}) : tos;
                table.child((Object)HtmlBuilder.tr((Object[])new Object[]{HtmlBuilder.th((Object[])new Object[]{"Terms of Service:"}), HtmlBuilder.td((Object[])new Object[]{child})}));
            }
        }
        return table;
    }

    private static Div headers(ResponseInfo ri) {
        if (ri.getHeaders() == null) {
            return null;
        }
        Table sectionTable = HtmlBuilder.table((Object[])new Object[]{HtmlBuilder.tr((Object[])new Object[]{HtmlBuilder.th((Object[])new Object[]{"Name"}), HtmlBuilder.th((Object[])new Object[]{"Description"}), HtmlBuilder.th((Object[])new Object[]{"Schema"})})})._class("section-table");
        Div headers = HtmlBuilder.div((Object[])new Object[]{HtmlBuilder.div((Object[])new Object[]{"Headers:"})._class("section-name"), sectionTable})._class("headers");
        ri.getHeaders().forEach((k, v) -> sectionTable.child((Object)HtmlBuilder.tr((Object[])new Object[]{HtmlBuilder.td((Object[])new Object[]{k})._class("name"), HtmlBuilder.td((Object[])new Object[]{SwaggerUI.toBRL(v.getDescription())})._class("description"), HtmlBuilder.td((Object[])new Object[]{v.asMap().keepAll(new String[]{"type", "format", "items", "collectionFormat", "default", "maximum", "exclusiveMaximum", "minimum", "exclusiveMinimum", "maxLength", "minLength", "pattern", "maxItems", "minItems", "uniqueItems", "enum", "multipleOf"})})})));
        return headers;
    }

    private static Div modelBlock(String modelName, JsonMap model) {
        return HtmlBuilder.div()._class("op-block op-block-closed model").children(new Object[]{SwaggerUI.modelBlockSummary(modelName, model), HtmlBuilder.div((Object[])new Object[]{model})._class("op-block-contents")});
    }

    private static HtmlElement modelBlockSummary(String modelName, JsonMap model) {
        return HtmlBuilder.div()._class("op-block-summary").onclick("toggleOpBlock(this)").children(new Object[]{HtmlBuilder.span((Object[])new Object[]{modelName})._class("method-button"), model.containsKey((Object)"description") ? HtmlBuilder.span((Object[])new Object[]{SwaggerUI.toBRL(model.remove((Object)"description").toString())})._class("summary") : null});
    }

    private static Div modelsBlockContents(Session s) {
        Div modelBlockContents = HtmlBuilder.div()._class("tag-block-contents");
        s.swagger.getDefinitions().forEach((k, v) -> modelBlockContents.child((Object)SwaggerUI.modelBlock(k, v)));
        return modelBlockContents;
    }

    private static HtmlElement modelsBlockSummary() {
        return HtmlBuilder.div()._class("tag-block-summary").onclick("toggleTagBlock(this)").children(new Object[]{HtmlBuilder.span((Object[])new Object[]{"Models"})._class("name")});
    }

    private static Div opBlock(Session s, String path, String opName, Operation op) {
        String opClass;
        String string = opClass = op.isDeprecated() ? "deprecated" : opName.toLowerCase();
        if (!op.isDeprecated() && !STANDARD_METHODS.contains(opClass)) {
            opClass = "other";
        }
        return HtmlBuilder.div()._class("op-block op-block-closed " + opClass).children(new Object[]{SwaggerUI.opBlockSummary(path, opName, op), HtmlBuilder.div((Object[])new Object[]{SwaggerUI.tableContainer(s, op)})._class("op-block-contents")});
    }

    private static HtmlElement opBlockSummary(String path, String opName, Operation op) {
        return HtmlBuilder.div()._class("op-block-summary").onclick("toggleOpBlock(this)").children(new Object[]{HtmlBuilder.span((Object[])new Object[]{opName.toUpperCase()})._class("method-button"), HtmlBuilder.span((Object[])new Object[]{path})._class("path"), Utils.nn((Object)op.getSummary()) ? HtmlBuilder.span((Object[])new Object[]{op.getSummary()})._class("summary") : null});
    }

    private static Div tableContainer(Session s, Operation op) {
        Div tableContainer = HtmlBuilder.div()._class("table-container");
        if (Utils.nn((Object)op.getDescription())) {
            tableContainer.child((Object)HtmlBuilder.div((Object[])new Object[]{SwaggerUI.toBRL(op.getDescription())})._class("op-block-description"));
        }
        if (Utils.nn(op.getParameters())) {
            tableContainer.child((Object)HtmlBuilder.div((Object[])new Object[]{HtmlBuilder.h4((Object[])new Object[]{"Parameters"})._class("title")})._class("op-block-section-header"));
            Table parameters = HtmlBuilder.table((Object[])new Object[]{HtmlBuilder.tr((Object[])new Object[]{HtmlBuilder.th((Object[])new Object[]{"Name"})._class("parameter-key"), HtmlBuilder.th((Object[])new Object[]{"Description"})._class("parameter-key")})})._class("parameters");
            op.getParameters().forEach(x -> {
                String piName = "body".equals(x.getIn()) ? "body" : x.getName();
                boolean required = Utils.nn((Object)x.getRequired()) && x.getRequired() != false;
                Td parameterKey = HtmlBuilder.td((Object[])new Object[]{HtmlBuilder.div((Object[])new Object[]{piName})._class("name" + (required ? " required" : "")), required ? HtmlBuilder.div((Object[])new Object[]{"required"})._class("requiredlabel") : null, HtmlBuilder.div((Object[])new Object[]{x.getType()})._class("type"), HtmlBuilder.div((Object[])new Object[]{"(" + x.getIn() + ")"})._class("in")})._class("parameter-key");
                Td parameterValue = HtmlBuilder.td((Object[])new Object[]{HtmlBuilder.div((Object[])new Object[]{SwaggerUI.toBRL(x.getDescription())})._class("description"), SwaggerUI.examples(s, x)})._class("parameter-value");
                parameters.child((Object)HtmlBuilder.tr((Object[])new Object[]{parameterKey, parameterValue}));
            });
            tableContainer.child((Object)parameters);
        }
        if (Utils.nn(op.getResponses())) {
            tableContainer.child((Object)HtmlBuilder.div((Object[])new Object[]{HtmlBuilder.h4((Object[])new Object[]{"Responses"})._class("title")})._class("op-block-section-header"));
            Table responses = HtmlBuilder.table((Object[])new Object[]{HtmlBuilder.tr((Object[])new Object[]{HtmlBuilder.th((Object[])new Object[]{"Code"})._class("response-key"), HtmlBuilder.th((Object[])new Object[]{"Description"})._class("response-key")})})._class("responses");
            tableContainer.child((Object)responses);
            op.getResponses().forEach((k, v) -> {
                Td code = HtmlBuilder.td((Object[])new Object[]{k})._class("response-key");
                Td codeValue = HtmlBuilder.td((Object[])new Object[]{HtmlBuilder.div((Object[])new Object[]{SwaggerUI.toBRL(v.getDescription())})._class("description"), SwaggerUI.examples(s, v), SwaggerUI.headers(v)})._class("response-value");
                responses.child((Object)HtmlBuilder.tr((Object[])new Object[]{code, codeValue}));
            });
        }
        return tableContainer;
    }

    private static Div tagBlockContents(Session s, Tag t) {
        Div tagBlockContents = HtmlBuilder.div()._class("tag-block-contents");
        if (Utils.nn(s.swagger.getPaths())) {
            s.swagger.getPaths().forEach((path, v) -> v.forEach((opName, op) -> {
                if (t == null && op.getTags() == null || Utils.nn((Object)t) && Utils.nn(op.getTags()) && op.getTags().contains(t.getName())) {
                    tagBlockContents.child((Object)SwaggerUI.opBlock(s, path, opName, op));
                }
            }));
        }
        return tagBlockContents;
    }

    private static HtmlElement tagBlockSummary(Tag t) {
        ExternalDocumentation ed = t.getExternalDocs();
        ArrayList<Span> children = new ArrayList<Span>();
        children.add(HtmlBuilder.span((Object[])new Object[]{t.getName()})._class("name"));
        children.add(HtmlBuilder.span((Object[])new Object[]{SwaggerUI.toBRL(t.getDescription())})._class("description"));
        if (Utils.nn((Object)ed)) {
            Object content = Utils.nn((Object)ed.getDescription()) ? ed.getDescription() : ed.getUrl();
            children.add(HtmlBuilder.span((Object[])new Object[]{HtmlBuilder.a((Object)ed.getUrl(), (Object[])new Object[]{content})})._class("extdocs"));
        }
        return HtmlBuilder.div()._class("tag-block-summary").onclick("toggleTagBlock(this)").children(new Object[]{children});
    }

    private static List<Object> toBRL(String s) {
        if (s == null) {
            return null;
        }
        if (s.indexOf(44) == -1) {
            return Collections.singletonList(s);
        }
        List l = CollectionUtils.list((Object[])new Object[0]);
        String[] sa = s.split("\n");
        for (int i = 0; i < sa.length; ++i) {
            if (i > 0) {
                l.add(HtmlBuilder.br());
            }
            l.add(sa[i]);
        }
        return l;
    }

    public MediaType[] forMediaTypes() {
        return (MediaType[])CollectionUtils.a((Object[])new MediaType[]{MediaType.HTML});
    }

    public Div swap(BeanSession beanSession, Swagger swagger) throws Exception {
        Session s = new Session(swagger);
        String css = RESOURCES.getString("files/htdocs/styles/SwaggerUI.css", null).orElse(null);
        if (css == null) {
            css = RESOURCES.getString("SwaggerUI.css", null).orElse(null);
        }
        Div outer = HtmlBuilder.div((Object[])new Object[]{HtmlBuilder.style((Object)css), HtmlBuilder.script((String)"text/javascript", (String[])new String[]{RESOURCES.getString("SwaggerUI.js", null).orElse(null)}), SwaggerUI.header(s)})._class("swagger-ui");
        outer.child((Object)HtmlBuilder.div()._class("tag-block tag-block-open").children(new Object[]{SwaggerUI.tagBlockContents(s, null)}));
        if (Utils.nn(s.swagger.getTags())) {
            s.swagger.getTags().forEach(x -> {
                Div tagBlock = HtmlBuilder.div()._class("tag-block tag-block-open").children(new Object[]{SwaggerUI.tagBlockSummary(x), SwaggerUI.tagBlockContents(s, x)});
                outer.child((Object)tagBlock);
            });
        }
        if (Utils.nn(s.swagger.getDefinitions())) {
            Div modelBlock = HtmlBuilder.div()._class("tag-block").children(new Object[]{SwaggerUI.modelsBlockSummary(), SwaggerUI.modelsBlockContents(s)});
            outer.child((Object)modelBlock);
        }
        return outer;
    }

    private static class Session {
        final int resolveRefsMaxDepth;
        final Swagger swagger;

        Session(Swagger swagger) {
            this.swagger = swagger.copy();
            this.resolveRefsMaxDepth = 1;
        }
    }
}

