/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.oidc.OIDCException;
import io.quarkus.oidc.OidcTenantConfig;
import io.quarkus.oidc.SecurityEvent;
import io.quarkus.oidc.runtime.BackChannelLogoutTokenCache;
import io.quarkus.oidc.runtime.DefaultTenantConfigResolver;
import io.quarkus.oidc.runtime.OidcUtils;
import io.quarkus.oidc.runtime.TenantConfigContext;
import io.quarkus.oidc.runtime.TokenVerificationResult;
import io.quarkus.runtime.ShutdownEvent;
import io.quarkus.security.spi.runtime.SecurityEventHelper;
import io.quarkus.vertx.http.runtime.security.ImmutablePathMatcher;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.event.Observes;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.microprofile.jwt.Claims;
import org.jboss.logging.Logger;
import org.jose4j.jwt.consumer.InvalidJwtException;

@Singleton
public final class BackChannelLogoutHandler
implements Handler<RoutingContext> {
    private static final Logger LOG = Logger.getLogger(BackChannelLogoutHandler.class);
    private final DefaultTenantConfigResolver resolver;
    private volatile ImmutablePathMatcher<Handler<RoutingContext>> pathMatcher;

    BackChannelLogoutHandler(DefaultTenantConfigResolver resolver) {
        this.resolver = resolver;
        this.pathMatcher = null;
    }

    public void handle(RoutingContext routingContext) {
        Handler routeHandler;
        ImmutablePathMatcher<Handler<RoutingContext>> matcher = this.pathMatcher;
        if (matcher != null && (routeHandler = (Handler)matcher.match(routingContext.normalizedPath()).getValue()) != null) {
            routeHandler.handle((Object)routingContext);
            return;
        }
        routingContext.next();
    }

    void createPathMatcher(@Observes Router ignored) {
        this.createOrUpdatePathMatcher();
    }

    synchronized void updatePathMatcher(@Observes NewBackChannelLogoutPath ignored, Vertx vertx) {
        Set<String> currentTenantIds = this.createOrUpdatePathMatcher();
        this.clearCache(vertx, currentTenantIds);
    }

    void clearCacheOnShutdown(@Observes ShutdownEvent event, Vertx vertx) {
        this.clearCache(vertx, null);
    }

    private void clearCache(Vertx vertx, Set<String> currentTenantIds) {
        if (currentTenantIds == null) {
            for (BackChannelLogoutTokenCache cache : this.resolver.getBackChannelLogoutTokens().values()) {
                cache.shutdown(vertx);
            }
            this.resolver.getBackChannelLogoutTokens().clear();
        } else {
            HashSet<String> cachedTenantIds = new HashSet<String>(this.resolver.getBackChannelLogoutTokens().keySet());
            for (String cachedTenantId : cachedTenantIds) {
                BackChannelLogoutTokenCache cache;
                if (currentTenantIds.contains(cachedTenantId) || (cache = this.resolver.getBackChannelLogoutTokens().remove(cachedTenantId)) == null) continue;
                cache.shutdown(vertx);
            }
        }
    }

    private Set<String> createOrUpdatePathMatcher() {
        ImmutablePathMatcher.ImmutablePathMatcherBuilder builder = null;
        HashMap<String, OidcTenantConfig> pathCache = null;
        HashSet<String> tenantIdCache = null;
        for (TenantConfigContext configContext : this.resolver.getTenantConfigBean().getAllTenantConfigs()) {
            String currentTenantId;
            String routePath;
            if (!configContext.ready() || !configContext.oidcConfig().tenantEnabled() || !configContext.oidcConfig().logout().backchannel().path().isPresent()) continue;
            if (builder == null) {
                builder = ImmutablePathMatcher.builder();
                pathCache = new HashMap<String, OidcTenantConfig>();
                tenantIdCache = new HashSet<String>();
            }
            if ((routePath = this.getTenantLogoutPath(configContext)).contains("*")) {
                throw new IllegalStateException("Back-channel logout path cannot contain a wildcard '*' character");
            }
            OidcTenantConfig previousConfig = pathCache.put(routePath, configContext.oidcConfig());
            tenantIdCache.add(configContext.oidcConfig().tenantId().get());
            if (previousConfig == null) {
                RouteHandler routeHandler = new RouteHandler(configContext, this.resolver);
                builder.addPath(routePath, (Object)routeHandler);
                continue;
            }
            String previousTenantId = previousConfig.tenantId().get();
            if (previousTenantId.equals(currentTenantId = configContext.oidcConfig().tenantId().get())) continue;
            String errorMessage = "OIDC tenants '%s' and '%s' share the same back-channel logout path '%s', which is not supported".formatted(previousTenantId, currentTenantId, routePath);
            LOG.error((Object)errorMessage);
            throw new OIDCException(errorMessage);
        }
        this.pathMatcher = builder != null ? builder.build() : null;
        return tenantIdCache;
    }

    private String getTenantLogoutPath(TenantConfigContext tenant) {
        return OidcUtils.getRootPath(this.resolver.getRootPath()) + (String)tenant.oidcConfig().logout().backchannel().path().orElse(null);
    }

    public static void fireBackChannelLogoutChangedEvent(OidcTenantConfig oidcConfig, TenantConfigContext tenant) {
        if (oidcConfig.logout().backchannel().path().isPresent()) {
            boolean pathChanged;
            boolean bl = pathChanged = tenant.oidcConfig() == null || !oidcConfig.logout().backchannel().path().get().equals(tenant.oidcConfig().logout().backchannel().path().orElse(null));
            if (pathChanged) {
                BackChannelLogoutHandler.fireBackChannelLogoutEvent();
            }
        }
    }

    public static void fireBackChannelLogoutReadyEvent(OidcTenantConfig oidcConfig) {
        if (oidcConfig.logout().backchannel().path().isPresent()) {
            BackChannelLogoutHandler.fireBackChannelLogoutEvent();
        }
    }

    private static void fireBackChannelLogoutEvent() {
        Event event = Arc.container().beanManager().getEvent().select(NewBackChannelLogoutPath.class, new Annotation[0]);
        event.fire((Object)new NewBackChannelLogoutPath());
    }

    private static final class RouteHandler
    implements Handler<RoutingContext> {
        private final TenantConfigContext tenantContext;
        private final DefaultTenantConfigResolver resolver;
        private final String tenantId;

        private RouteHandler(TenantConfigContext tenantContext, DefaultTenantConfigResolver resolver) {
            this.tenantContext = tenantContext;
            this.resolver = resolver;
            this.tenantId = tenantContext.oidcConfig().tenantId().get();
        }

        public void handle(final RoutingContext context) {
            LOG.debugf("Back channel logout request for the tenant %s received", (Object)this.tenantId);
            if (OidcUtils.isFormUrlEncodedRequest(context)) {
                OidcUtils.getFormUrlEncodedData(context).subscribe().with((Consumer)new Consumer<MultiMap>(){

                    @Override
                    public void accept(MultiMap form) {
                        String encodedLogoutToken = form.get("logout_token");
                        if (encodedLogoutToken == null) {
                            LOG.debug((Object)"Back channel logout token is missing");
                            context.response().setStatusCode(400);
                        } else {
                            try {
                                TokenVerificationResult result = tenantContext.provider().verifyLogoutJwtToken(encodedLogoutToken);
                                if (this.verifyLogoutTokenClaims(result)) {
                                    String key = result.localVerificationResult.getString(tenantContext.oidcConfig().logout().backchannel().logoutTokenKey());
                                    BackChannelLogoutTokenCache tokens = resolver.getBackChannelLogoutTokens().get(tenantId);
                                    if (tokens == null) {
                                        tokens = new BackChannelLogoutTokenCache(tenantContext.oidcConfig(), context.vertx());
                                        resolver.getBackChannelLogoutTokens().put(tenantId, tokens);
                                    }
                                    tokens.addTokenVerification(key, result);
                                    if (resolver.isSecurityEventObserved()) {
                                        SecurityEventHelper.fire(resolver.getSecurityEvent(), (io.quarkus.security.spi.runtime.SecurityEvent)new SecurityEvent(SecurityEvent.Type.OIDC_BACKCHANNEL_LOGOUT_INITIATED, Map.of("logout_token", result)));
                                    }
                                    context.response().setStatusCode(200);
                                } else {
                                    context.response().setStatusCode(400);
                                }
                            }
                            catch (InvalidJwtException e) {
                                LOG.debug((Object)"Back channel logout token is invalid");
                                context.response().setStatusCode(400);
                            }
                        }
                        context.response().end();
                    }
                });
            } else {
                LOG.debug((Object)("HTTP POST and " + HttpHeaders.APPLICATION_X_WWW_FORM_URLENCODED.toString() + " content type must be used with the Back channel logout request"));
                context.response().setStatusCode(400);
                context.response().end();
            }
        }

        private boolean verifyLogoutTokenClaims(TokenVerificationResult result) {
            JsonObject events = result.localVerificationResult.getJsonObject("events");
            if (events == null || events.getJsonObject("http://schemas.openid.net/event/backchannel-logout") == null) {
                LOG.debug((Object)"Back channel logout token does not have a valid 'events' claim");
                return false;
            }
            if (!result.localVerificationResult.containsKey(this.tenantContext.oidcConfig().logout().backchannel().logoutTokenKey())) {
                LOG.debugf("Back channel logout token does not have %s", (Object)this.tenantContext.oidcConfig().logout().backchannel().logoutTokenKey());
                return false;
            }
            if (result.localVerificationResult.containsKey(Claims.nonce.name())) {
                LOG.debug((Object)"Back channel logout token must not contain 'nonce' claim");
                return false;
            }
            return true;
        }
    }

    record NewBackChannelLogoutPath() {
    }
}

