/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.util;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import org.apache.iceberg.relocated.com.google.common.hash.HashFunction;
import org.apache.iceberg.relocated.com.google.common.hash.Hashing;

public class BucketUtil {
    private static final HashFunction MURMUR3 = Hashing.murmur3_32_fixed();

    private BucketUtil() {
    }

    public static int hash(int value) {
        return MURMUR3.hashLong((long)value).asInt();
    }

    public static int hash(long value) {
        return MURMUR3.hashLong(value).asInt();
    }

    private static long doubleToLongBits(double value) {
        long bits = Double.doubleToLongBits(value);
        if (bits == Long.MIN_VALUE) {
            bits = 0L;
        }
        return bits;
    }

    public static int hash(float value) {
        return MURMUR3.hashLong(BucketUtil.doubleToLongBits(value)).asInt();
    }

    public static int hash(double value) {
        return MURMUR3.hashLong(BucketUtil.doubleToLongBits(value)).asInt();
    }

    public static int hash(CharSequence value) {
        return MURMUR3.hashString(value, StandardCharsets.UTF_8).asInt();
    }

    public static int hash(byte[] value) {
        return MURMUR3.hashBytes(value).asInt();
    }

    public static int hash(ByteBuffer value) {
        if (value.hasArray()) {
            return MURMUR3.hashBytes(value.array(), value.arrayOffset() + value.position(), value.remaining()).asInt();
        }
        int position = value.position();
        byte[] copy = new byte[value.remaining()];
        try {
            value.get(copy);
        }
        finally {
            value.position(position);
        }
        return MURMUR3.hashBytes(copy).asInt();
    }

    public static int hash(UUID value) {
        return MURMUR3.newHasher(16).putLong(Long.reverseBytes(value.getMostSignificantBits())).putLong(Long.reverseBytes(value.getLeastSignificantBits())).hash().asInt();
    }

    public static int hash(BigDecimal value) {
        return MURMUR3.hashBytes(value.unscaledValue().toByteArray()).asInt();
    }
}

