/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.credentials.connection;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Inject;
import java.util.Optional;
import org.apache.polaris.core.connection.AuthenticationType;
import org.apache.polaris.core.connection.ConnectionConfigInfoDpo;
import org.apache.polaris.core.connection.SigV4AuthenticationParametersDpo;
import org.apache.polaris.core.credentials.connection.CatalogAccessProperty;
import org.apache.polaris.core.credentials.connection.ConnectionCredentialVendor;
import org.apache.polaris.core.credentials.connection.ConnectionCredentials;
import org.apache.polaris.core.identity.credential.AwsIamServiceIdentityCredential;
import org.apache.polaris.core.identity.credential.ServiceIdentityCredential;
import org.apache.polaris.core.identity.provider.ServiceIdentityProvider;
import org.apache.polaris.core.storage.aws.StsClientProvider;
import org.apache.polaris.service.credentials.connection.AuthType;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.model.AssumeRoleRequest;
import software.amazon.awssdk.services.sts.model.AssumeRoleResponse;

@RequestScoped
@AuthType(value=AuthenticationType.SIGV4)
@Priority(value=100)
public class SigV4ConnectionCredentialVendor
implements ConnectionCredentialVendor {
    private static final String DEFAULT_ROLE_SESSION_NAME = "polaris";
    private final StsClientProvider stsClientProvider;
    private final ServiceIdentityProvider serviceIdentityProvider;

    @Inject
    public SigV4ConnectionCredentialVendor(StsClientProvider stsClientProvider, ServiceIdentityProvider serviceIdentityProvider) {
        this.stsClientProvider = stsClientProvider;
        this.serviceIdentityProvider = serviceIdentityProvider;
    }

    @Nonnull
    public ConnectionCredentials getConnectionCredentials(@Nonnull ConnectionConfigInfoDpo connectionConfig) {
        Preconditions.checkArgument((boolean)(connectionConfig.getAuthenticationParameters() instanceof SigV4AuthenticationParametersDpo), (String)"Expected SigV4AuthenticationParametersDpo, got: %s", (Object)connectionConfig.getAuthenticationParameters().getClass().getName());
        SigV4AuthenticationParametersDpo sigv4Params = (SigV4AuthenticationParametersDpo)connectionConfig.getAuthenticationParameters();
        Optional serviceCredentialOpt = this.serviceIdentityProvider.getServiceIdentityCredential(connectionConfig.getServiceIdentity());
        if (serviceCredentialOpt.isEmpty()) {
            return ConnectionCredentials.builder().build();
        }
        ServiceIdentityCredential serviceCredential = (ServiceIdentityCredential)serviceCredentialOpt.get();
        Preconditions.checkArgument((boolean)(serviceCredential instanceof AwsIamServiceIdentityCredential), (String)"Expected AwsIamServiceIdentityCredential, got: %s", (Object)serviceCredential.getClass().getName());
        AwsIamServiceIdentityCredential awsCredential = (AwsIamServiceIdentityCredential)serviceCredential;
        StsClient stsClient = this.getStsClient(sigv4Params);
        AssumeRoleRequest.Builder requestBuilder = AssumeRoleRequest.builder().roleArn(sigv4Params.getRoleArn()).roleSessionName(Optional.ofNullable(sigv4Params.getRoleSessionName()).orElse(DEFAULT_ROLE_SESSION_NAME)).externalId(sigv4Params.getExternalId());
        requestBuilder.overrideConfiguration(config -> config.credentialsProvider(awsCredential.getAwsCredentialsProvider()));
        AssumeRoleResponse response = stsClient.assumeRole((AssumeRoleRequest)requestBuilder.build());
        ConnectionCredentials.Builder builder = ConnectionCredentials.builder();
        builder.put(CatalogAccessProperty.AWS_ACCESS_KEY_ID, response.credentials().accessKeyId());
        builder.put(CatalogAccessProperty.AWS_SECRET_ACCESS_KEY, response.credentials().secretAccessKey());
        builder.put(CatalogAccessProperty.AWS_SESSION_TOKEN, response.credentials().sessionToken());
        Optional.ofNullable(response.credentials().expiration()).ifPresent(expiration -> builder.put(CatalogAccessProperty.AWS_SESSION_TOKEN_EXPIRES_AT_MS, String.valueOf(expiration.toEpochMilli())));
        return builder.build();
    }

    @VisibleForTesting
    StsClient getStsClient(@Nonnull SigV4AuthenticationParametersDpo sigv4Params) {
        return this.stsClientProvider.stsClient(StsClientProvider.StsDestination.of(null, null));
    }
}

