/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.sessions;

import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.security.PrivilegedExceptionAction;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.livy.LivyConf;
import org.apache.livy.LivyConf$;
import org.apache.livy.Logging;
import org.apache.livy.sessions.NamedThreadFactory;
import org.apache.livy.sessions.Session$;
import org.apache.livy.sessions.SessionState;
import org.apache.livy.utils.AppInfo;
import org.apache.livy.utils.AppInfo$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.IndexedSeq;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t\u0005u!B\u001e=\u0011\u0003)e!B$=\u0011\u0003A\u0005\"B(\u0002\t\u0003\u0001faB)\u0002!\u0003\r\nA\u0015\u0005\b'\u000e\u0011\rQ\"\u0001U\u0011\u001dA\u0016A1A\u0005\u0002eCa\u0001[\u0001!\u0002\u0013Q\u0006\u0002C5\u0002\u0011\u000b\u0007I\u0011A-\t\u000b)\fA\u0011A6\t\u000f\u0005E\u0011\u0001\"\u0001\u0002\u0014!9\u00111D\u0001\u0005\u0002\u0005uaAB$=\u0003\u0003\t)\u0004\u0003\u0005T\u0017\t\u0015\r\u0011\"\u0001U\u0011%\tid\u0003B\u0001B\u0003%Q\u000b\u0003\u0006\u0002@-\u0011)\u0019!C\u0001\u0003\u0003B!\"!\u0013\f\u0005\u0003\u0005\u000b\u0011BA\"\u0011)\tYe\u0003BC\u0002\u0013\u0005\u0011Q\n\u0005\n\u0003\u001fZ!\u0011!Q\u0001\n\u0015D!\"!\u0015\f\u0005\u000b\u0007I\u0011AA!\u0011)\t\u0019f\u0003B\u0001B\u0003%\u00111\t\u0005\u000b\u0003+Z!Q1A\u0005\u0002\u0005\u0005\u0003BCA,\u0017\t\u0005\t\u0015!\u0003\u0002D!Q\u0011qA\u0006\u0003\u0006\u0004%\t!!\u0017\t\u0015\u0005m3B!A!\u0002\u0013\tI\u0001\u0003\u0004P\u0017\u0011\u0005\u0011Q\f\u0005\u0007\u001f.!\t!!\u001c\t\u0013\u0005]4B1A\u0005\u0012\u0005e\u0004\u0002CAD\u0017\u0001\u0006I!a\u001f\t\u0013\u0005%5B1A\u0005\u0014\u0005-\u0005\u0002CAJ\u0017\u0001\u0006I!!$\t\u0013\u0005U5\u00021A\u0005\u0012\u0005\u0005\u0003\"CAL\u0017\u0001\u0007I\u0011CAM\u0011!\t)k\u0003Q!\n\u0005\r\u0003\"CAT\u0017\u0001\u0007I\u0011BAU\u0011%\t\tl\u0003a\u0001\n\u0013\t\u0019\f\u0003\u0005\u00028.\u0001\u000b\u0015BAV\u0011%\tIl\u0003a\u0001\n\u0003\tY\fC\u0005\u0002@.\u0001\r\u0011\"\u0001\u0002B\"A\u0011QY\u0006!B\u0013\ti\fC\u0005\u0002H.\u0001\r\u0011\"\u0003\u0002J\"I\u00111\\\u0006A\u0002\u0013%\u0011Q\u001c\u0005\t\u0003C\\\u0001\u0015)\u0003\u0002L\"9\u00111]\u0006\u0005\u0002\u0005\u0005\u0003\"CAs\u0017\u0001\u0007I\u0011AAt\u0011%\t)p\u0003a\u0001\n\u0003\t9\u0010\u0003\u0005\u0002|.\u0001\u000b\u0015BAu\u0011\u001d\tip\u0003C\u0001\u0003SCq!a@\f\r\u0003\u0011\t\u0001C\u0004\u0003\n-!\tAa\u0003\t\u000f\t51B\"\u0001\u0003\u0010!9!QC\u0006\u0007\u0002\t]\u0001b\u0002B\u0010\u0017\u0019\u0005!1\u0002\u0005\b\u0005CYA\u0011\u0001B\u0012\u0011\u001d\u0011\td\u0003C!\u0005gAqA!\u000e\f\r#\u0011Y\u0001C\u0005\u00038-\u0011\rQ\"\u0001\u0002B!9!\u0011H\u0006\u0005\u0012\tm\u0002b\u0002B0\u0017\u0011E!\u0011\r\u0005\b\u0005kZA\u0011\u0002B<\u0003\u001d\u0019Vm]:j_:T!!\u0010 \u0002\u0011M,7o]5p]NT!a\u0010!\u0002\t1Lg/\u001f\u0006\u0003\u0003\n\u000ba!\u00199bG\",'\"A\"\u0002\u0007=\u0014xm\u0001\u0001\u0011\u0005\u0019\u000bQ\"\u0001\u001f\u0003\u000fM+7o]5p]N\u0011\u0011!\u0013\t\u0003\u00156k\u0011a\u0013\u0006\u0002\u0019\u0006)1oY1mC&\u0011aj\u0013\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005)%\u0001\u0005*fG>4XM]=NKR\fG-\u0019;b'\t\u0019\u0011*\u0001\u0002jIV\tQ\u000b\u0005\u0002K-&\u0011qk\u0013\u0002\u0004\u0013:$\u0018A\u0007\"M\u0003\u000e[E*S*U?\u000e+6\u000bV(N?\u000ec\u0015iU*Q\u0003RCU#\u0001.\u0011\u0007m\u0013WM\u0004\u0002]AB\u0011QlS\u0007\u0002=*\u0011q\fR\u0001\u0007yI|w\u000e\u001e \n\u0005\u0005\\\u0015A\u0002)sK\u0012,g-\u0003\u0002dI\n\u00191+\u001a;\u000b\u0005\u0005\\\u0005CA.g\u0013\t9GM\u0001\u0004TiJLgnZ\u0001\u001c\u00052\u000b5i\u0013'J'R{6)V*U\u001f6{6\tT!T'B\u000bE\u000b\u0013\u0011\u0002\u001f\r|gNZ5h\u00052\f7m\u001b'jgR\f1\u0002\u001d:fa\u0006\u0014XmQ8oMRIAn\\9}}\u0006\u0005\u0011Q\u0001\t\u000576,W-\u0003\u0002oI\n\u0019Q*\u00199\t\u000bAD\u0001\u0019\u00017\u0002\t\r|gN\u001a\u0005\u0006e\"\u0001\ra]\u0001\u0005U\u0006\u00148\u000fE\u0002us\u0016t!!^<\u000f\u0005u3\u0018\"\u0001'\n\u0005a\\\u0015a\u00029bG.\fw-Z\u0005\u0003un\u00141aU3r\u0015\tA8\nC\u0003~\u0011\u0001\u00071/A\u0003gS2,7\u000fC\u0003\u0000\u0011\u0001\u00071/\u0001\u0005be\u000eD\u0017N^3t\u0011\u0019\t\u0019\u0001\u0003a\u0001g\u00069\u0001/\u001f$jY\u0016\u001c\bbBA\u0004\u0011\u0001\u0007\u0011\u0011B\u0001\tY&4\u0018pQ8oMB!\u00111BA\u0007\u001b\u0005q\u0014bAA\b}\tAA*\u001b<z\u0007>tg-A\u0006sKN|GN^3V%&\u001bH#B:\u0002\u0016\u0005e\u0001BBA\f\u0013\u0001\u00071/\u0001\u0003ve&\u001c\bbBA\u0004\u0013\u0001\u0007\u0011\u0011B\u0001\u000be\u0016\u001cx\u000e\u001c<f+JKECBA\u0010\u0003_\t\u0019\u0004\u0005\u0003\u0002\"\u0005-RBAA\u0012\u0015\u0011\t)#a\n\u0002\u00079,GO\u0003\u0002\u0002*\u0005!!.\u0019<b\u0013\u0011\ti#a\t\u0003\u0007U\u0013\u0016\nC\u0004\u00022)\u0001\r!a\b\u0002\u0007U\u0014\u0018\u000eC\u0004\u0002\b)\u0001\r!!\u0003\u0014\t-I\u0015q\u0007\t\u0005\u0003\u0017\tI$C\u0002\u0002<y\u0012q\u0001T8hO&tw-A\u0002jI\u0002\nAA\\1nKV\u0011\u00111\t\t\u0005\u0015\u0006\u0015S-C\u0002\u0002H-\u0013aa\u00149uS>t\u0017!\u00028b[\u0016\u0004\u0013!B8x]\u0016\u0014X#A3\u0002\r=<h.\u001a:!\u0003\r!H\u000f\\\u0001\u0005iRd\u0007%A\u0006jI2,G+[7f_V$\u0018\u0001D5eY\u0016$\u0016.\\3pkR\u0004SCAA\u0005\u0003%a\u0017N^=D_:4\u0007\u0005\u0006\b\u0002`\u0005\u0005\u00141MA3\u0003O\nI'a\u001b\u0011\u0005\u0019[\u0001\"B*\u0019\u0001\u0004)\u0006bBA 1\u0001\u0007\u00111\t\u0005\u0007\u0003\u0017B\u0002\u0019A3\t\u000f\u0005E\u0003\u00041\u0001\u0002D!9\u0011Q\u000b\rA\u0002\u0005\r\u0003bBA\u00041\u0001\u0007\u0011\u0011\u0002\u000b\u000b\u0003?\ny'!\u001d\u0002t\u0005U\u0004\"B*\u001a\u0001\u0004)\u0006bBA 3\u0001\u0007\u00111\t\u0005\u0007\u0003\u0017J\u0002\u0019A3\t\u000f\u0005\u001d\u0011\u00041\u0001\u0002\n\u000512/Z:tS>tW*\u00198bO\u0016,\u00050Z2vi>\u00148/\u0006\u0002\u0002|A!\u0011QPAB\u001b\t\tyHC\u0002\u0002\u0002.\u000b!bY8oGV\u0014(/\u001a8u\u0013\u0011\t))a \u0003!\u0015CXmY;uS>t7i\u001c8uKb$\u0018aF:fgNLwN\\'b]\u0006<W-\u0012=fGV$xN]:!\u0003A)\u00070Z2vi&|gnQ8oi\u0016DH/\u0006\u0002\u0002\u000eB!\u0011QPAH\u0013\u0011\t\t*a \u00031\u0015CXmY;uS>t7i\u001c8uKb$X\t_3dkR|'/A\tfq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\u0002\naaX1qa&#\u0017AC0baBLEm\u0018\u0013fcR!\u00111TAQ!\rQ\u0015QT\u0005\u0004\u0003?[%\u0001B+oSRD\u0011\"a) \u0003\u0003\u0005\r!a\u0011\u0002\u0007a$\u0013'A\u0004`CB\u0004\u0018\n\u001a\u0011\u0002\u001b}c\u0017m\u001d;BGRLg/\u001b;z+\t\tY\u000bE\u0002K\u0003[K1!a,L\u0005\u0011auN\\4\u0002#}c\u0017m\u001d;BGRLg/\u001b;z?\u0012*\u0017\u000f\u0006\u0003\u0002\u001c\u0006U\u0006\"CARE\u0005\u0005\t\u0019AAV\u00039yF.Y:u\u0003\u000e$\u0018N^5us\u0002\n\u0011b\u001d;beR,Gm\u00148\u0016\u0005\u0005u\u0006#\u0002&\u0002F\u0005-\u0016!D:uCJ$X\rZ(o?\u0012*\u0017\u000f\u0006\u0003\u0002\u001c\u0006\r\u0007\"CARK\u0005\u0005\t\u0019AA_\u0003)\u0019H/\u0019:uK\u0012|e\u000eI\u0001\u000bgR\fw-\u001b8h\t&\u0014XCAAf!\u0011\ti-a6\u000e\u0005\u0005='\u0002BAi\u0003'\f!AZ:\u000b\u0007\u0005U\u0007)\u0001\u0004iC\u0012|w\u000e]\u0005\u0005\u00033\fyM\u0001\u0003QCRD\u0017AD:uC\u001eLgn\u001a#je~#S-\u001d\u000b\u0005\u00037\u000by\u000eC\u0005\u0002$\"\n\t\u00111\u0001\u0002L\u0006Y1\u000f^1hS:<G)\u001b:!\u0003\u0015\t\u0007\u000f]%e\u0003\u001d\t\u0007\u000f]%oM>,\"!!;\u0011\t\u0005-\u0018\u0011_\u0007\u0003\u0003[T1!a<?\u0003\u0015)H/\u001b7t\u0013\u0011\t\u00190!<\u0003\u000f\u0005\u0003\b/\u00138g_\u0006Y\u0011\r\u001d9J]\u001a|w\fJ3r)\u0011\tY*!?\t\u0013\u0005\rF&!AA\u0002\u0005%\u0018\u0001C1qa&sgm\u001c\u0011\u0002\u00191\f7\u000f^!di&4\u0018\u000e^=\u0002\u00111|w\rT5oKN$\"Aa\u0001\u0011\tQ\u0014)!Z\u0005\u0004\u0005\u000fY(AC%oI\u0016DX\rZ*fc\u0006q!/Z2pe\u0012\f5\r^5wSRLHCAAN\u0003A\u0011XmY8wKJLX*\u001a;bI\u0006$\u0018-\u0006\u0002\u0003\u0012A\u0019!1C\u0002\u000f\u0005\u0019\u0003\u0011!B:uCR,WC\u0001B\r!\r1%1D\u0005\u0004\u0005;a$\u0001D*fgNLwN\\*uCR,\u0017!B:uCJ$\u0018\u0001B:u_B$\"A!\n\u0011\r\u0005u$q\u0005B\u0016\u0013\u0011\u0011I#a \u0003\r\u0019+H/\u001e:f!\rQ%QF\u0005\u0004\u0005_Y%AB!osZ\u000bG.\u0001\u0005u_N#(/\u001b8h)\u0005)\u0017aC:u_B\u001cVm]:j_:\f\u0011\u0002\u001d:pqf,6/\u001a:\u0002\u0013\u0011|\u0017i](x]\u0016\u0014X\u0003\u0002B\u001f\u0005\u0007\"BAa\u0010\u0003VA!!\u0011\tB\"\u0019\u0001!qA!\u00129\u0005\u0004\u00119EA\u0001U#\u0011\u0011IEa\u0014\u0011\u0007)\u0013Y%C\u0002\u0003N-\u0013qAT8uQ&tw\rE\u0002K\u0005#J1Aa\u0015L\u0005\r\te.\u001f\u0005\t\u0005/BD\u00111\u0001\u0003Z\u0005\u0011aM\u001c\t\u0006\u0015\nm#qH\u0005\u0004\u0005;Z%\u0001\u0003\u001fcs:\fW.\u001a \u0002%\r|\u0007/\u001f*fg>,(oY3U_\"#ei\u0015\u000b\u0007\u0003?\u0011\u0019Ga\u001d\t\u000f\t\u0015\u0014\b1\u0001\u0003h\u0005QA-\u0019;b'R\u0014X-Y7\u0011\t\t%$qN\u0007\u0003\u0005WRAA!\u001c\u0002(\u0005\u0011\u0011n\\\u0005\u0005\u0005c\u0012YGA\u0006J]B,Ho\u0015;sK\u0006l\u0007BBA s\u0001\u0007Q-A\u0007hKR\u001cF/Y4j]\u001e$\u0015N\u001d\u000b\u0005\u0003\u0017\u0014I\bC\u0004\u0002Rj\u0002\rAa\u001f\u0011\t\u00055'QP\u0005\u0005\u0005\u007f\nyM\u0001\u0006GS2,7+_:uK6\u0004")
public abstract class Session
implements Logging {
    private final int id;
    private final Option<String> name;
    private final String owner;
    private final Option<String> ttl;
    private final Option<String> idleTimeout;
    private final LivyConf livyConf;
    private final ExecutionContext sessionManageExecutors;
    private final ExecutionContextExecutor executionContext;
    private Option<String> _appId;
    private long _lastActivity;
    private Option<Object> startedOn;
    private Path stagingDir;
    private AppInfo appInfo;
    private Logger logger;
    private volatile boolean bitmap$0;

    public static URI resolveURI(URI uRI, LivyConf livyConf) {
        return Session$.MODULE$.resolveURI(uRI, livyConf);
    }

    public static Seq<String> resolveURIs(Seq<String> seq, LivyConf livyConf) {
        return Session$.MODULE$.resolveURIs(seq, livyConf);
    }

    public static Map<String, String> prepareConf(Map<String, String> map, Seq<String> seq, Seq<String> seq2, Seq<String> seq3, Seq<String> seq4, LivyConf livyConf) {
        return Session$.MODULE$.prepareConf(map, seq, seq2, seq3, seq4, livyConf);
    }

    public static Set<String> configBlackList() {
        return Session$.MODULE$.configBlackList();
    }

    public static Set<String> BLACKLIST_CUSTOM_CLASSPATH() {
        return Session$.MODULE$.BLACKLIST_CUSTOM_CLASSPATH();
    }

    public void trace(Function0<Object> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        Session session = this;
        synchronized (session) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public int id() {
        return this.id;
    }

    public Option<String> name() {
        return this.name;
    }

    public String owner() {
        return this.owner;
    }

    public Option<String> ttl() {
        return this.ttl;
    }

    public Option<String> idleTimeout() {
        return this.idleTimeout;
    }

    public LivyConf livyConf() {
        return this.livyConf;
    }

    public ExecutionContext sessionManageExecutors() {
        return this.sessionManageExecutors;
    }

    public ExecutionContextExecutor executionContext() {
        return this.executionContext;
    }

    public Option<String> _appId() {
        return this._appId;
    }

    public void _appId_$eq(Option<String> x$1) {
        this._appId = x$1;
    }

    private long _lastActivity() {
        return this._lastActivity;
    }

    private void _lastActivity_$eq(long x$1) {
        this._lastActivity = x$1;
    }

    public Option<Object> startedOn() {
        return this.startedOn;
    }

    public void startedOn_$eq(Option<Object> x$1) {
        this.startedOn = x$1;
    }

    private Path stagingDir() {
        return this.stagingDir;
    }

    private void stagingDir_$eq(Path x$1) {
        this.stagingDir = x$1;
    }

    public Option<String> appId() {
        return this._appId();
    }

    public AppInfo appInfo() {
        return this.appInfo;
    }

    public void appInfo_$eq(AppInfo x$1) {
        this.appInfo = x$1;
    }

    public long lastActivity() {
        SessionState sessionState = this.state();
        if (sessionState instanceof SessionState.Error) {
            SessionState.Error error = (SessionState.Error)sessionState;
            long time = error.time();
            return time;
        }
        if (sessionState instanceof SessionState.Dead) {
            SessionState.Dead dead = (SessionState.Dead)sessionState;
            long time = dead.time();
            return time;
        }
        if (sessionState instanceof SessionState.Success) {
            SessionState.Success success = (SessionState.Success)sessionState;
            long time = success.time();
            return time;
        }
        return this._lastActivity();
    }

    public abstract IndexedSeq<String> logLines();

    public void recordActivity() {
        this._lastActivity_$eq(System.nanoTime());
    }

    public abstract RecoveryMetadata recoveryMetadata();

    public abstract SessionState state();

    public abstract void start();

    public Future<Object> stop() {
        return Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Object object;
            block5: {
                try {
                    this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(12).append("Stopping ").append(this).append("...").toString());
                    this.stopSession();
                    this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(9).append("Stopped ").append(this).append(".").toString());
                }
                catch (Exception e) {
                    this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Error stopping session ").append(this.id()).append(".").toString(), e);
                }
                try {
                    if (this.stagingDir() != null) {
                        this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Deleting session ").append(this.id()).append(" staging directory ").append(this.stagingDir()).toString());
                        object = this.doAsOwner((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                            boolean bl;
                            try (FileSystem fs = FileSystem.newInstance((Configuration)this.livyConf().hadoopConf());){
                                bl = fs.delete(this.stagingDir(), true);
                            }
                            return bl;
                        });
                        break block5;
                    }
                    object = BoxedUnit.UNIT;
                }
                catch (Exception e) {
                    this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Error cleaning up session ").append(this.id()).append(" staging dir.").toString(), e);
                    object = BoxedUnit.UNIT;
                }
            }
            return object;
        }, this.sessionManageExecutors());
    }

    public String toString() {
        return new StringBuilder(1).append(this.getClass().getSimpleName()).append(" ").append(this.id()).toString();
    }

    public abstract void stopSession();

    public abstract Option<String> proxyUser();

    public <T> T doAsOwner(Function0<T> fn) {
        String user = (String)this.proxyUser().getOrElse((Function0 & Serializable & scala.Serializable)() -> this.owner());
        if (user != null) {
            UserGroupInformation ugi = UserGroupInformation.isSecurityEnabled() ? (this.livyConf().getBoolean(LivyConf$.MODULE$.IMPERSONATION_ENABLED()) ? UserGroupInformation.createProxyUser((String)user, (UserGroupInformation)UserGroupInformation.getCurrentUser()) : UserGroupInformation.getCurrentUser()) : UserGroupInformation.createRemoteUser((String)user);
            return (T)ugi.doAs(new PrivilegedExceptionAction<T>(null, fn){
                private final Function0 fn$1;

                public T run() {
                    return (T)this.fn$1.apply();
                }
                {
                    this.fn$1 = fn$1;
                }
            });
        }
        return (T)fn.apply();
    }

    public URI copyResourceToHDFS(InputStream dataStream, String name) {
        return (URI)this.doAsOwner((Function0 & Serializable & scala.Serializable)() -> {
            URI uRI;
            try (FileSystem fs = FileSystem.newInstance((Configuration)this.livyConf().hadoopConf());){
                Path filePath = new Path(this.getStagingDir(fs), name);
                this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Uploading user file to ").append(filePath).toString());
                FSDataOutputStream outFile = fs.create(filePath, true);
                byte[] buffer = new byte[524288];
                int read = -1;
                try {
                    while ((read = dataStream.read(buffer)) != -1) {
                        outFile.write(buffer, 0, read);
                    }
                }
                finally {
                    outFile.close();
                }
                uRI = filePath.toUri();
            }
            return uRI;
        });
    }

    private synchronized Path getStagingDir(FileSystem fs) {
        block0: {
            if (this.stagingDir() != null) break block0;
            String stagingRoot = (String)Option$.MODULE$.apply((Object)this.livyConf().get(LivyConf$.MODULE$.SESSION_STAGING_DIR())).getOrElse((Function0 & Serializable & scala.Serializable)() -> new Path(fs.getHomeDirectory(), ".livy-sessions").toString());
            Path sessionDir = new Path(stagingRoot, UUID.randomUUID().toString());
            fs.mkdirs(sessionDir);
            fs.setPermission(sessionDir, new FsPermission("700"));
            this.stagingDir_$eq(sessionDir);
            this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Session ").append(this.id()).append(" staging directory is ").append(this.stagingDir()).toString());
        }
        return this.stagingDir();
    }

    public static final /* synthetic */ void $anonfun$new$1(String sessionName) {
        if (new StringOps(Predef$.MODULE$.augmentString(sessionName)).forall((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)RichChar$.MODULE$.isDigit$extension(Predef$.MODULE$.charWrapper(BoxesRunTime.unboxToChar((Object)x$3)))))) {
            throw new IllegalArgumentException(new StringBuilder(22).append("Invalid session name: ").append(sessionName).toString());
        }
    }

    public Session(int id, Option<String> name, String owner, Option<String> ttl, Option<String> idleTimeout, LivyConf livyConf) {
        this.id = id;
        this.name = name;
        this.owner = owner;
        this.ttl = ttl;
        this.idleTimeout = idleTimeout;
        this.livyConf = livyConf;
        Logging.$init$((Logging)this);
        int poolSize = livyConf.getInt(LivyConf$.MODULE$.SESSION_MANAGE_THREADS());
        int poolQueueSize = livyConf.getInt(LivyConf$.MODULE$.SESSION_MANAGE_WAIT_QUEUE_SIZE());
        long keepAliveTime = livyConf.getTimeAsMs(LivyConf$.MODULE$.SESSION_MANAGE_KEEPALIVE_TIME()) / 1000L;
        this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(90).append("Background session manage executors with size=").append(poolSize).append(",").append(" wait queue size= ").append(poolQueueSize).append(", keepalive time ").append(keepAliveTime).append(" seconds").toString());
        LinkedBlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>(poolQueueSize);
        ThreadPoolExecutor executor = new ThreadPoolExecutor(poolSize, poolSize, keepAliveTime, TimeUnit.SECONDS, queue, new NamedThreadFactory("LivyServer2-SessionManageExecutors"));
        executor.allowCoreThreadTimeOut(true);
        this.sessionManageExecutors = ExecutionContext$.MODULE$.fromExecutorService((ExecutorService)executor);
        this.executionContext = ExecutionContext$.MODULE$.global();
        name.foreach((Function1 & Serializable & scala.Serializable)sessionName -> {
            Session.$anonfun$new$1(sessionName);
            return BoxedUnit.UNIT;
        });
        this._appId = None$.MODULE$;
        this._lastActivity = System.nanoTime();
        this.startedOn = None$.MODULE$;
        this.stagingDir = null;
        this.appInfo = new AppInfo(AppInfo$.MODULE$.apply$default$1(), AppInfo$.MODULE$.apply$default$2(), AppInfo$.MODULE$.apply$default$3());
    }

    public Session(int id, Option<String> name, String owner, LivyConf livyConf) {
        this(id, name, owner, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, livyConf);
    }

    public static interface RecoveryMetadata {
        public int id();
    }
}

