/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.mqtt.handler.v3;

import io.netty.channel.ChannelHandlerContext;
import lombok.Generated;
import org.apache.bifromq.inbox.storage.proto.InboxVersion;
import org.apache.bifromq.inbox.storage.proto.LWT;
import org.apache.bifromq.metrics.ITenantMeter;
import org.apache.bifromq.mqtt.handler.IMQTTProtocolHelper;
import org.apache.bifromq.mqtt.handler.MQTTPersistentSessionHandler;
import org.apache.bifromq.mqtt.handler.TenantSettings;
import org.apache.bifromq.mqtt.handler.condition.Condition;
import org.apache.bifromq.mqtt.handler.v3.MQTT3ProtocolHelper;
import org.apache.bifromq.type.ClientInfo;

public final class MQTT3PersistentSessionHandler
extends MQTTPersistentSessionHandler {
    private final IMQTTProtocolHelper helper;

    public MQTT3PersistentSessionHandler(TenantSettings settings, ITenantMeter tenantMeter, Condition oomCondition, String userSessionId, int keepAliveTimeSeconds, int sessionExpirySeconds, ClientInfo clientInfo, InboxVersion inboxVersion, LWT noDelayLWT, ChannelHandlerContext ctx) {
        super(settings, tenantMeter, oomCondition, userSessionId, keepAliveTimeSeconds, sessionExpirySeconds, clientInfo, inboxVersion, noDelayLWT, ctx);
        this.helper = new MQTT3ProtocolHelper(settings, clientInfo, this.sessionCtx.userPropsCustomizer);
    }

    @Override
    protected IMQTTProtocolHelper helper() {
        return this.helper;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) {
        super.handlerAdded(ctx);
        this.memUsage.addAndGet(this.estBaseMemSize());
    }

    @Override
    public void doTearDown(ChannelHandlerContext ctx) {
        super.doTearDown(ctx);
        this.memUsage.addAndGet(-this.estBaseMemSize());
    }

    private int estBaseMemSize() {
        int s = 400;
        s += this.userSessionId.length();
        s += this.clientInfo.getSerializedSize();
        if (this.willMessage() != null) {
            s += this.willMessage().getSerializedSize();
        }
        return s;
    }

    @Generated
    public static MQTT3PersistentSessionHandlerBuilder builder() {
        return new MQTT3PersistentSessionHandlerBuilder();
    }

    @Generated
    public static class MQTT3PersistentSessionHandlerBuilder {
        @Generated
        private TenantSettings settings;
        @Generated
        private ITenantMeter tenantMeter;
        @Generated
        private Condition oomCondition;
        @Generated
        private String userSessionId;
        @Generated
        private int keepAliveTimeSeconds;
        @Generated
        private int sessionExpirySeconds;
        @Generated
        private ClientInfo clientInfo;
        @Generated
        private InboxVersion inboxVersion;
        @Generated
        private LWT noDelayLWT;
        @Generated
        private ChannelHandlerContext ctx;

        @Generated
        MQTT3PersistentSessionHandlerBuilder() {
        }

        @Generated
        public MQTT3PersistentSessionHandlerBuilder settings(TenantSettings settings) {
            this.settings = settings;
            return this;
        }

        @Generated
        public MQTT3PersistentSessionHandlerBuilder tenantMeter(ITenantMeter tenantMeter) {
            this.tenantMeter = tenantMeter;
            return this;
        }

        @Generated
        public MQTT3PersistentSessionHandlerBuilder oomCondition(Condition oomCondition) {
            this.oomCondition = oomCondition;
            return this;
        }

        @Generated
        public MQTT3PersistentSessionHandlerBuilder userSessionId(String userSessionId) {
            this.userSessionId = userSessionId;
            return this;
        }

        @Generated
        public MQTT3PersistentSessionHandlerBuilder keepAliveTimeSeconds(int keepAliveTimeSeconds) {
            this.keepAliveTimeSeconds = keepAliveTimeSeconds;
            return this;
        }

        @Generated
        public MQTT3PersistentSessionHandlerBuilder sessionExpirySeconds(int sessionExpirySeconds) {
            this.sessionExpirySeconds = sessionExpirySeconds;
            return this;
        }

        @Generated
        public MQTT3PersistentSessionHandlerBuilder clientInfo(ClientInfo clientInfo) {
            this.clientInfo = clientInfo;
            return this;
        }

        @Generated
        public MQTT3PersistentSessionHandlerBuilder inboxVersion(InboxVersion inboxVersion) {
            this.inboxVersion = inboxVersion;
            return this;
        }

        @Generated
        public MQTT3PersistentSessionHandlerBuilder noDelayLWT(LWT noDelayLWT) {
            this.noDelayLWT = noDelayLWT;
            return this;
        }

        @Generated
        public MQTT3PersistentSessionHandlerBuilder ctx(ChannelHandlerContext ctx) {
            this.ctx = ctx;
            return this;
        }

        @Generated
        public MQTT3PersistentSessionHandler build() {
            return new MQTT3PersistentSessionHandler(this.settings, this.tenantMeter, this.oomCondition, this.userSessionId, this.keepAliveTimeSeconds, this.sessionExpirySeconds, this.clientInfo, this.inboxVersion, this.noDelayLWT, this.ctx);
        }

        @Generated
        public String toString() {
            return "MQTT3PersistentSessionHandler.MQTT3PersistentSessionHandlerBuilder(settings=" + String.valueOf(this.settings) + ", tenantMeter=" + String.valueOf(this.tenantMeter) + ", oomCondition=" + String.valueOf(this.oomCondition) + ", userSessionId=" + this.userSessionId + ", keepAliveTimeSeconds=" + this.keepAliveTimeSeconds + ", sessionExpirySeconds=" + this.sessionExpirySeconds + ", clientInfo=" + String.valueOf(this.clientInfo) + ", inboxVersion=" + String.valueOf(this.inboxVersion) + ", noDelayLWT=" + String.valueOf(this.noDelayLWT) + ", ctx=" + String.valueOf(this.ctx) + ")";
        }
    }
}

