/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std.json;

import io.questdb.std.Os;
import io.questdb.std.QuietCloseable;
import io.questdb.std.bytes.NativeByteSink;
import io.questdb.std.json.SimdJsonError;
import io.questdb.std.json.SimdJsonResult;
import io.questdb.std.str.DirectUtf8Sequence;
import io.questdb.std.str.DirectUtf8Sink;
import org.jetbrains.annotations.NotNull;

public class SimdJsonParser
implements QuietCloseable {
    public static final int SIMDJSON_PADDING;
    private long impl = SimdJsonParser.create();

    public static void convertJsonPathToPointer(@NotNull DirectUtf8Sequence path, @NotNull DirectUtf8Sink dest) {
        try (NativeByteSink destSink = dest.borrowDirectByteSink();){
            SimdJsonParser.convertJsonPathToPointer(path.ptr(), path.size(), destSink.ptr());
        }
    }

    @Override
    public void close() {
        if (this.impl != 0L) {
            SimdJsonParser.destroy(this.impl);
            this.impl = 0L;
        }
    }

    public boolean queryPointerBoolean(DirectUtf8Sequence json, DirectUtf8Sequence pointer, SimdJsonResult result) {
        assert (json.tailPadding() >= (long)SIMDJSON_PADDING);
        return SimdJsonParser.queryPointerBoolean(this.impl, json.ptr(), json.size(), json.tailPadding(), pointer.ptr(), pointer.size(), result.ptr());
    }

    public double queryPointerDouble(DirectUtf8Sequence json, DirectUtf8Sequence pointer, SimdJsonResult result) {
        assert (json.tailPadding() >= (long)SIMDJSON_PADDING);
        return SimdJsonParser.queryPointerDouble(this.impl, json.ptr(), json.size(), json.tailPadding(), pointer.ptr(), pointer.size(), result.ptr());
    }

    public int queryPointerInt(DirectUtf8Sequence json, DirectUtf8Sequence pointer, SimdJsonResult result) {
        assert (json.tailPadding() >= (long)SIMDJSON_PADDING);
        return SimdJsonParser.queryPointerInt(this.impl, json.ptr(), json.size(), json.tailPadding(), pointer.ptr(), pointer.size(), result.ptr());
    }

    public long queryPointerLong(DirectUtf8Sequence json, DirectUtf8Sequence pointer, SimdJsonResult result) {
        assert (json.tailPadding() >= (long)SIMDJSON_PADDING);
        return SimdJsonParser.queryPointerLong(this.impl, json.ptr(), json.size(), json.tailPadding(), pointer.ptr(), pointer.size(), result.ptr());
    }

    public short queryPointerShort(DirectUtf8Sequence json, DirectUtf8Sequence pointer, SimdJsonResult result) {
        assert (json.tailPadding() >= (long)SIMDJSON_PADDING);
        return SimdJsonParser.queryPointerShort(this.impl, json.ptr(), json.size(), json.tailPadding(), pointer.ptr(), pointer.size(), result.ptr());
    }

    public void queryPointerUtf8(DirectUtf8Sequence json, DirectUtf8Sequence pointer, SimdJsonResult result, DirectUtf8Sink dest, int maxSize) {
        assert (json.tailPadding() >= (long)SIMDJSON_PADDING);
        long nativeByteSinkPtr = dest.borrowDirectByteSink().ptr();
        assert (dest.capacity() - (long)dest.size() >= (long)maxSize);
        SimdJsonParser.queryPointerUtf8(this.impl, json.ptr(), json.size(), json.tailPadding(), json.isAscii(), pointer.ptr(), pointer.size(), result.ptr(), nativeByteSinkPtr, maxSize);
    }

    public long queryPointerValue(DirectUtf8Sequence json, DirectUtf8Sequence pointer, SimdJsonResult result, DirectUtf8Sink dest, int maxSize) {
        assert (json.tailPadding() >= (long)SIMDJSON_PADDING);
        assert (dest.capacity() - (long)dest.size() >= (long)maxSize);
        return SimdJsonParser.queryPointerValue(this.impl, json.ptr(), json.size(), json.tailPadding(), pointer.ptr(), pointer.size(), result.ptr(), dest.borrowDirectByteSink().ptr(), maxSize);
    }

    private static native void convertJsonPathToPointer(long var0, long var2, long var4);

    private static native long create();

    private static native void destroy(long var0);

    private static native int getSimdJsonPadding();

    private static native boolean queryPointerBoolean(long var0, long var2, long var4, long var6, long var8, long var10, long var12);

    private static native double queryPointerDouble(long var0, long var2, long var4, long var6, long var8, long var10, long var12);

    private static native int queryPointerInt(long var0, long var2, long var4, long var6, long var8, long var10, long var12);

    private static native long queryPointerLong(long var0, long var2, long var4, long var6, long var8, long var10, long var12);

    private static native short queryPointerShort(long var0, long var2, long var4, long var6, long var8, long var10, long var12);

    private static native void queryPointerUtf8(long var0, long var2, long var4, long var6, boolean var8, long var9, long var11, long var13, long var15, int var17);

    private static native long queryPointerValue(long var0, long var2, long var4, long var6, long var8, long var10, long var12, long var14, int var16);

    static {
        Os.init();
        SIMDJSON_PADDING = SimdJsonParser.getSimdJsonPadding();
        SimdJsonError.init();
    }
}

