/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std.histogram.org.HdrHistogram;

import io.questdb.std.histogram.org.HdrHistogram.EncodableHistogram;
import io.questdb.std.histogram.org.HdrHistogram.PercentileIterator;
import io.questdb.std.histogram.org.HdrHistogram.RecordedValuesIterator;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;

abstract class AbstractHistogramBase
extends EncodableHistogram {
    static final AtomicLong constructionIdentityCount = new AtomicLong(0L);
    volatile boolean autoResize = false;
    int bucketCount;
    int countsArrayLength;
    double doubleToIntegerValueConversionRatio = 1.0;
    long endTimeStampMsec = 0L;
    long highestTrackableValue;
    long identity;
    double integerToDoubleValueConversionRatio = 1.0;
    byte[] intermediateUncompressedByteArray = null;
    ByteBuffer intermediateUncompressedByteBuffer = null;
    long lowestDiscernibleValue;
    int numberOfSignificantValueDigits;
    PercentileIterator percentileIterator;
    RecordedValuesIterator recordedValuesIterator;
    long startTimeStampMsec = Long.MAX_VALUE;
    int subBucketCount;
    String tag = null;
    int wordSizeInBytes;

    AbstractHistogramBase() {
    }

    public int bucketCount() {
        return this.bucketCount;
    }

    public int countsArrayLength() {
        return this.countsArrayLength;
    }

    public int subBucketCount() {
        return this.subBucketCount;
    }

    double getDoubleToIntegerValueConversionRatio() {
        return this.doubleToIntegerValueConversionRatio;
    }

    double getIntegerToDoubleValueConversionRatio() {
        return this.integerToDoubleValueConversionRatio;
    }

    void nonConcurrentSetIntegerToDoubleValueConversionRatio(double integerToDoubleValueConversionRatio) {
        this.integerToDoubleValueConversionRatio = integerToDoubleValueConversionRatio;
        this.doubleToIntegerValueConversionRatio = 1.0 / integerToDoubleValueConversionRatio;
    }

    abstract void setIntegerToDoubleValueConversionRatio(double var1);
}

