/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.ParanoiaState;
import io.questdb.std.Files;
import io.questdb.std.LongObjHashMap;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.ObjStack;
import io.questdb.std.Utf8SequenceObjHashMap;
import io.questdb.std.str.LPSZ;
import io.questdb.std.str.StringSink;
import io.questdb.std.str.Utf8String;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.Nullable;

public class FdCache {
    static final AtomicInteger OPEN_OS_FILE_COUNT = new AtomicInteger();
    private static final int MAX_RECORD_POOL_CAPACITY = 16384;
    private static final int NON_CACHED = Integer.MIN_VALUE;
    private static final int RO_MASK = 0;
    private final AtomicInteger fdCounter = new AtomicInteger(1);
    private final LongObjHashMap<FdCacheRecord> openFdMapByFd = new LongObjHashMap();
    private final Utf8SequenceObjHashMap<FdCacheRecord> openFdMapByPath = new Utf8SequenceObjHashMap();
    private final ObjStack<FdCacheRecord> recordPool = new ObjStack();
    private long fdReuseCount = 0L;

    public synchronized int close(long fd) {
        int keyIndex = this.openFdMapByFd.keyIndex(fd);
        if (keyIndex > -1) {
            throw new IllegalStateException("fd " + fd + " is already closed!");
        }
        int fdKind = Numbers.decodeLowInt(fd) >>> 30 & 3;
        if (fdKind > 1) {
            int osFd = Numbers.decodeHighInt(fd);
            int res = Files.close0(osFd);
            if (res != 0) {
                return res;
            }
            OPEN_OS_FILE_COUNT.decrementAndGet();
            this.openFdMapByFd.removeAt(keyIndex);
            return 0;
        }
        FdCacheRecord fdCacheRecord = this.openFdMapByFd.valueAt(keyIndex);
        this.openFdMapByFd.removeAt(keyIndex);
        --fdCacheRecord.count;
        if (fdCacheRecord.count == 0) {
            this.openFdMapByPath.remove(fdCacheRecord.path);
            int res = Files.close0(fdCacheRecord.osFd);
            if (res != 0) {
                return res;
            }
            if (this.recordPool.size() < 16384) {
                fdCacheRecord.osFd = -1;
                this.recordPool.push(fdCacheRecord);
            }
            OPEN_OS_FILE_COUNT.decrementAndGet();
        }
        return 0;
    }

    public synchronized long createUniqueFdNonCached(int fd) {
        if (fd > -1) {
            int index = this.fdCounter.getAndIncrement();
            long markedFd = Numbers.encodeLowHighInts(index | Integer.MIN_VALUE, fd);
            this.openFdMapByFd.put(markedFd, FdCacheRecord.EMPTY);
            OPEN_OS_FILE_COUNT.incrementAndGet();
            return markedFd;
        }
        return fd;
    }

    public synchronized long createUniqueFdNonCachedStdOut(int fd) {
        int index = this.fdCounter.getAndIncrement();
        long markedFd = Numbers.encodeLowHighInts(index | Integer.MIN_VALUE, fd);
        this.openFdMapByFd.put(markedFd, FdCacheRecord.EMPTY);
        return markedFd;
    }

    public synchronized void detach(long fd) {
        int keyIndex = this.openFdMapByFd.keyIndex(fd);
        if (keyIndex < 0) {
            FdCacheRecord cacheRecord = this.openFdMapByFd.valueAt(keyIndex);
            if (cacheRecord != FdCacheRecord.EMPTY) {
                throw new IllegalStateException("Cannot detach file cached file descriptor");
            }
            this.openFdMapByFd.removeAt(keyIndex);
            OPEN_OS_FILE_COUNT.decrementAndGet();
        }
    }

    public synchronized long getOpenCachedFileCount() {
        return this.openFdMapByFd.size();
    }

    public synchronized String getOpenFdDebugInfo() {
        StringSink sink = Misc.getThreadLocalSink();
        this.openFdMapByFd.forEach((key, value) -> {
            if (sink.length() > 0) {
                sink.put(',');
            }
            sink.put(key);
        });
        return sink.toString();
    }

    public long getOpenOsFileCount() {
        return OPEN_OS_FILE_COUNT.get();
    }

    public long getReuseCount() {
        return this.fdReuseCount;
    }

    public synchronized long openROCached(LPSZ lpsz) {
        FdCacheRecord holder = this.getFdCacheRecord(lpsz);
        if (holder == null) {
            return -1L;
        }
        ++holder.count;
        long uniqROFd = this.createUniqueFdRO(holder.osFd);
        this.openFdMapByFd.put(uniqROFd, holder);
        return uniqROFd;
    }

    public synchronized boolean remove(LPSZ lpsz) {
        this.openFdMapByPath.remove(lpsz);
        return Files.remove(lpsz.ptr());
    }

    public synchronized int rename(LPSZ oldName, LPSZ newName) {
        int keyIndex = this.openFdMapByPath.keyIndex(oldName);
        int result = Files.rename(oldName.ptr(), newName.ptr());
        if (result == 0 && keyIndex < 0) {
            FdCacheRecord record = this.openFdMapByPath.valueAt(keyIndex);
            this.openFdMapByPath.removeAt(keyIndex);
            Utf8String path = Utf8String.newInstance(newName);
            this.openFdMapByPath.put(path, record);
            record.path = path;
        }
        return result;
    }

    public synchronized long toMmapCacheFd(long fd) {
        FdCacheRecord cacheRecord = this.openFdMapByFd.get(fd);
        if (cacheRecord == null) {
            return 0L;
        }
        return cacheRecord.mmapCacheFd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int toOsFd(long fd) {
        if (ParanoiaState.FD_PARANOIA_MODE && fd != -1L) {
            FdCache fdCache = this;
            synchronized (fdCache) {
                int keyIndex = this.openFdMapByFd.keyIndex(fd);
                assert (keyIndex < 0) : "Invalid fd=" + fd + ", not found in cache";
            }
        }
        int osFd = Numbers.decodeHighInt(fd);
        assert (fd == -1L || osFd > 0);
        return osFd;
    }

    public int toOsFd(long fd, boolean write) {
        assert (!write || Numbers.decodeLowInt(fd) >>> 30 != 0) : "RO fd cannot be used for writing: " + fd;
        return this.toOsFd(fd);
    }

    private FdCacheRecord createFdCacheRecord(Utf8String path, long mmapCacheFd) {
        FdCacheRecord holder = this.recordPool.pop();
        if (holder == null) {
            holder = new FdCacheRecord(path, mmapCacheFd);
        } else {
            holder.path = path;
            holder.mmapCacheFd = mmapCacheFd;
        }
        return holder;
    }

    private long createUniqueFdRO(int fd) {
        int index = this.fdCounter.getAndIncrement();
        return Numbers.encodeLowHighInts(index | 0, fd);
    }

    @Nullable
    private FdCacheRecord getFdCacheRecord(LPSZ lpsz) {
        FdCacheRecord holder;
        int keyIndex = this.openFdMapByPath.keyIndex(lpsz);
        if (keyIndex > -1) {
            int osFd = Files.openRO(lpsz.ptr());
            if (osFd < 0) {
                holder = null;
            } else {
                OPEN_OS_FILE_COUNT.incrementAndGet();
                Utf8String path = Utf8String.newInstance(lpsz);
                holder = this.createFdCacheRecord(path, Numbers.encodeLowHighInts(this.fdCounter.incrementAndGet(), osFd));
                holder.osFd = osFd;
                this.openFdMapByPath.putAt(keyIndex, lpsz, holder);
            }
        } else {
            holder = this.openFdMapByPath.valueAtQuick(keyIndex);
            ++this.fdReuseCount;
        }
        return holder;
    }

    private static class FdCacheRecord {
        private static final FdCacheRecord EMPTY = new FdCacheRecord(null, 0L);
        long mmapCacheFd;
        private int count;
        private int osFd;
        private Utf8String path;

        public FdCacheRecord(Utf8String path, long mmapCacheFd) {
            this.path = path;
            this.mmapCacheFd = mmapCacheFd;
        }
    }
}

