/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.network;

import io.questdb.network.AbstractIODispatcher;
import io.questdb.network.FDSet;
import io.questdb.network.IOContext;
import io.questdb.network.IOContextFactory;
import io.questdb.network.IODispatcherConfiguration;
import io.questdb.network.IOEvent;
import io.questdb.network.SelectFacade;
import io.questdb.network.SuspendEvent;
import io.questdb.std.LongIntHashMap;
import io.questdb.std.Misc;

public class IODispatcherWindows<C extends IOContext<C>>
extends AbstractIODispatcher<C> {
    private final LongIntHashMap fds = new LongIntHashMap();
    private final FDSet readFdSet;
    private final SelectFacade sf;
    private final FDSet writeFdSet;
    private long idSeq = 1L;
    private boolean listenerRegistered;

    public IODispatcherWindows(IODispatcherConfiguration configuration, IOContextFactory<C> ioContextFactory) {
        super(configuration, ioContextFactory);
        this.sf = configuration.getSelectFacade();
        this.readFdSet = new FDSet(configuration.getEventCapacity());
        this.writeFdSet = new FDSet(configuration.getEventCapacity());
        this.readFdSet.add(this.serverFd);
        this.readFdSet.setCount(1);
        this.writeFdSet.setCount(0);
        this.listenerRegistered = true;
    }

    @Override
    public void close() {
        super.close();
        Misc.free(this.readFdSet);
        Misc.free(this.writeFdSet);
        this.LOG.info().$("closed").$();
    }

    private long nextOpId() {
        return this.idSeq++;
    }

    private boolean processRegistrations(long timestamp) {
        long cursor;
        boolean useful = false;
        while ((cursor = this.interestSubSeq.next()) > -1L) {
            IOEvent evt = (IOEvent)this.interestQueue.get(cursor);
            Object context = evt.context;
            int operation = evt.operation;
            long srcOpId = ((IOContext)context).getAndResetHeartbeatId();
            long opId = this.nextOpId();
            long fd = ((IOContext)context).getFd();
            this.interestSubSeq.done(cursor);
            if (operation == 8) {
                assert (srcOpId != -1L);
                int heartbeatRow = this.pendingHeartbeats.binarySearch(srcOpId, 4);
                if (heartbeatRow < 0) continue;
                operation = (int)this.pendingHeartbeats.get(heartbeatRow, 2);
                this.LOG.debug().$("processing heartbeat registration [fd=").$(fd).$(", op=").$(operation).$(", srcId=").$(srcOpId).$(", id=").$(opId).I$();
                int r = this.pending.addRow();
                this.pending.set(r, 0, this.pendingHeartbeats.get(heartbeatRow, 0));
                this.pending.set(r, 3, timestamp);
                this.pending.set(r, 1, fd);
                this.pending.set(r, 4, opId);
                this.pending.set(r, 2, operation);
                this.pending.set(r, context);
                this.pendingHeartbeats.deleteRow(heartbeatRow);
            } else {
                if (operation == 1 && ((IOContext)context).getSocket().isMorePlaintextBuffered()) {
                    this.publishOperation(1, context);
                    continue;
                }
                this.LOG.debug().$("processing registration [fd=").$(fd).$(", op=").$(operation).$(", id=").$(opId).I$();
                int r = this.pending.addRow();
                this.pending.set(r, 0, timestamp);
                this.pending.set(r, 3, timestamp);
                this.pending.set(r, 1, ((IOContext)context).getFd());
                this.pending.set(r, 4, opId);
                this.pending.set(r, 2, operation);
                this.pending.set(r, context);
            }
            useful = true;
        }
        return useful;
    }

    private void queryFdSets(long timestamp) {
        long fd;
        int i;
        int n = this.readFdSet.getCount();
        for (i = 0; i < n; ++i) {
            fd = this.readFdSet.get(i);
            if (fd == this.serverFd) {
                this.accept(timestamp);
                continue;
            }
            this.fds.put(fd, 1);
        }
        n = this.writeFdSet.getCount();
        for (i = 0; i < n; ++i) {
            fd = this.writeFdSet.get(i);
            int index = this.fds.keyIndex(fd);
            if (this.fds.valueAt(index) == -1) {
                this.fds.putAt(index, fd, 2);
                continue;
            }
            this.fds.putAt(index, fd, 3);
        }
    }

    @Override
    protected void pendingAdded(int index) {
        this.pending.set(index, 2, this.initialBias == 1 ? 1L : 4L);
    }

    @Override
    protected void registerListenerFd() {
        this.listenerRegistered = true;
    }

    @Override
    protected boolean runSerially() {
        int count;
        long timestamp = this.clock.getTicks();
        this.processDisconnects(timestamp);
        if (this.readFdSet.getCount() > 0 || this.writeFdSet.getCount() > 0) {
            count = this.sf.select(this.readFdSet.address(), this.writeFdSet.address(), 0L, 0);
            if (count < 0) {
                this.LOG.error().$("select failure [err=").$(this.nf.errno()).I$();
                return false;
            }
        } else {
            count = 0;
        }
        boolean useful = false;
        this.fds.clear();
        int watermark = this.pending.size();
        if (count > 0) {
            this.queryFdSets(timestamp);
            useful = true;
        }
        useful |= this.processRegistrations(timestamp);
        int readFdCount = 0;
        int writeFdCount = 0;
        this.readFdSet.clear();
        this.writeFdSet.clear();
        long deadline = timestamp - this.idleConnectionTimeout;
        long heartbeatTimestamp = timestamp - this.heartbeatIntervalMs;
        int i = 0;
        int n = this.pending.size();
        while (i < n) {
            boolean readyForRead;
            IOContext context = (IOContext)this.pending.get(i);
            SuspendEvent suspendEvent = context.getSuspendEvent();
            if (suspendEvent != null && (suspendEvent.checkTriggered() || suspendEvent.isDeadlineMet(timestamp))) {
                context.clearSuspendEvent();
            }
            long fd = this.pending.get(i, 1);
            int newOp = this.fds.get(fd);
            assert (fd != this.serverFd);
            if (newOp == -1) {
                if (this.pending.get(i, 0) < deadline) {
                    this.doDisconnect(context, 1);
                    this.pending.deleteRow(i);
                    --n;
                    if (i < watermark) {
                        --watermark;
                    }
                    useful = true;
                    continue;
                }
                if (i < watermark && this.pending.get(i, 3) < heartbeatTimestamp) {
                    long opId = this.pending.get(i, 4);
                    context.setHeartbeatId(opId);
                    this.publishOperation(8, context);
                    int r = this.pendingHeartbeats.addRow();
                    this.pendingHeartbeats.set(r, 0, this.pending.get(i, 0));
                    this.pendingHeartbeats.set(r, 1, fd);
                    this.pendingHeartbeats.set(r, 4, opId);
                    this.pendingHeartbeats.set(r, 2, this.pending.get(i, 2));
                    this.pendingHeartbeats.set(r, context);
                    this.pending.deleteRow(i);
                    --n;
                    --watermark;
                    useful = true;
                    continue;
                }
                int operation = (int)this.pending.get(i, 2);
                ++i;
                if (suspendEvent != null) {
                    operation = 1;
                }
                if (operation == 1 || context.getSocket().wantsTlsRead()) {
                    this.readFdSet.add(fd);
                    ++readFdCount;
                }
                if (operation != 4 && !context.getSocket().wantsTlsWrite()) continue;
                this.writeFdSet.add(fd);
                ++writeFdCount;
                continue;
            }
            if (suspendEvent != null) {
                if (this.testConnection(context.getFd())) {
                    this.doDisconnect(context, 3);
                    this.pending.deleteRow(i);
                    --n;
                    --watermark;
                    continue;
                }
                this.readFdSet.add(fd);
                ++readFdCount;
                if (context.getSocket().wantsTlsWrite()) {
                    this.writeFdSet.add(fd);
                    ++writeFdCount;
                }
                ++i;
                continue;
            }
            useful = true;
            int requestedOp = (int)this.pending.get(i, 2);
            boolean readyForWrite = (newOp & 2) > 0;
            boolean bl = readyForRead = (newOp & 1) > 0;
            if (requestedOp == 4 && readyForWrite || requestedOp == 1 && readyForRead) {
                if (context.getSocket().tlsIO(IODispatcherWindows.tlsIOFlags(requestedOp, readyForRead, readyForWrite)) < 0) {
                    this.doDisconnect(context, 4);
                    this.pending.deleteRow(i);
                    --n;
                    --watermark;
                    continue;
                }
                this.publishOperation(requestedOp, context);
                this.pending.deleteRow(i);
                --n;
                --watermark;
                continue;
            }
            if (context.getSocket().tlsIO(IODispatcherWindows.tlsIOFlags(readyForRead, readyForWrite)) < 0) {
                this.doDisconnect(context, 4);
                this.pending.deleteRow(i);
                --n;
                --watermark;
                continue;
            }
            if (requestedOp == 1 || context.getSocket().wantsTlsRead()) {
                this.readFdSet.add(fd);
                ++readFdCount;
            }
            if (requestedOp == 4 || context.getSocket().wantsTlsWrite()) {
                this.writeFdSet.add(fd);
                ++writeFdCount;
            }
            ++i;
        }
        if (this.listenerRegistered) {
            assert (this.serverFd >= 0L);
            this.readFdSet.add(this.serverFd);
            ++readFdCount;
        }
        this.readFdSet.setCount(readFdCount);
        this.writeFdSet.setCount(writeFdCount);
        return useful;
    }

    @Override
    protected void unregisterListenerFd() {
        this.listenerRegistered = false;
    }
}

