/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.network;

import io.questdb.log.Log;
import io.questdb.network.HeartBeatException;
import io.questdb.network.NetworkFacade;
import io.questdb.network.PeerIsSlowToReadException;
import io.questdb.network.PeerIsSlowToWriteException;
import io.questdb.network.ServerDisconnectException;
import io.questdb.network.Socket;
import io.questdb.network.SocketFactory;
import io.questdb.network.SuspendEvent;
import io.questdb.network.TlsSessionInitFailedException;
import io.questdb.std.Mutable;
import io.questdb.std.QuietCloseable;
import org.jetbrains.annotations.NotNull;

public abstract class IOContext<T extends IOContext<T>>
implements Mutable,
QuietCloseable {
    protected final Socket socket;
    protected long heartbeatId = -1L;
    private int disconnectReason;
    private volatile boolean initialized = false;

    protected IOContext(@NotNull SocketFactory socketFactory, NetworkFacade nf, Log log) {
        this.socket = socketFactory.newInstance(nf, log);
    }

    @Override
    public void clear() {
        this._clear();
    }

    @Override
    public void close() {
        this._clear();
    }

    public long getAndResetHeartbeatId() {
        long id = this.heartbeatId;
        this.heartbeatId = -1L;
        return id;
    }

    public int getDisconnectReason() {
        return this.disconnectReason;
    }

    public long getFd() {
        return this.socket != null ? this.socket.getFd() : -1L;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public SuspendEvent getSuspendEvent() {
        return null;
    }

    public final void init() throws TlsSessionInitFailedException {
        if (!this.initialized) {
            this.doInit();
            this.initialized = true;
        }
    }

    public boolean invalid() {
        return this.socket.isClosed();
    }

    public final T of(long fd) {
        this.socket.of(fd);
        return (T)this;
    }

    public ServerDisconnectException registerDispatcherDisconnect(int reason) {
        this.disconnectReason = reason;
        return ServerDisconnectException.INSTANCE;
    }

    public HeartBeatException registerDispatcherHeartBeat() {
        return HeartBeatException.INSTANCE;
    }

    public PeerIsSlowToWriteException registerDispatcherRead() {
        return PeerIsSlowToWriteException.INSTANCE;
    }

    public PeerIsSlowToReadException registerDispatcherWrite() {
        return PeerIsSlowToReadException.INSTANCE;
    }

    public void setHeartbeatId(long heartbeatId) {
        this.heartbeatId = heartbeatId;
    }

    private void _clear() {
        this.heartbeatId = -1L;
        this.socket.close();
        this.disconnectReason = -1;
        this.clearSuspendEvent();
        this.initialized = false;
    }

    protected void clearSuspendEvent() {
    }

    protected void doInit() throws TlsSessionInitFailedException {
    }
}

