/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.log;

import io.questdb.cairo.CairoException;
import io.questdb.log.LogError;
import io.questdb.std.CharSequenceIntHashMap;
import io.questdb.std.CharSequenceObjHashMap;
import io.questdb.std.Chars;
import io.questdb.std.ObjList;
import io.questdb.std.datetime.DateFormat;
import io.questdb.std.datetime.microtime.TimestampFormatCompiler;
import io.questdb.std.datetime.microtime.TimestampFormatUtils;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.Sinkable;
import io.questdb.std.str.Utf8StringSink;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;

public class TemplateParser
implements Sinkable {
    private static final String DATE_FORMAT_KEY = "date:";
    private static final int NIL = -1;
    private final TimestampFormatCompiler dateCompiler = new TimestampFormatCompiler();
    private final AtomicLong dateValue = new AtomicLong();
    private final CharSequenceIntHashMap envStartIdxs = new CharSequenceIntHashMap();
    private final Utf8StringSink resolveSink = new Utf8StringSink();
    private final ObjList<TemplateNode> templateNodes = new ObjList();
    private CharSequence originalTxt;
    private CharSequenceObjHashMap<CharSequence> props;

    public static CharSequenceObjHashMap<CharSequence> adaptMap(Map<String, String> props) {
        CharSequenceObjHashMap<CharSequence> properties = new CharSequenceObjHashMap<CharSequence>(props.size());
        for (String key : props.keySet()) {
            properties.put(key, props.get(key));
        }
        return properties;
    }

    public int getKeyOffset(CharSequence key) {
        return this.envStartIdxs.get(key);
    }

    public ObjList<TemplateNode> getTemplateNodes() {
        return this.templateNodes;
    }

    public TemplateParser parse(CharSequence txt, long dateValue, CharSequenceObjHashMap<CharSequence> props) {
        return this.parse(txt, dateValue, props, true);
    }

    public TemplateParser parse(CharSequence txt, long dateValue, Map<String, String> props) {
        return this.parse(txt, dateValue, TemplateParser.adaptMap(props), true);
    }

    public TemplateParser parseEnv(CharSequence txt, long dateValue) {
        return this.parse(txt, dateValue, TemplateParser.adaptMap(System.getenv()), true);
    }

    public TemplateParser parseUtf8(CharSequence txt, long dateValue, CharSequenceObjHashMap<CharSequence> props) {
        return this.parse(txt, dateValue, props, false);
    }

    public void setDateValue(long dateValue) {
        this.dateValue.set(dateValue);
    }

    @Override
    public void toSink(@NotNull CharSink<?> sink) {
        int n = this.templateNodes.size();
        for (int i = 0; i < n; ++i) {
            sink.put(this.templateNodes.getQuick(i));
        }
    }

    public String toString() {
        this.resolveSink.clear();
        this.toSink(this.resolveSink);
        return this.resolveSink.toString();
    }

    private void addDateTemplateNode(int start, int end) {
        int actualStart;
        if (end - start < 1) {
            throw new LogError("Missing expression at position " + start);
        }
        int actualEnd = end;
        for (actualStart = start; this.originalTxt.charAt(actualStart) == ' ' && actualStart < actualEnd; ++actualStart) {
        }
        while (this.originalTxt.charAt(actualEnd - 1) == ' ' && actualEnd > actualStart) {
            --actualEnd;
        }
        if (actualEnd - actualStart < 1) {
            throw new LogError("Missing expression at position " + actualStart);
        }
        final DateFormat dateFormat = this.dateCompiler.compile(this.originalTxt, actualStart, actualEnd, false);
        this.templateNodes.add(new TemplateNode(2, DATE_FORMAT_KEY){

            @Override
            public void toSink(@NotNull CharSink<?> sink) {
                dateFormat.format(TemplateParser.this.dateValue.get(), TimestampFormatUtils.EN_LOCALE, null, sink);
            }
        });
    }

    private void addEnvTemplateNode(int dollarOffset, int envStart, int envEnd) {
        String envKey = this.originalTxt.subSequence(envStart, envEnd).toString();
        CharSequence envVal = this.props.get(envKey);
        if (envVal == null) {
            if (Chars.equals(envKey, "log.dir")) {
                envVal = this.props.get("QDB_LOG_LOG_DIR");
                if (envVal == null) {
                    throw CairoException.nonCritical().put("could not find property `log.dir`. Did you pass `QDB_LOG_LOG_DIR` as an environment variable?");
                }
            } else {
                throw new LogError("Undefined property: " + envKey);
            }
        }
        this.envStartIdxs.put(envKey, dollarOffset);
        final CharSequence finalEnvVal = envVal;
        this.templateNodes.add(new TemplateNode(1, envKey){

            @Override
            public void toSink(@NotNull CharSink<?> sink) {
                sink.put(finalEnvVal);
            }
        });
    }

    private void addStaticTemplateNode(final int start, final int end, final boolean needsUtf8Encoding) {
        this.templateNodes.add(new TemplateNode(0, null){

            @Override
            public void toSink(@NotNull CharSink<?> sink) {
                if (needsUtf8Encoding) {
                    sink.put(TemplateParser.this.originalTxt, start, end);
                } else {
                    sink.putAscii(TemplateParser.this.originalTxt, start, end);
                }
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private TemplateParser parse(CharSequence txt, long dateValue, CharSequenceObjHashMap<CharSequence> props, boolean needsUtf8Encoding) {
        this.originalTxt = txt;
        this.dateValue.set(dateValue);
        this.props = props;
        this.templateNodes.clear();
        this.envStartIdxs.clear();
        int dollarStart = -1;
        int keyStart = -1;
        int lastExprEnd = 0;
        int curlyBraces = 0;
        int locationLen = this.originalTxt.length();
        block5: for (int i = 0; i < locationLen; ++i) {
            char c = this.originalTxt.charAt(i);
            switch (c) {
                case '$': {
                    if (dollarStart != -1) {
                        if (i - dollarStart <= 1) throw new LogError("Unexpected '$' at position " + i);
                        this.addEnvTemplateNode(dollarStart, dollarStart + 1, i);
                        lastExprEnd = i + 1;
                    } else if (i - lastExprEnd > 0) {
                        this.addStaticTemplateNode(lastExprEnd, i, needsUtf8Encoding);
                        lastExprEnd = i + 1;
                    }
                    dollarStart = i;
                    continue block5;
                }
                case '{': {
                    ++curlyBraces;
                    if (dollarStart == -1) continue block5;
                    keyStart = i + 1;
                    continue block5;
                }
                case '}': {
                    --curlyBraces;
                    if (dollarStart == -1) continue block5;
                    if (keyStart == -1) {
                        this.addEnvTemplateNode(dollarStart, dollarStart + 1, i);
                        lastExprEnd = i;
                    } else {
                        int exprLen = i - keyStart;
                        if (exprLen == 0) {
                            throw new LogError("Missing expression at position " + keyStart);
                        }
                        int formatStart = keyStart + DATE_FORMAT_KEY.length();
                        if (Chars.startsWith(this.originalTxt, keyStart, formatStart, DATE_FORMAT_KEY)) {
                            this.addDateTemplateNode(formatStart, i);
                        } else {
                            this.addEnvTemplateNode(dollarStart, dollarStart + 2, i);
                        }
                        lastExprEnd = i + 1;
                    }
                    keyStart = -1;
                    dollarStart = -1;
                }
            }
        }
        if (dollarStart == -1) {
            if (curlyBraces != 0) {
                throw new LogError("Mismatched '{}' at position " + lastExprEnd);
            }
            if (locationLen - lastExprEnd <= 0) return this;
            this.addStaticTemplateNode(lastExprEnd, locationLen, needsUtf8Encoding);
            return this;
        } else {
            if (keyStart != -1) {
                throw new LogError("Missing '}' at position " + locationLen);
            }
            if (locationLen - dollarStart <= 1) throw new LogError("Unexpected '$' at position " + dollarStart);
            this.addEnvTemplateNode(dollarStart, dollarStart + 1, locationLen);
        }
        return this;
    }

    public static abstract class TemplateNode
    implements Sinkable {
        private static final int TYPE_DATE = 2;
        private static final int TYPE_ENV = 1;
        private static final int TYPE_STATIC = 0;
        private final CharSequence key;
        private final int type;

        private TemplateNode(int type, CharSequence key) {
            this.type = type;
            this.key = key;
        }

        public boolean isEnv(CharSequence key) {
            return this.type == 1 && Chars.equals(this.key, key);
        }
    }
}

