/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.log;

import io.questdb.log.LogAlertSocket;
import io.questdb.log.LogRecordUtf8Sink;
import io.questdb.std.Unsafe;
import io.questdb.std.str.Sinkable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpLogRecordUtf8Sink
extends LogRecordUtf8Sink {
    public static final String CRLF = "\r\n";
    private static final String CL_MARKER = "#########";
    private static final int CL_MARKER_LEN = "#########".length();
    private static final int MARK_NOT_SET = -1;
    private long bodyStart;
    private long contentLengthEnd = this._wptr;
    private boolean hasContentLengthMarker;
    private long mark = -1L;

    public HttpLogRecordUtf8Sink(LogAlertSocket alertSkt) {
        this(alertSkt.getOutBufferPtr(), alertSkt.getOutBufferSize());
    }

    public HttpLogRecordUtf8Sink(long address, long addressSize) {
        super(address, addressSize);
        this.bodyStart = this._wptr;
    }

    public int $() {
        if (this.hasContentLengthMarker) {
            int bodyLen = (int)(this._wptr - this.bodyStart);
            long p = this.contentLengthEnd;
            if (bodyLen == 0) {
                Unsafe.getUnsafe().putByte(p--, (byte)48);
            } else {
                int rem = bodyLen % 10;
                while (bodyLen > 0) {
                    Unsafe.getUnsafe().putByte(p--, (byte)(48 + rem));
                    rem = (bodyLen /= 10) % 10;
                }
            }
            int lpadLen = (int)((long)CL_MARKER_LEN - this.contentLengthEnd + p);
            for (int lpad = 0; lpad < lpadLen; ++lpad) {
                Unsafe.getUnsafe().putByte(p--, (byte)32);
            }
        }
        return this.size();
    }

    @Override
    public void clear() {
        super.clear();
        this.mark = -1L;
        this.contentLengthEnd = this._wptr;
        this.bodyStart = this._wptr;
        this.hasContentLengthMarker = false;
    }

    public long getMark() {
        return this.mark;
    }

    public HttpLogRecordUtf8Sink put(LogRecordUtf8Sink logRecord) {
        long address;
        int len = logRecord.size();
        long limit = address + (long)len;
        block6: for (long p = address = logRecord.ptr(); p < limit; ++p) {
            byte b = Unsafe.getUnsafe().getByte(p);
            switch (b) {
                case 8: 
                case 10: 
                case 12: 
                case 13: {
                    continue block6;
                }
                case 9: {
                    this.put(' ');
                    continue block6;
                }
                case 36: {
                    this.put("\\$");
                    continue block6;
                }
                case 34: {
                    this.put("\\\"");
                    continue block6;
                }
                default: {
                    this.put(b);
                }
            }
        }
        return this;
    }

    @Override
    public HttpLogRecordUtf8Sink put(@Nullable CharSequence cs) {
        super.put(cs);
        return this;
    }

    @Override
    public HttpLogRecordUtf8Sink put(@NotNull CharSequence cs, int lo, int hi) {
        super.put(cs, lo, hi);
        return this;
    }

    @Override
    public HttpLogRecordUtf8Sink put(@Nullable Sinkable sinkable) {
        super.put(sinkable);
        return this;
    }

    @Override
    public HttpLogRecordUtf8Sink put(char c) {
        super.put(c);
        return this;
    }

    @Override
    public HttpLogRecordUtf8Sink putAscii(@Nullable CharSequence cs) {
        super.putAscii(cs);
        return this;
    }

    @Override
    public HttpLogRecordUtf8Sink putAscii(char c) {
        super.putAscii(c);
        return this;
    }

    public void putContentLengthMarker() {
        this.putAscii("Content-Length:").putAscii(CL_MARKER);
        this.contentLengthEnd = this._wptr - 1L;
        this.putAscii(CRLF);
        this.hasContentLengthMarker = true;
    }

    public HttpLogRecordUtf8Sink putHeader(CharSequence localHostIp) {
        this.clear();
        this.putAscii("POST /api/v1/alerts HTTP/1.1").putAscii(CRLF).putAscii("Host: ").put(localHostIp).putAscii(CRLF).putAscii("User-Agent: QuestDB/LogAlert").putAscii(CRLF).putAscii("Accept: */*").putAscii(CRLF).putAscii("Content-Type: application/json").putAscii(CRLF).putContentLengthMarker();
        this.put(CRLF);
        this.bodyStart = this._wptr;
        return this;
    }

    public HttpLogRecordUtf8Sink rewindToMark() {
        this._wptr = this.mark == -1L ? this.address : this.mark;
        return this;
    }

    public HttpLogRecordUtf8Sink setMark() {
        this.mark = this._wptr;
        return this;
    }
}

