/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.jit;

import io.questdb.cairo.ColumnType;
import io.questdb.cairo.sql.BindVariableService;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.PageFrameCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.StaticSymbolTable;
import io.questdb.cairo.vm.api.MemoryCARW;
import io.questdb.griffin.GeoHashUtil;
import io.questdb.griffin.PostOrderTreeTraversalAlgo;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.SqlKeywords;
import io.questdb.griffin.engine.functions.bind.CompiledFilterSymbolBindVariable;
import io.questdb.griffin.engine.functions.bind.IndexedParameterLinkFunction;
import io.questdb.griffin.engine.functions.bind.NamedParameterLinkFunction;
import io.questdb.griffin.engine.functions.constants.ConstantFunction;
import io.questdb.griffin.engine.functions.constants.SymbolConstant;
import io.questdb.griffin.model.ExpressionNode;
import io.questdb.griffin.model.IntervalUtils;
import io.questdb.std.Chars;
import io.questdb.std.GenericLexer;
import io.questdb.std.LongList;
import io.questdb.std.LongObjHashMap;
import io.questdb.std.Mutable;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;
import io.questdb.std.Uuid;
import io.questdb.std.str.StringSink;
import java.util.ArrayDeque;
import java.util.Arrays;

public class CompiledFilterIRSerializer
implements PostOrderTreeTraversalAlgo.Visitor,
Mutable {
    public static final int ADD = 14;
    public static final int AND = 6;
    public static final int BINARY_HEADER_TYPE = 8;
    public static final int DIV = 17;
    public static final int EQ = 8;
    public static final int F4_TYPE = 3;
    public static final int F8_TYPE = 5;
    public static final int GE = 13;
    public static final int GT = 12;
    public static final int I16_TYPE = 6;
    public static final int I1_TYPE = 0;
    public static final int I2_TYPE = 1;
    public static final int I4_TYPE = 2;
    public static final int I8_TYPE = 4;
    public static final int IMM = 1;
    public static final int LE = 11;
    public static final int LT = 10;
    public static final int MEM = 2;
    public static final int MUL = 16;
    public static final int NE = 9;
    public static final int NEG = 4;
    public static final int NOT = 5;
    public static final int OR = 7;
    public static final int RET = 0;
    public static final int STRING_HEADER_TYPE = 7;
    public static final int SUB = 15;
    public static final int VAR = 3;
    public static final int VARCHAR_HEADER_TYPE = 9;
    static final int UNDEFINED_CODE = -1;
    private static final int INSTRUCTION_SIZE = 24;
    private final LongObjHashMap<ExpressionNode> backfillNodes = new LongObjHashMap();
    private final PostOrderTreeTraversalAlgo inPredicateTraverseAlgo = new PostOrderTreeTraversalAlgo();
    private final PredicateContext predicateContext = new PredicateContext();
    private final StringSink sink = new StringSink();
    private ObjList<Function> bindVarFunctions;
    private final LongObjHashMap.LongObjConsumer<ExpressionNode> backfillNodeConsumer = this::backfillNode;
    private SqlExecutionContext executionContext;
    private boolean forceScalarMode;
    private MemoryCARW memory;
    private RecordMetadata metadata;
    private PageFrameCursor pageFrameCursor;

    @Override
    public void clear() {
        this.memory = null;
        this.metadata = null;
        this.pageFrameCursor = null;
        this.forceScalarMode = false;
        this.predicateContext.clear();
        this.backfillNodes.clear();
    }

    @Override
    public boolean descend(ExpressionNode node) throws SqlException {
        if (node.token == null) {
            throw SqlException.position(node.position).put("non-null token expected: ").put(node.token);
        }
        if (this.predicateContext.inOperationNode != null && !this.predicateContext.currentInSerialization) {
            return false;
        }
        this.predicateContext.onNodeDescended(node);
        if (node.type == 9 && node.paramCount == 1 && Chars.equals(node.token, (CharSequence)"-")) {
            ExpressionNode nextNode;
            ExpressionNode expressionNode = nextNode = node.lhs != null ? node.lhs : node.rhs;
            if (nextNode != null && nextNode.paramCount == 0 && nextNode.type == 4) {
                this.serializeConstantStub(node);
                return false;
            }
        }
        return true;
    }

    public CompiledFilterIRSerializer of(MemoryCARW memory, SqlExecutionContext executionContext, RecordMetadata metadata, PageFrameCursor pageFrameCursor, ObjList<Function> bindVarFunctions) {
        this.memory = memory;
        this.executionContext = executionContext;
        this.metadata = metadata;
        this.pageFrameCursor = pageFrameCursor;
        this.bindVarFunctions = bindVarFunctions;
        return this;
    }

    public int serialize(ExpressionNode node, boolean scalar, boolean debug, boolean nullChecks) throws SqlException {
        this.inPredicateTraverseAlgo.traverse(node, this);
        this.putOperator(0);
        this.ensureOnlyVarSizeHeaderChecks();
        TypesObserver typesObserver = this.predicateContext.globalTypesObserver;
        int options = debug ? 1 : 0;
        int typeSize = typesObserver.maxSize();
        if (typeSize > 0) {
            int log2 = Integer.numberOfTrailingZeros(typeSize);
            options |= log2 << 1;
        }
        if (!scalar && !this.forceScalarMode) {
            int executionHint = typesObserver.hasMixedSizes() ? 2 : 1;
            options |= executionHint << 4;
        }
        return options |= (nullChecks ? 1 : 0) << 6;
    }

    @Override
    public void visit(ExpressionNode node) throws SqlException {
        block9: {
            int argCount;
            block8: {
                argCount = node.paramCount;
                if (argCount != 0) break block8;
                switch (node.type) {
                    case 7: {
                        this.serializeColumn(node.position, node.token);
                        break block9;
                    }
                    case 3: {
                        this.serializeBindVariable(node);
                        break block9;
                    }
                    case 4: {
                        this.serializeConstantStub(node);
                        break block9;
                    }
                    default: {
                        throw SqlException.position(node.position).put("unsupported token: ").put(node.token);
                    }
                }
            }
            this.serializeOperator(node.position, node.token, argCount, node.type);
        }
        boolean predicateLeft = this.predicateContext.onNodeVisited(node);
        if (predicateLeft) {
            this.forceScalarMode |= this.predicateContext.hasArithmeticOperations && this.predicateContext.localTypesObserver.maxSize() <= 2;
            try {
                this.backfillNodes.forEach(this.backfillNodeConsumer);
                this.backfillNodes.clear();
            }
            catch (SqlWrapperException e) {
                throw e.wrappedException;
            }
        }
    }

    private static byte bindVariableTypeCode(int columnTypeTag) {
        switch (columnTypeTag) {
            case 1: 
            case 2: 
            case 14: {
                return 0;
            }
            case 3: 
            case 4: 
            case 15: {
                return 1;
            }
            case 5: 
            case 11: 
            case 16: 
            case 25: {
                return 2;
            }
            case 9: {
                return 3;
            }
            case 6: 
            case 7: 
            case 8: 
            case 17: {
                return 4;
            }
            case 10: {
                return 5;
            }
            case 19: 
            case 24: {
                return 6;
            }
        }
        return -1;
    }

    private static int columnTypeCode(int columnTypeTag) {
        switch (columnTypeTag) {
            case 1: 
            case 2: 
            case 14: {
                return 0;
            }
            case 3: 
            case 4: 
            case 15: {
                return 1;
            }
            case 5: 
            case 12: 
            case 16: 
            case 25: {
                return 2;
            }
            case 9: {
                return 3;
            }
            case 6: 
            case 7: 
            case 8: 
            case 17: {
                return 4;
            }
            case 10: {
                return 5;
            }
            case 19: 
            case 24: {
                return 6;
            }
            case 11: {
                return 7;
            }
            case 18: {
                return 8;
            }
            case 26: {
                return 9;
            }
        }
        return -1;
    }

    private static boolean isArithmeticOperation(ExpressionNode node) {
        CharSequence token = node.token;
        if (node.paramCount < 2) {
            return false;
        }
        if (Chars.equals(token, (CharSequence)"+")) {
            return true;
        }
        if (Chars.equals(token, (CharSequence)"-")) {
            return true;
        }
        if (Chars.equals(token, (CharSequence)"*")) {
            return true;
        }
        return Chars.equals(token, (CharSequence)"/");
    }

    private static boolean isNumeric(int columnTypeTag) {
        switch (columnTypeTag) {
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 24: {
                return true;
            }
        }
        return false;
    }

    private static boolean isTopLevelOperation(ExpressionNode node) {
        CharSequence token = node.token;
        if (SqlKeywords.isNotKeyword(token)) {
            return true;
        }
        if (node.paramCount < 2) {
            return false;
        }
        if (SqlKeywords.isInKeyword(token)) {
            return true;
        }
        if (Chars.equals(token, (CharSequence)"=")) {
            return true;
        }
        if (Chars.equals(token, (CharSequence)"<>") || Chars.equals(token, (CharSequence)"!=")) {
            return true;
        }
        if (Chars.equals(token, (CharSequence)"<")) {
            return true;
        }
        if (Chars.equals(token, (CharSequence)"<=")) {
            return true;
        }
        if (Chars.equals(token, (CharSequence)">")) {
            return true;
        }
        return Chars.equals(token, (CharSequence)">=");
    }

    private static boolean isVarSizeType(int type) {
        return type == 7 || type == 8 || type == 9;
    }

    private void backfillConstant(long offset, ExpressionNode node) throws SqlException {
        int position = node.position;
        CharSequence token = node.token;
        boolean negate = false;
        if (node.type == 9) {
            ExpressionNode nextNode;
            ExpressionNode expressionNode = nextNode = node.lhs != null ? node.lhs : node.rhs;
            if (nextNode != null) {
                position = nextNode.position;
                token = nextNode.token;
                negate = true;
            }
        }
        this.serializeConstant(offset, position, token, negate);
    }

    private void backfillNode(long key, ExpressionNode value) {
        try {
            switch (value.type) {
                case 4: 
                case 9: {
                    this.backfillConstant(key, value);
                    break;
                }
                case 3: {
                    this.backfillSymbolBindVariable(key, value);
                    break;
                }
                default: {
                    throw SqlException.position(value.position).put("unexpected backfill token: ").put(value.token);
                }
            }
        }
        catch (SqlException e) {
            throw new SqlWrapperException(e);
        }
    }

    private void backfillSymbolBindVariable(long offset, ExpressionNode node) throws SqlException {
        if (this.predicateContext.symbolColumnIndex == -1) {
            throw SqlException.position(node.position).put("symbol column index is missing for bind variable: ").put(node.token);
        }
        Function varFunction = this.getBindVariableFunction(node.position, node.token);
        int columnType = varFunction.getType();
        if (columnType != 11) {
            throw SqlException.position(node.position).put("unexpected symbol bind variable type: ").put(ColumnType.nameOf(columnType));
        }
        byte typeCode = CompiledFilterIRSerializer.bindVariableTypeCode(columnType);
        if (typeCode == -1) {
            throw SqlException.position(node.position).put("unsupported bind variable type: ").put(ColumnType.nameOf(columnType));
        }
        this.bindVarFunctions.add(new CompiledFilterSymbolBindVariable(varFunction, this.predicateContext.symbolColumnIndex));
        int index = this.bindVarFunctions.size() - 1;
        this.putOperand(offset, 3, typeCode, index);
    }

    private void ensureOnlyVarSizeHeaderChecks() throws SqlException {
        ArrayDeque<Integer> typeStack = new ArrayDeque<Integer>();
        block6: for (long offset = 0L; offset < this.memory.size(); offset += 24L) {
            int opCode = this.memory.getInt(offset);
            int typeCode = this.memory.getInt(offset + 4L);
            switch (opCode) {
                case -1: {
                    throw SqlException.$(0, "invalid opcode");
                }
                case 0: {
                    return;
                }
                case 1: 
                case 2: 
                case 3: {
                    typeStack.push(typeCode);
                    continue block6;
                }
                case 4: 
                case 5: {
                    typeStack.pop();
                    typeStack.push(typeCode);
                    continue block6;
                }
                default: {
                    int lhsType = (Integer)typeStack.pop();
                    int rhsType = (Integer)typeStack.pop();
                    if (lhsType != rhsType && CompiledFilterIRSerializer.isVarSizeType(lhsType) && CompiledFilterIRSerializer.isVarSizeType(rhsType) || lhsType == rhsType && CompiledFilterIRSerializer.isVarSizeType(lhsType)) {
                        throw SqlException.$(0, "var-size columns can only be used in NULL checks");
                    }
                    typeStack.push(typeCode);
                }
            }
        }
    }

    private Function getBindVariableFunction(int position, CharSequence token) throws SqlException {
        Function varFunction;
        if (token.charAt(0) == ':') {
            Function bindFunction = this.getBindVariableService().getFunction(token);
            if (bindFunction == null) {
                throw SqlException.position(position).put("failed to find function for bind variable: ").put(token);
            }
            varFunction = new NamedParameterLinkFunction(Chars.toString(token), bindFunction.getType());
        } else {
            try {
                int variableIndex = Numbers.parseInt(token, 1, token.length());
                if (variableIndex < 1) {
                    throw SqlException.$(position, "invalid bind variable index [value=").put(variableIndex).put(']');
                }
                Function bindFunction = this.getBindVariableService().getFunction(variableIndex - 1);
                if (bindFunction == null) {
                    throw SqlException.position(position).put("failed to find function for bind variable: ").put(token);
                }
                varFunction = new IndexedParameterLinkFunction(variableIndex - 1, bindFunction.getType(), position);
            }
            catch (NumericException e) {
                throw SqlException.$(position, "invalid bind variable index [value=").put(token).put(']');
            }
        }
        return varFunction;
    }

    private BindVariableService getBindVariableService() throws SqlException {
        BindVariableService bindVariableService = this.executionContext.getBindVariableService();
        if (bindVariableService == null) {
            throw SqlException.$(0, "bind variable service is not provided");
        }
        return bindVariableService;
    }

    private boolean isBooleanColumn(ExpressionNode node) {
        if (node.type != 7) {
            return false;
        }
        int index = this.metadata.getColumnIndexQuiet(node.token);
        if (index == -1) {
            return false;
        }
        int columnType = this.metadata.getColumnType(index);
        short columnTypeTag = ColumnType.tagOf(columnType);
        return columnTypeTag == 1;
    }

    private boolean isInTimestampPredicate() throws SqlException {
        this.predicateContext.onNodeVisited(this.predicateContext.inOperationNode.rhs);
        this.predicateContext.onNodeVisited(this.predicateContext.inOperationNode.lhs);
        return this.predicateContext.type == PredicateType.TIMESTAMP;
    }

    private boolean isTopLevelBooleanColumn(ExpressionNode node) {
        if (node.type == 7 && this.isBooleanColumn(node)) {
            return true;
        }
        CharSequence token = node.token;
        if (SqlKeywords.isNotKeyword(token)) {
            ExpressionNode columnNode = node.lhs != null ? node.lhs : node.rhs;
            return columnNode != null && this.isBooleanColumn(columnNode);
        }
        return false;
    }

    private void putDoubleOperand(long offset, int type, double payload) {
        this.memory.putInt(offset, 1);
        this.memory.putInt(offset + 4L, type);
        this.memory.putDouble(offset + 8L, payload);
        this.memory.putLong(offset + 8L + 8L, 0L);
    }

    private void putOperand(int opcode, int type, long payload) {
        this.memory.putInt(opcode);
        this.memory.putInt(type);
        this.memory.putLong(payload);
        this.memory.putLong(0L);
    }

    private void putOperand(long offset, int opcode, int type, long payload) {
        this.putOperand(offset, opcode, type, payload, 0L);
    }

    private void putOperand(long offset, int opcode, int type, long lo, long hi) {
        this.memory.putInt(offset, opcode);
        this.memory.putInt(offset + 4L, type);
        this.memory.putLong(offset + 8L, lo);
        this.memory.putLong(offset + 8L + 8L, hi);
    }

    private void putOperator(int opcode) {
        this.memory.putInt(opcode);
        this.memory.putInt(0);
        this.memory.putLong(0L);
        this.memory.putLong(0L);
    }

    private void rejectSymbol(CharSequence token, int position) throws SqlException {
        PredicateType typeCode = this.predicateContext.type;
        if (typeCode == PredicateType.SYMBOL) {
            throw SqlException.position(position).put("operator: ").put(token).put(" is not supported for SYMBOL type");
        }
    }

    private void serializeBindVariable(ExpressionNode node) throws SqlException {
        byte typeCode;
        Function varFunction;
        if (this.predicateContext.isActive()) {
            varFunction = this.getBindVariableFunction(node.position, node.token);
            int columnType = varFunction.getType();
            if (columnType == 11) {
                long offset = this.memory.getAppendOffset();
                this.backfillNodes.put(offset, node);
                this.putOperand(-1, -1, 0L);
                return;
            }
            short columnTypeTag = ColumnType.tagOf(columnType);
            typeCode = CompiledFilterIRSerializer.bindVariableTypeCode(columnTypeTag);
            if (typeCode == -1) {
                throw SqlException.position(node.position).put("unsupported bind variable type: ").put(ColumnType.nameOf(columnTypeTag));
            }
        } else {
            throw SqlException.position(node.position).put("bind variable outside of predicate: ").put(node.token);
        }
        this.bindVarFunctions.add(varFunction);
        int index = this.bindVarFunctions.size() - 1;
        this.putOperand(3, typeCode, index);
    }

    private void serializeColumn(int position, CharSequence token) throws SqlException {
        int typeCode;
        int index;
        if (this.predicateContext.isActive()) {
            index = this.metadata.getColumnIndexQuiet(token);
            if (index == -1) {
                throw SqlException.invalidColumn(position, token);
            }
            int columnType = this.metadata.getColumnType(index);
            short columnTypeTag = ColumnType.tagOf(columnType);
            typeCode = CompiledFilterIRSerializer.columnTypeCode(columnTypeTag);
            if (typeCode == -1) {
                throw SqlException.position(position).put("unsupported column type: ").put(ColumnType.nameOf(columnTypeTag));
            }
            if (this.predicateContext.singleBooleanColumn && columnTypeTag == 1) {
                this.putOperand(1, 0, 1L);
                this.putOperand(2, typeCode, index);
                this.putOperator(8);
                return;
            }
        } else {
            throw SqlException.position(position).put("non-boolean column outside of predicate: ").put(token);
        }
        this.putOperand(2, typeCode, index);
    }

    private void serializeConstant(long offset, int position, CharSequence token, boolean negated) throws SqlException {
        int len = token.length();
        int typeCode = this.predicateContext.localTypesObserver.constantTypeCode();
        if (typeCode == -1) {
            throw SqlException.position(position).put("all constants expression: ").put(token);
        }
        if (SqlKeywords.isNullKeyword(token)) {
            this.serializeNull(offset, position, typeCode, this.predicateContext.type);
            return;
        }
        if (this.predicateContext.type == PredicateType.SYMBOL) {
            this.serializeSymbolConstant(offset, position, token);
            return;
        }
        if (Chars.isQuoted(token)) {
            if (this.predicateContext.type == PredicateType.TIMESTAMP) {
                try {
                    long ts = IntervalUtils.parseFloorPartialTimestamp(token, 1, len - 1);
                    this.putOperand(offset, 1, 4, ts);
                }
                catch (NumericException e) {
                    throw SqlException.invalidDate(token, position);
                }
                return;
            }
            if (this.predicateContext.type == PredicateType.DATE) {
                try {
                    long date = IntervalUtils.parseFloorPartialTimestamp(token, 1, len - 1) / 1000L;
                    this.putOperand(offset, 1, 4, date);
                }
                catch (NumericException e) {
                    throw SqlException.invalidDate(token, position);
                }
                return;
            }
            if (len == 3) {
                if (this.predicateContext.type != PredicateType.CHAR) {
                    throw SqlException.position(position).put("char constant in non-char expression: ").put(token);
                }
                this.putOperand(offset, 1, 1, token.charAt(1));
                return;
            }
            if (len == 38) {
                if (this.predicateContext.type != PredicateType.UUID) {
                    throw SqlException.position(position).put("uuid constant in non-uuid expression: ").put(token);
                }
                try {
                    Uuid.checkDashesAndLength(token, 1, token.length() - 1);
                    this.putOperand(offset, 1, 6, Uuid.parseLo(token, 1), Uuid.parseHi(token, 1));
                }
                catch (NumericException e) {
                    throw SqlException.position(position).put("invalid uuid constant: ").put(token);
                }
                return;
            }
            throw SqlException.position(position).put("unsupported string constant: ").put(token);
        }
        if (SqlKeywords.isTrueKeyword(token)) {
            if (this.predicateContext.type != PredicateType.BOOLEAN) {
                throw SqlException.position(position).put("boolean constant in non-boolean expression: ").put(token);
            }
            this.putOperand(offset, 1, 0, 1L);
            return;
        }
        if (SqlKeywords.isFalseKeyword(token)) {
            if (this.predicateContext.type != PredicateType.BOOLEAN) {
                throw SqlException.position(position).put("boolean constant in non-boolean expression: ").put(token);
            }
            this.putOperand(offset, 1, 0, 0L);
            return;
        }
        if (len > 1 && token.charAt(0) == '#') {
            if (this.predicateContext.type != PredicateType.GEO_HASH) {
                throw SqlException.position(position).put("geo hash constant in non-geo hash expression: ").put(token);
            }
            ConstantFunction geoConstant = GeoHashUtil.parseGeoHashConstant(position, token, len);
            if (geoConstant != null) {
                this.serializeGeoHash(offset, position, geoConstant, typeCode);
                return;
            }
        }
        if (this.predicateContext.type != PredicateType.NUMERIC && this.predicateContext.type != PredicateType.TIMESTAMP) {
            throw SqlException.position(position).put("numeric constant in non-numeric expression: ").put(token);
        }
        if (this.predicateContext.localTypesObserver.hasMixedSizes()) {
            this.serializeUntypedNumber(offset, position, token, negated);
        } else {
            this.serializeNumber(offset, position, token, typeCode, negated);
        }
    }

    private void serializeConstantStub(ExpressionNode node) throws SqlException {
        if (!this.predicateContext.isActive()) {
            throw SqlException.position(node.position).put("constant outside of predicate: ").put(node.token);
        }
        long offset = this.memory.getAppendOffset();
        this.backfillNodes.put(offset, node);
        this.putOperand(-1, -1, 0L);
    }

    private void serializeGeoHash(long offset, int position, ConstantFunction geoHashConstant, int typeCode) throws SqlException {
        try {
            switch (typeCode) {
                case 0: {
                    this.putOperand(offset, 1, typeCode, geoHashConstant.getGeoByte(null));
                    break;
                }
                case 1: {
                    this.putOperand(offset, 1, typeCode, geoHashConstant.getGeoShort(null));
                    break;
                }
                case 2: {
                    this.putOperand(offset, 1, typeCode, geoHashConstant.getGeoInt(null));
                    break;
                }
                case 4: {
                    this.putOperand(offset, 1, typeCode, geoHashConstant.getGeoLong(null));
                    break;
                }
                default: {
                    throw SqlException.position(position).put("unexpected type code for geo hash: ").put(typeCode);
                }
            }
        }
        catch (UnsupportedOperationException e) {
            throw SqlException.position(position).put("unexpected type for geo hash: ").put(typeCode);
        }
    }

    private void serializeIn() throws SqlException {
        int i;
        this.predicateContext.currentInSerialization = true;
        ObjList<ExpressionNode> args = this.predicateContext.inOperationNode.args;
        if (args.size() < 3) {
            this.inPredicateTraverseAlgo.traverse(this.predicateContext.inOperationNode.rhs, this);
            this.inPredicateTraverseAlgo.traverse(this.predicateContext.inOperationNode.lhs, this);
            this.putOperator(8);
        }
        int orCount = -1;
        for (i = 0; i < this.predicateContext.inOperationNode.args.size() - 1; ++i) {
            this.inPredicateTraverseAlgo.traverse(args.get(i), this);
            this.inPredicateTraverseAlgo.traverse(args.getLast(), this);
            this.putOperator(8);
            ++orCount;
        }
        for (i = 0; i < orCount; ++i) {
            this.putOperator(7);
        }
    }

    private void serializeInTimestampRange(int position) throws SqlException {
        int i;
        this.predicateContext.currentInSerialization = true;
        CharSequence token = this.predicateContext.inOperationNode.rhs.token;
        CharSequence intervalEx = token == null || SqlKeywords.isNullKeyword(token) ? null : GenericLexer.unquote(token);
        LongList intervals = this.predicateContext.inIntervals;
        IntervalUtils.parseAndApplyIntervalEx(intervalEx, intervals, position);
        ExpressionNode lhs = this.predicateContext.inOperationNode.lhs;
        int orCount = -1;
        int n = intervals.size();
        for (i = 0; i < n; i += 2) {
            long lo = IntervalUtils.getEncodedPeriodLo(intervals, i);
            long hi = IntervalUtils.getEncodedPeriodHi(intervals, i);
            this.putOperand(1, 4, lo);
            this.inPredicateTraverseAlgo.traverse(lhs, this);
            this.putOperator(13);
            this.putOperand(1, 4, hi);
            this.inPredicateTraverseAlgo.traverse(lhs, this);
            this.putOperator(11);
            this.putOperator(6);
            ++orCount;
        }
        for (i = 0; i < orCount; ++i) {
            this.putOperator(7);
        }
    }

    private void serializeNull(long offset, int position, int typeCode, PredicateType predicateType) throws SqlException {
        block0 : switch (typeCode) {
            case 0: {
                if (predicateType != PredicateType.GEO_HASH) {
                    throw SqlException.position(position).put("byte type is not nullable");
                }
                this.putOperand(offset, 1, typeCode, -1L);
                break;
            }
            case 1: {
                if (predicateType != PredicateType.GEO_HASH) {
                    throw SqlException.position(position).put("short type is not nullable");
                }
                this.putOperand(offset, 1, typeCode, -1L);
                break;
            }
            case 2: {
                switch (predicateType) {
                    case GEO_HASH: {
                        this.putOperand(offset, 1, typeCode, -1L);
                        break block0;
                    }
                    case IPv4: {
                        this.putOperand(offset, 1, typeCode, 0L);
                        break block0;
                    }
                }
                this.putOperand(offset, 1, typeCode, Integer.MIN_VALUE);
                break;
            }
            case 4: {
                this.putOperand(offset, 1, typeCode, predicateType == PredicateType.GEO_HASH ? -1L : Long.MIN_VALUE);
                break;
            }
            case 3: {
                this.putDoubleOperand(offset, typeCode, Double.NaN);
                break;
            }
            case 5: {
                this.putDoubleOperand(offset, typeCode, Double.NaN);
                break;
            }
            case 6: {
                this.putOperand(offset, 1, typeCode, Long.MIN_VALUE, Long.MIN_VALUE);
                break;
            }
            case 7: {
                this.putOperand(offset, 1, 2, -1L);
                break;
            }
            case 8: {
                this.putOperand(offset, 1, 4, -1L);
                break;
            }
            case 9: {
                this.putOperand(offset, 1, 4, 4L);
                break;
            }
            default: {
                throw SqlException.position(position).put("unexpected null type: ").put(typeCode);
            }
        }
    }

    private void serializeNumber(long offset, int position, CharSequence token, int typeCode, boolean negated) throws SqlException {
        long sign = negated ? -1L : 1L;
        try {
            switch (typeCode) {
                case 0: {
                    byte b = (byte)Numbers.parseInt(token);
                    this.putOperand(offset, 1, 0, sign * (long)b);
                    break;
                }
                case 1: {
                    short s = (short)Numbers.parseInt(token);
                    this.putOperand(offset, 1, 1, sign * (long)s);
                    break;
                }
                case 2: 
                case 3: {
                    try {
                        int i = Numbers.parseInt(token);
                        this.putOperand(offset, 1, 2, sign * (long)i);
                    }
                    catch (NumericException e) {
                        float fi = Numbers.parseFloat(token);
                        this.putDoubleOperand(offset, 3, (float)sign * fi);
                    }
                    break;
                }
                case 4: 
                case 5: {
                    try {
                        long l = Numbers.parseLong(token);
                        this.putOperand(offset, 1, 4, sign * l);
                    }
                    catch (NumericException e) {
                        double dl = Numbers.parseDouble(token);
                        this.putDoubleOperand(offset, 5, (double)sign * dl);
                    }
                    break;
                }
                default: {
                    throw SqlException.position(position).put("unexpected non-numeric constant: ").put(token).put(", expected type: ").put(typeCode);
                }
            }
        }
        catch (NumericException e) {
            throw SqlException.position(position).put("could not parse constant: ").put(token).put(", expected type: ").put(typeCode);
        }
    }

    private void serializeOperator(int position, CharSequence token, int argCount, int type) throws SqlException {
        if (SqlKeywords.isInKeyword(token)) {
            if (type == 6) {
                this.serializeIn();
                return;
            }
            if (type == 11 && this.isInTimestampPredicate()) {
                this.serializeInTimestampRange(position);
                return;
            }
        }
        if (SqlKeywords.isNotKeyword(token)) {
            this.putOperator(5);
            return;
        }
        if (SqlKeywords.isAndKeyword(token)) {
            this.putOperator(6);
            return;
        }
        if (SqlKeywords.isOrKeyword(token)) {
            this.putOperator(7);
            return;
        }
        if (Chars.equals(token, (CharSequence)"=")) {
            this.putOperator(8);
            return;
        }
        if (Chars.equals(token, (CharSequence)"<>") || Chars.equals(token, (CharSequence)"!=")) {
            this.putOperator(9);
            return;
        }
        if (Chars.equals(token, (CharSequence)"<")) {
            this.rejectSymbol(token, position);
            this.putOperator(10);
            return;
        }
        if (Chars.equals(token, (CharSequence)"<=")) {
            this.rejectSymbol(token, position);
            this.putOperator(11);
            return;
        }
        if (Chars.equals(token, (CharSequence)">")) {
            this.rejectSymbol(token, position);
            this.putOperator(12);
            return;
        }
        if (Chars.equals(token, (CharSequence)">=")) {
            this.rejectSymbol(token, position);
            this.putOperator(13);
            return;
        }
        if (Chars.equals(token, (CharSequence)"+")) {
            if (argCount == 2) {
                this.putOperator(14);
            }
            return;
        }
        if (Chars.equals(token, (CharSequence)"-")) {
            if (argCount == 2) {
                this.putOperator(15);
            } else if (argCount == 1) {
                this.putOperator(4);
            }
            return;
        }
        if (Chars.equals(token, (CharSequence)"*")) {
            this.putOperator(16);
            return;
        }
        if (Chars.equals(token, (CharSequence)"/")) {
            this.putOperator(17);
            return;
        }
        throw SqlException.position(position).put("invalid operator: ").put(token);
    }

    private void serializeSymbolConstant(long offset, int position, CharSequence token) throws SqlException {
        int len = token.length();
        CharSequence symbol = token;
        if (Chars.isQuoted(token)) {
            if (len < 3) {
                throw SqlException.position(position).put("unsupported symbol constant: ").put(token);
            }
            this.sink.clear();
            Chars.unescape(symbol, 1, len - 1, '\'', this.sink);
            symbol = this.sink;
        }
        if (this.predicateContext.symbolTable == null || this.predicateContext.symbolColumnIndex == -1) {
            throw SqlException.position(position).put("reader or column index is missing for symbol constant: ").put(token);
        }
        int key = this.predicateContext.symbolTable.keyOf(symbol);
        if (key != -2) {
            this.putOperand(offset, 1, 2, key);
            return;
        }
        SymbolConstant function = SymbolConstant.newInstance(symbol);
        this.bindVarFunctions.add(new CompiledFilterSymbolBindVariable(function, this.predicateContext.symbolColumnIndex));
        int index = this.bindVarFunctions.size() - 1;
        byte typeCode = CompiledFilterIRSerializer.bindVariableTypeCode(11);
        this.putOperand(offset, 3, typeCode, index);
    }

    private void serializeUntypedNumber(long offset, int position, CharSequence token, boolean negated) throws SqlException {
        long sign = negated ? -1L : 1L;
        try {
            int i = Numbers.parseInt(token);
            this.putOperand(offset, 1, 2, sign * (long)i);
            return;
        }
        catch (NumericException i) {
            try {
                long l = Numbers.parseLong(token);
                this.putOperand(offset, 1, 4, sign * l);
                return;
            }
            catch (NumericException l) {
                try {
                    double d = Numbers.parseDouble(token);
                    this.putDoubleOperand(offset, 5, (double)sign * d);
                    return;
                }
                catch (NumericException d) {
                    try {
                        float f = Numbers.parseFloat(token);
                        this.putDoubleOperand(offset, 3, (float)sign * f);
                        return;
                    }
                    catch (NumericException numericException) {
                        throw SqlException.position(position).put("unexpected non-numeric constant: ").put(token);
                    }
                }
            }
        }
    }

    private class PredicateContext
    implements Mutable {
        final TypesObserver globalTypesObserver = new TypesObserver();
        final TypesObserver localTypesObserver = new TypesObserver();
        private final LongList inIntervals = new LongList();
        boolean hasArithmeticOperations;
        boolean singleBooleanColumn;
        int symbolColumnIndex;
        StaticSymbolTable symbolTable;
        PredicateType type;
        private boolean currentInSerialization = false;
        private ExpressionNode inOperationNode = null;
        private ExpressionNode rootNode;

        private PredicateContext() {
        }

        @Override
        public void clear() {
            this.reset();
            this.globalTypesObserver.clear();
        }

        public boolean isActive() {
            return this.rootNode != null;
        }

        public void onNodeDescended(ExpressionNode node) {
            if (this.rootNode == null) {
                boolean topLevelOperation = CompiledFilterIRSerializer.isTopLevelOperation(node);
                boolean topLevelBooleanColumn = CompiledFilterIRSerializer.this.isTopLevelBooleanColumn(node);
                if (topLevelOperation || topLevelBooleanColumn) {
                    this.reset();
                    this.rootNode = node;
                }
                if (topLevelBooleanColumn) {
                    this.type = PredicateType.BOOLEAN;
                    this.singleBooleanColumn = true;
                }
            }
            if (SqlKeywords.isInKeyword(node.token)) {
                this.inOperationNode = node;
            }
        }

        public boolean onNodeVisited(ExpressionNode node) throws SqlException {
            boolean predicateLeft = false;
            if (node == this.rootNode) {
                this.rootNode = null;
                predicateLeft = true;
            }
            if (node == this.inOperationNode) {
                this.inOperationNode = null;
                this.currentInSerialization = false;
            }
            switch (node.type) {
                case 7: {
                    this.handleColumn(node);
                    break;
                }
                case 3: {
                    this.handleBindVariable(node);
                    break;
                }
                case 9: {
                    this.handleOperation(node);
                }
            }
            return predicateLeft;
        }

        private void handleBindVariable(ExpressionNode node) throws SqlException {
            Function varFunction = CompiledFilterIRSerializer.this.getBindVariableFunction(node.position, node.token);
            int columnType = varFunction.getType();
            int columnTypeTag = ColumnType.tagOf(columnType);
            if (columnTypeTag == 11) {
                columnTypeTag = 12;
            }
            this.updateType(node.position, columnTypeTag);
            int code = CompiledFilterIRSerializer.columnTypeCode(columnTypeTag);
            this.localTypesObserver.observe(code);
            this.globalTypesObserver.observe(code);
        }

        private void handleColumn(ExpressionNode node) throws SqlException {
            int columnIndex = CompiledFilterIRSerializer.this.metadata.getColumnIndexQuiet(node.token);
            if (columnIndex == -1) {
                throw SqlException.invalidColumn(node.position, node.token);
            }
            int columnType = CompiledFilterIRSerializer.this.metadata.getColumnType(columnIndex);
            short columnTypeTag = ColumnType.tagOf(columnType);
            if (columnTypeTag == 12) {
                this.symbolTable = CompiledFilterIRSerializer.this.pageFrameCursor.getSymbolTable(columnIndex);
                this.symbolColumnIndex = columnIndex;
            }
            this.updateType(node.position, columnTypeTag);
            int typeCode = CompiledFilterIRSerializer.columnTypeCode(columnTypeTag);
            this.localTypesObserver.observe(typeCode);
            this.globalTypesObserver.observe(typeCode);
        }

        private void handleOperation(ExpressionNode node) {
            this.hasArithmeticOperations |= CompiledFilterIRSerializer.isArithmeticOperation(node);
        }

        private void reset() {
            this.rootNode = null;
            this.type = null;
            this.symbolTable = null;
            this.symbolColumnIndex = -1;
            this.singleBooleanColumn = false;
            this.hasArithmeticOperations = false;
            this.localTypesObserver.clear();
            this.currentInSerialization = false;
            this.inOperationNode = null;
            this.inIntervals.clear();
        }

        private void updateType(int position, int columnTypeTag) throws SqlException {
            switch (columnTypeTag) {
                case 1: {
                    if (this.type != null && this.type != PredicateType.BOOLEAN) {
                        throw SqlException.position(position).put("non-boolean column in boolean expression: ").put(ColumnType.nameOf(columnTypeTag));
                    }
                    this.type = PredicateType.BOOLEAN;
                    break;
                }
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    if (this.type != null && this.type != PredicateType.GEO_HASH) {
                        throw SqlException.position(position).put("non-geohash column in geohash expression: ").put(ColumnType.nameOf(columnTypeTag));
                    }
                    this.type = PredicateType.GEO_HASH;
                    break;
                }
                case 25: {
                    if (this.type != null && this.type != PredicateType.IPv4) {
                        throw SqlException.position(position).put("non-ipv4 column in ipv4 expression: ").put(ColumnType.nameOf(columnTypeTag));
                    }
                    this.type = PredicateType.IPv4;
                    break;
                }
                case 4: {
                    if (this.type != null && this.type != PredicateType.CHAR) {
                        throw SqlException.position(position).put("non-char column in char expression: ").put(ColumnType.nameOf(columnTypeTag));
                    }
                    this.type = PredicateType.CHAR;
                    break;
                }
                case 12: {
                    if (this.type != null && this.type != PredicateType.SYMBOL) {
                        throw SqlException.position(position).put("non-symbol column in symbol expression: ").put(ColumnType.nameOf(columnTypeTag));
                    }
                    this.type = PredicateType.SYMBOL;
                    break;
                }
                case 19: {
                    if (this.type != null && this.type != PredicateType.UUID) {
                        throw SqlException.position(position).put("non-uuid column in uuid expression: ").put(ColumnType.nameOf(columnTypeTag));
                    }
                    this.type = PredicateType.UUID;
                    break;
                }
                case 8: {
                    if (this.type != null && this.type != PredicateType.TIMESTAMP) {
                        throw SqlException.position(position).put("non-timestamp column in timestamp expression: ").put(ColumnType.nameOf(columnTypeTag));
                    }
                    this.type = PredicateType.TIMESTAMP;
                    break;
                }
                case 7: {
                    if (this.type != null && this.type != PredicateType.DATE) {
                        throw SqlException.position(position).put("non-date column in date expression: ").put(ColumnType.nameOf(columnTypeTag));
                    }
                    this.type = PredicateType.DATE;
                    break;
                }
                default: {
                    if (this.type != null && this.type != PredicateType.NUMERIC || !CompiledFilterIRSerializer.isNumeric(columnTypeTag) && this.type == PredicateType.NUMERIC) {
                        throw SqlException.position(position).put("non-numeric column in numeric expression: ").put(ColumnType.nameOf(columnTypeTag));
                    }
                    this.type = PredicateType.NUMERIC;
                }
            }
        }
    }

    private static class TypesObserver
    implements Mutable {
        private static final int BINARY_HEADER_INDEX = 8;
        private static final int F4_INDEX = 3;
        private static final int F8_INDEX = 5;
        private static final int I16_INDEX = 6;
        private static final int I1_INDEX = 0;
        private static final int I2_INDEX = 1;
        private static final int I4_INDEX = 2;
        private static final int I8_INDEX = 4;
        private static final int STRING_HEADER_INDEX = 7;
        private static final int VARCHAR_HEADER_INDEX = 9;
        private static final int TYPES_COUNT = 10;
        private final byte[] sizes = new byte[10];

        private TypesObserver() {
        }

        @Override
        public void clear() {
            Arrays.fill(this.sizes, (byte)0);
        }

        public int constantTypeCode() {
            for (int i = this.sizes.length - 1; i > -1; --i) {
                byte size = this.sizes[i];
                if (size <= 0) continue;
                if (i == 4 && this.sizes[3] > 0) {
                    return 5;
                }
                return this.indexToTypeCode(i);
            }
            return -1;
        }

        public boolean hasMixedSizes() {
            byte prevSize = 0;
            for (byte size : this.sizes) {
                byte by = prevSize = prevSize == 0 ? size : prevSize;
                if (prevSize > 0) {
                    if (size <= 0 || size == prevSize) continue;
                    return true;
                }
                prevSize = size;
            }
            return false;
        }

        public int maxSize() {
            for (int i = this.sizes.length - 1; i > -1; --i) {
                byte size = this.sizes[i];
                if (size <= 0) continue;
                return size;
            }
            return 0;
        }

        public void observe(int code) {
            switch (code) {
                case 0: {
                    this.sizes[0] = 1;
                    break;
                }
                case 1: {
                    this.sizes[1] = 2;
                    break;
                }
                case 2: {
                    this.sizes[2] = 4;
                    break;
                }
                case 3: {
                    this.sizes[3] = 4;
                    break;
                }
                case 4: {
                    this.sizes[4] = 8;
                    break;
                }
                case 5: {
                    this.sizes[5] = 8;
                    break;
                }
                case 6: {
                    this.sizes[6] = 16;
                    break;
                }
                case 7: {
                    this.sizes[7] = 8;
                    break;
                }
                case 8: {
                    this.sizes[8] = 8;
                    break;
                }
                case 9: {
                    this.sizes[9] = 8;
                }
            }
        }

        private int indexToTypeCode(int index) {
            switch (index) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return 1;
                }
                case 2: {
                    return 2;
                }
                case 3: {
                    return 3;
                }
                case 4: {
                    return 4;
                }
                case 5: {
                    return 5;
                }
                case 6: {
                    return 6;
                }
                case 7: {
                    return 7;
                }
                case 8: {
                    return 8;
                }
                case 9: {
                    return 9;
                }
            }
            return -1;
        }
    }

    private static class SqlWrapperException
    extends RuntimeException {
        final SqlException wrappedException;

        SqlWrapperException(SqlException wrappedException) {
            this.wrappedException = wrappedException;
        }
    }

    private static enum PredicateType {
        NUMERIC,
        CHAR,
        SYMBOL,
        BOOLEAN,
        GEO_HASH,
        UUID,
        IPv4,
        TIMESTAMP,
        DATE;

    }
}

