/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.model;

import io.questdb.griffin.model.QueryModel;
import io.questdb.std.LowerCaseCharSequenceObjHashMap;
import io.questdb.std.Mutable;
import io.questdb.std.ObjList;
import io.questdb.std.ObjectFactory;
import org.jetbrains.annotations.Nullable;

public class WithClauseModel
implements Mutable {
    public static final ObjectFactory<WithClauseModel> FACTORY = WithClauseModel::new;
    private QueryModel model;
    private LowerCaseCharSequenceObjHashMap<WithClauseModel> originalWithClauses;
    private int originalWithClausesSize;
    private int position;
    private LowerCaseCharSequenceObjHashMap<WithClauseModel> withClauses;
    private boolean withClausesInitialized;

    private WithClauseModel() {
    }

    @Override
    public void clear() {
        this.position = 0;
        this.model = null;
        this.originalWithClauses = null;
        this.originalWithClausesSize = -1;
        this.withClausesInitialized = false;
        this.withClauses = null;
    }

    public int getPosition() {
        return this.position;
    }

    public LowerCaseCharSequenceObjHashMap<WithClauseModel> getWithClauses() {
        if (!this.withClausesInitialized) {
            this.withClauses = this.getSubMap();
            this.withClausesInitialized = true;
        }
        return this.withClauses;
    }

    public void of(int position, LowerCaseCharSequenceObjHashMap<WithClauseModel> withClauses, QueryModel model) {
        this.position = position;
        this.model = model;
        this.originalWithClauses = withClauses;
        this.originalWithClausesSize = withClauses.size();
    }

    public QueryModel popModel() {
        QueryModel m = this.model;
        this.model = null;
        return m;
    }

    @Nullable
    private LowerCaseCharSequenceObjHashMap<WithClauseModel> getSubMap() {
        if (this.originalWithClausesSize == 0) {
            return null;
        }
        LowerCaseCharSequenceObjHashMap<WithClauseModel> subMap = new LowerCaseCharSequenceObjHashMap<WithClauseModel>();
        ObjList keys = this.originalWithClauses.keys();
        for (int i = 0; i < this.originalWithClausesSize; ++i) {
            CharSequence key = (CharSequence)keys.get(i);
            WithClauseModel value = this.originalWithClauses.get(key);
            subMap.put(key, value);
        }
        return subMap;
    }
}

