/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.window;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.RecordArray;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.Reopenable;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.RecordComparator;
import io.questdb.griffin.engine.orderby.LongTreeChain;
import io.questdb.griffin.engine.window.WindowFunction;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CachedWindowRecordCursorFactory
extends AbstractRecordCursorFactory {
    private final ObjList<WindowFunction> allFunctions;
    private final RecordCursorFactory base;
    private final GenericRecordMetadata chainMetadata;
    private final ObjList<RecordComparator> comparators;
    private final CachedWindowRecordCursor cursor;
    private final ObjList<ObjList<WindowFunction>> ordered2PassFunctions;
    private final ObjList<ObjList<WindowFunction>> orderedFunctions;
    private final int orderedGroupCount;
    private final ObjList<IntList> sortKeys;
    private final ObjList<WindowFunction> unordered2PassFunctions;
    @Nullable
    private final ObjList<WindowFunction> unorderedFunctions;
    private boolean closed = false;

    public CachedWindowRecordCursorFactory(CairoConfiguration configuration, RecordCursorFactory base, RecordSink recordSink, GenericRecordMetadata metadata, ColumnTypes chainTypes, ObjList<RecordComparator> comparators, ObjList<ObjList<WindowFunction>> orderedFunctions, @Nullable ObjList<WindowFunction> unorderedFunctions, @NotNull IntList columnIndexes, @NotNull ObjList<IntList> sortKeys, @NotNull GenericRecordMetadata chainMetadata) {
        super(metadata);
        try {
            this.base = base;
            this.orderedGroupCount = comparators.size();
            assert (this.orderedGroupCount == orderedFunctions.size());
            this.orderedFunctions = orderedFunctions;
            this.comparators = comparators;
            RecordArray recordChain = new RecordArray(chainTypes, recordSink, configuration.getSqlWindowStorePageSize(), configuration.getSqlWindowStoreMaxPages());
            this.sortKeys = sortKeys;
            this.chainMetadata = chainMetadata;
            ObjList<LongTreeChain> orderedSources = new ObjList<LongTreeChain>(this.orderedGroupCount);
            try {
                for (int i = 0; i < this.orderedGroupCount; ++i) {
                    orderedSources.add(new LongTreeChain(configuration.getSqlWindowTreeKeyPageSize(), configuration.getSqlWindowTreeKeyMaxPages(), configuration.getSqlWindowRowIdPageSize(), configuration.getSqlWindowRowIdMaxPages()));
                }
            }
            catch (Throwable t) {
                Misc.freeObjList(orderedSources);
                recordChain.close();
                throw t;
            }
            this.cursor = new CachedWindowRecordCursor(columnIndexes, recordChain, orderedSources);
            this.allFunctions = new ObjList();
            ObjList orderedTmp = null;
            int n = orderedFunctions.size();
            for (int i = 0; i < n; ++i) {
                ObjList<WindowFunction> functions = orderedFunctions.getQuick(i);
                this.allFunctions.addAll(functions);
                ObjList<WindowFunction> twoPassFunctions = null;
                int k = functions.size();
                for (int j = 0; j < k; ++j) {
                    WindowFunction function = functions.getQuick(j);
                    if (function.getPassCount() <= 1) continue;
                    if (twoPassFunctions == null) {
                        twoPassFunctions = new ObjList<WindowFunction>();
                    }
                    twoPassFunctions.add(function);
                }
                if (twoPassFunctions == null) continue;
                if (orderedTmp == null) {
                    orderedTmp = new ObjList();
                }
                orderedTmp.extendAndSet(i, twoPassFunctions);
            }
            this.ordered2PassFunctions = orderedTmp;
            ObjList<WindowFunction> unorderedTmp = null;
            if (unorderedFunctions != null) {
                this.allFunctions.addAll(unorderedFunctions);
                int n2 = unorderedFunctions.size();
                for (int i = 0; i < n2; ++i) {
                    WindowFunction function = unorderedFunctions.getQuick(i);
                    if (function.getPassCount() <= 1) continue;
                    if (unorderedTmp == null) {
                        unorderedTmp = new ObjList<WindowFunction>();
                    }
                    unorderedTmp.add(function);
                }
            }
            this.unordered2PassFunctions = unorderedTmp;
            this.unorderedFunctions = unorderedFunctions;
        }
        catch (Throwable th) {
            this.close();
            throw th;
        }
    }

    @Override
    public boolean followedOrderByAdvice() {
        return this.base.followedOrderByAdvice();
    }

    @Override
    public String getBaseColumnName(int idx) {
        return this.chainMetadata.getColumnName(idx);
    }

    @Override
    public RecordCursorFactory getBaseFactory() {
        return this.base;
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        executionContext.setColumnPreTouchEnabled(false);
        RecordCursor baseCursor = this.base.getCursor(executionContext);
        this.cursor.of(baseCursor, executionContext);
        return this.cursor;
    }

    @Override
    public int getScanDirection() {
        return this.base.getScanDirection();
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void toPlan(PlanSink sink) {
        sink.type("CachedWindow");
        boolean oldVal = sink.getUseBaseMetadata();
        try {
            if (this.orderedFunctions.size() > 0) {
                sink.attr("orderedFunctions");
                sink.val("[");
                sink.useBaseMetadata(true);
                int n = this.orderedFunctions.size();
                for (int i = 0; i < n; ++i) {
                    if (i > 0) {
                        sink.val(',');
                    }
                    sink.val('[');
                    this.addSortKeys(sink, this.sortKeys.getQuick(i));
                    sink.val("] => [");
                    ObjList<WindowFunction> functions = this.orderedFunctions.getQuick(i);
                    int k = functions.size();
                    for (int j = 0; j < k; ++j) {
                        if (j > 0) {
                            sink.val(',');
                        }
                        sink.val(functions.getQuick(j));
                    }
                    sink.val("]");
                }
                sink.val(']');
            }
            sink.optAttr((CharSequence)"unorderedFunctions", this.unorderedFunctions, true);
        }
        finally {
            sink.useBaseMetadata(oldVal);
        }
        sink.child(this.base);
    }

    @Override
    public boolean usesCompiledFilter() {
        return this.base.usesCompiledFilter();
    }

    @Override
    public boolean usesIndex() {
        return this.base.usesIndex();
    }

    private void addSortKeys(PlanSink sink, IntList list) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            int colIdx = list.get(i);
            int col = (colIdx > 0 ? colIdx : -colIdx) - 1;
            if (i > 0) {
                sink.val(", ");
            }
            sink.val(this.chainMetadata.getColumnName(col));
            if (colIdx >= 0) continue;
            sink.val(" ").val("desc");
        }
    }

    private void resetFunctions() {
        int n = this.allFunctions.size();
        for (int i = 0; i < n; ++i) {
            this.allFunctions.getQuick(i).reset();
        }
    }

    @Override
    protected void _close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        Misc.free(this.base);
        Misc.free(this.cursor);
        Misc.freeObjList(this.allFunctions);
    }

    class CachedWindowRecordCursor
    implements RecordCursor {
        private final IntList columnIndexes;
        private final ObjList<LongTreeChain> orderedSources;
        private final RecordArray recordChain;
        private RecordCursor baseCursor;
        private SqlExecutionCircuitBreaker circuitBreaker;
        private boolean isOpen;
        private boolean isRecordChainBuilt;
        private long recordChainOffset;

        public CachedWindowRecordCursor(IntList columnIndexes, RecordArray recordChain, ObjList<LongTreeChain> orderedSources) {
            this.columnIndexes = columnIndexes;
            this.recordChain = recordChain;
            this.recordChain.setSymbolTableResolver(this);
            this.isOpen = true;
            this.orderedSources = orderedSources;
        }

        @Override
        public void calculateSize(SqlExecutionCircuitBreaker circuitBreaker, RecordCursor.Counter counter) {
            if (!this.isRecordChainBuilt) {
                this.buildRecordChain();
            }
            this.isRecordChainBuilt = true;
            this.recordChain.calculateSize(circuitBreaker, counter);
        }

        @Override
        public void close() {
            if (this.isOpen) {
                Misc.free(this.baseCursor);
                Misc.free(this.recordChain);
                int n = this.orderedSources.size();
                for (int i = 0; i < n; ++i) {
                    Misc.free(this.orderedSources.getQuick(i));
                }
                CachedWindowRecordCursorFactory.this.resetFunctions();
                this.isOpen = false;
            }
        }

        @Override
        public Record getRecord() {
            return this.recordChain.getRecord();
        }

        @Override
        public Record getRecordB() {
            return this.recordChain.getRecordB();
        }

        @Override
        public SymbolTable getSymbolTable(int columnIndex) {
            return this.baseCursor.getSymbolTable(this.columnIndexes.getQuick(columnIndex));
        }

        @Override
        public boolean hasNext() {
            if (!this.isRecordChainBuilt) {
                this.buildRecordChain();
            }
            this.isRecordChainBuilt = true;
            return this.recordChain.hasNext();
        }

        @Override
        public SymbolTable newSymbolTable(int columnIndex) {
            return this.baseCursor.newSymbolTable(this.columnIndexes.getQuick(columnIndex));
        }

        @Override
        public long preComputedStateSize() {
            return this.recordChain.size();
        }

        @Override
        public void recordAt(Record record, long atRowId) {
            this.recordChain.recordAt(record, atRowId);
        }

        @Override
        public long size() {
            return this.isRecordChainBuilt ? this.recordChain.size() : -1L;
        }

        @Override
        public void toTop() {
            this.recordChain.toTop();
        }

        private void buildRecordChain() {
            WindowFunction f;
            int j;
            ObjList<WindowFunction> functions;
            int i;
            Record record = this.baseCursor.getRecord();
            Record chainRecord = this.recordChain.getRecord();
            Record chainRightRecord = this.recordChain.getRecordB();
            if (CachedWindowRecordCursorFactory.this.orderedGroupCount > 0) {
                while (this.baseCursor.hasNext()) {
                    this.recordChainOffset = this.recordChain.put(record);
                    this.recordChain.recordAt(chainRecord, this.recordChainOffset);
                    for (int i2 = 0; i2 < CachedWindowRecordCursorFactory.this.orderedGroupCount; ++i2) {
                        this.circuitBreaker.statefulThrowExceptionIfTripped();
                        this.orderedSources.getQuick(i2).put(chainRecord, this.recordChain, chainRightRecord, CachedWindowRecordCursorFactory.this.comparators.getQuick(i2));
                    }
                }
            } else {
                while (this.baseCursor.hasNext()) {
                    this.circuitBreaker.statefulThrowExceptionIfTripped();
                    this.recordChainOffset = this.recordChain.put(record);
                }
            }
            if (CachedWindowRecordCursorFactory.this.orderedGroupCount > 0) {
                for (i = 0; i < CachedWindowRecordCursorFactory.this.orderedGroupCount; ++i) {
                    LongTreeChain tree = this.orderedSources.getQuick(i);
                    functions = CachedWindowRecordCursorFactory.this.orderedFunctions.getQuick(i);
                    LongTreeChain.TreeCursor cursor = tree.getCursor();
                    int functionCount = functions.size();
                    while (cursor.hasNext()) {
                        this.circuitBreaker.statefulThrowExceptionIfTripped();
                        long offset = cursor.next();
                        this.recordChain.recordAt(chainRecord, offset);
                        for (int j2 = 0; j2 < functionCount; ++j2) {
                            functions.getQuick(j2).pass1(chainRecord, offset, this.recordChain);
                        }
                    }
                }
            }
            if (CachedWindowRecordCursorFactory.this.unorderedFunctions != null) {
                int n = CachedWindowRecordCursorFactory.this.unorderedFunctions.size();
                for (j = 0; j < n; ++j) {
                    f = CachedWindowRecordCursorFactory.this.unorderedFunctions.getQuick(j);
                    if (f.getPass1ScanDirection() == WindowFunction.Pass1ScanDirection.FORWARD) {
                        this.recordChain.toTop();
                        while (this.recordChain.hasNext()) {
                            this.circuitBreaker.statefulThrowExceptionIfTripped();
                            f.pass1(chainRecord, chainRecord.getRowId(), this.recordChain);
                        }
                        continue;
                    }
                    this.recordChain.toBottom();
                    while (this.recordChain.hasPrev()) {
                        this.circuitBreaker.statefulThrowExceptionIfTripped();
                        f.pass1(chainRecord, chainRecord.getRowId(), this.recordChain);
                    }
                }
            }
            if (CachedWindowRecordCursorFactory.this.ordered2PassFunctions != null) {
                int n = CachedWindowRecordCursorFactory.this.ordered2PassFunctions.size();
                for (i = 0; i < n; ++i) {
                    functions = CachedWindowRecordCursorFactory.this.ordered2PassFunctions.getQuick(i);
                    if (functions == null) continue;
                    int k = functions.size();
                    for (int j3 = 0; j3 < k; ++j3) {
                        functions.getQuick(j3).preparePass2();
                    }
                }
            }
            if (CachedWindowRecordCursorFactory.this.unordered2PassFunctions != null) {
                int n = CachedWindowRecordCursorFactory.this.unordered2PassFunctions.size();
                for (j = 0; j < n; ++j) {
                    CachedWindowRecordCursorFactory.this.unordered2PassFunctions.getQuick(j).preparePass2();
                }
            }
            if (CachedWindowRecordCursorFactory.this.ordered2PassFunctions != null) {
                int n = CachedWindowRecordCursorFactory.this.ordered2PassFunctions.size();
                for (i = 0; i < n; ++i) {
                    LongTreeChain tree = this.orderedSources.getQuick(i);
                    ObjList<WindowFunction> functions2 = CachedWindowRecordCursorFactory.this.ordered2PassFunctions.getQuick(i);
                    if (functions2 == null) continue;
                    LongTreeChain.TreeCursor cursor = tree.getCursor();
                    int functionCount = functions2.size();
                    while (cursor.hasNext()) {
                        this.circuitBreaker.statefulThrowExceptionIfTripped();
                        long offset = cursor.next();
                        this.recordChain.recordAt(chainRecord, offset);
                        for (int j4 = 0; j4 < functionCount; ++j4) {
                            functions2.getQuick(j4).pass2(chainRecord, offset, this.recordChain);
                        }
                    }
                }
            }
            if (CachedWindowRecordCursorFactory.this.unordered2PassFunctions != null) {
                int n = CachedWindowRecordCursorFactory.this.unordered2PassFunctions.size();
                for (j = 0; j < n; ++j) {
                    f = CachedWindowRecordCursorFactory.this.unordered2PassFunctions.getQuick(j);
                    this.recordChain.toTop();
                    while (this.recordChain.hasNext()) {
                        this.circuitBreaker.statefulThrowExceptionIfTripped();
                        f.pass2(chainRecord, chainRecord.getRowId(), this.recordChain);
                    }
                }
            }
            this.recordChain.toTop();
        }

        private void of(RecordCursor baseCursor, SqlExecutionContext executionContext) throws SqlException {
            this.baseCursor = baseCursor;
            this.isRecordChainBuilt = false;
            this.recordChainOffset = -1L;
            this.circuitBreaker = executionContext.getCircuitBreaker();
            if (!this.isOpen) {
                this.isOpen = true;
                this.recordChain.reopen();
                this.recordChain.setSymbolTableResolver(this);
                this.reopenTrees();
                this.reopen(CachedWindowRecordCursorFactory.this.allFunctions);
            }
            Function.init(CachedWindowRecordCursorFactory.this.allFunctions, this, executionContext, null);
        }

        private void reopen(ObjList<?> list) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                if (!(list.getQuick(i) instanceof Reopenable)) continue;
                ((Reopenable)list.getQuick(i)).reopen();
            }
        }

        private void reopenTrees() {
            for (int i = 0; i < CachedWindowRecordCursorFactory.this.orderedGroupCount; ++i) {
                this.orderedSources.getQuick(i).reopen();
            }
        }
    }
}

