/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.orderby;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ListColumnFilter;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.orderby.LongSortedLightRecordCursor;
import io.questdb.griffin.engine.orderby.SortedLightRecordCursorFactory;
import io.questdb.griffin.engine.orderby.SortedRecordCursorFactory;

public class LongSortedLightRecordCursorFactory
extends AbstractRecordCursorFactory {
    private final RecordCursorFactory base;
    private final LongSortedLightRecordCursor cursor;
    private final ListColumnFilter sortColumnFilter;

    public LongSortedLightRecordCursorFactory(CairoConfiguration configuration, RecordMetadata metadata, RecordCursorFactory base, ListColumnFilter sortColumnFilter) {
        super(metadata);
        this.base = base;
        int columnIndex = sortColumnFilter.getColumnIndexFactored(0);
        this.cursor = new LongSortedLightRecordCursor(configuration, columnIndex, metadata.getColumnType(columnIndex), sortColumnFilter.getColumnIndex(0) > 0);
        this.sortColumnFilter = sortColumnFilter;
    }

    public static boolean isSupportedColumnType(int columnType) {
        return columnType == 5 || columnType == 25 || columnType == 6 || columnType == 8 || columnType == 7;
    }

    @Override
    public RecordCursorFactory getBaseFactory() {
        return this.base;
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        RecordCursor baseCursor = this.base.getCursor(executionContext);
        try {
            this.cursor.of(baseCursor, executionContext);
            return this.cursor;
        }
        catch (Throwable ex) {
            this.cursor.close();
            throw ex;
        }
    }

    @Override
    public int getScanDirection() {
        return SortedRecordCursorFactory.getScanDirection(this.sortColumnFilter);
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return true;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("Radix sort light");
        SortedLightRecordCursorFactory.addSortKeys(sink, this.sortColumnFilter);
        sink.child(this.base);
    }

    @Override
    public boolean usesCompiledFilter() {
        return this.base.usesCompiledFilter();
    }

    @Override
    public boolean usesIndex() {
        return this.base.usesIndex();
    }

    @Override
    protected void _close() {
        this.base.close();
        this.cursor.close();
    }
}

