/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.join;

import io.questdb.cairo.DataUnavailableException;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.join.AbstractJoinCursor;
import io.questdb.griffin.engine.join.AbstractJoinRecordCursorFactory;
import io.questdb.griffin.engine.join.JoinRecord;
import io.questdb.std.Misc;

public class CrossJoinRecordCursorFactory
extends AbstractJoinRecordCursorFactory {
    private final CrossJoinRecordCursor cursor;

    public CrossJoinRecordCursorFactory(RecordMetadata metadata, RecordCursorFactory masterFactory, RecordCursorFactory slaveFactory, int columnSplit) {
        super(metadata, null, masterFactory, slaveFactory);
        this.cursor = new CrossJoinRecordCursor(columnSplit);
    }

    @Override
    public boolean followedOrderByAdvice() {
        return this.masterFactory.followedOrderByAdvice();
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        RecordCursor masterCursor = this.masterFactory.getCursor(executionContext);
        RecordCursor slaveCursor = null;
        try {
            slaveCursor = this.slaveFactory.getCursor(executionContext);
            this.cursor.of(masterCursor, slaveCursor, executionContext.getCircuitBreaker());
            return this.cursor;
        }
        catch (Throwable ex) {
            Misc.free(masterCursor);
            Misc.free(slaveCursor);
            throw ex;
        }
    }

    @Override
    public int getScanDirection() {
        return this.masterFactory.getScanDirection();
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return false;
    }

    @Override
    public boolean supportsUpdateRowId(TableToken tableToken) {
        return this.masterFactory.supportsUpdateRowId(tableToken);
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("Cross Join");
        sink.child(this.masterFactory);
        sink.child(this.slaveFactory);
    }

    @Override
    protected void _close() {
        Misc.freeIfCloseable(this.getMetadata());
        Misc.free(this.masterFactory);
        Misc.free(this.slaveFactory);
    }

    private static class CrossJoinRecordCursor
    extends AbstractJoinCursor {
        private final JoinRecord record;
        private final RecordCursor.Counter tmpCounter;
        private SqlExecutionCircuitBreaker circuitBreaker;
        private boolean isMasterHasNextPending;
        private boolean isMasterSizeCalculated;
        private boolean isSlavePartialSizeCalculated;
        private boolean isSlaveReset;
        private boolean isSlaveSizeCalculated;
        private boolean masterHasNext;
        private long masterSize;
        private long slavePartialSize;
        private long slaveSize;

        public CrossJoinRecordCursor(int columnSplit) {
            super(columnSplit);
            this.record = new JoinRecord(columnSplit);
            this.tmpCounter = new RecordCursor.Counter();
        }

        @Override
        public void calculateSize(SqlExecutionCircuitBreaker circuitBreaker, RecordCursor.Counter counter) {
            if (!this.isMasterHasNextPending && !this.masterHasNext) {
                return;
            }
            if (!this.isSlavePartialSizeCalculated) {
                this.slaveCursor.calculateSize(circuitBreaker, this.tmpCounter);
                this.slavePartialSize = this.tmpCounter.get();
                this.isSlavePartialSizeCalculated = true;
                this.tmpCounter.clear();
            }
            if (!this.isMasterSizeCalculated) {
                this.masterCursor.calculateSize(circuitBreaker, this.tmpCounter);
                this.masterSize = this.tmpCounter.get();
                this.isMasterSizeCalculated = true;
                this.tmpCounter.clear();
            }
            if (this.masterSize == 0L) {
                if (!this.isMasterHasNextPending) {
                    counter.add(this.slavePartialSize);
                }
            } else {
                if (!this.isSlaveSizeCalculated) {
                    if (!this.isSlaveReset) {
                        this.slaveCursor.toTop();
                        this.isSlaveReset = true;
                    }
                    this.slaveCursor.calculateSize(circuitBreaker, this.tmpCounter);
                    this.slaveSize = this.tmpCounter.get();
                    this.isSlaveSizeCalculated = true;
                }
                long size = this.masterSize * this.slaveSize;
                if (!this.isMasterHasNextPending) {
                    size += this.slavePartialSize;
                }
                counter.add(size);
            }
        }

        @Override
        public Record getRecord() {
            return this.record;
        }

        @Override
        public boolean hasNext() {
            while (true) {
                if (this.isMasterHasNextPending) {
                    this.masterHasNext = this.masterCursor.hasNext();
                    this.isMasterHasNextPending = false;
                }
                if (!this.masterHasNext) {
                    return false;
                }
                if (this.slaveCursor.hasNext()) {
                    return true;
                }
                this.slaveCursor.toTop();
                this.circuitBreaker.statefulThrowExceptionIfTrippedNoThrottle();
                this.isMasterHasNextPending = true;
            }
        }

        @Override
        public long preComputedStateSize() {
            return 0L;
        }

        @Override
        public long size() {
            long sizeA = this.masterCursor.size();
            long sizeB = this.slaveCursor.size();
            if (sizeA == -1L || sizeB == -1L) {
                return -1L;
            }
            long result = sizeA * sizeB;
            return result < sizeA && sizeB > 0L ? Long.MAX_VALUE : result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void skipRows(RecordCursor.Counter rowCount) throws DataUnavailableException {
            if (rowCount.get() == 0L) {
                return;
            }
            if (!this.isSlaveSizeCalculated) {
                this.slaveCursor.calculateSize(this.circuitBreaker, this.tmpCounter);
                this.slaveSize = this.tmpCounter.get();
                this.isSlaveSizeCalculated = true;
                this.tmpCounter.clear();
            }
            if (this.slaveSize == 0L) {
                return;
            }
            long masterToSkip = rowCount.get() / this.slaveSize;
            this.tmpCounter.set(masterToSkip);
            try {
                this.masterCursor.skipRows(this.tmpCounter);
                this.masterHasNext = this.masterCursor.hasNext();
                this.isMasterHasNextPending = false;
            }
            finally {
                long diff = (masterToSkip - this.tmpCounter.get()) * this.slaveSize;
                rowCount.dec(diff);
            }
            if (!this.masterHasNext) {
                return;
            }
            if (!this.isSlaveReset) {
                this.slaveCursor.toTop();
                this.isSlaveReset = true;
            }
            this.slaveCursor.skipRows(rowCount);
        }

        @Override
        public void toTop() {
            this.masterCursor.toTop();
            this.slaveCursor.toTop();
            this.isMasterHasNextPending = true;
            this.isSlavePartialSizeCalculated = false;
            this.isSlaveReset = false;
            this.isSlaveSizeCalculated = false;
            this.isMasterSizeCalculated = false;
            this.tmpCounter.clear();
            this.masterSize = 0L;
            this.slaveSize = 0L;
            this.slavePartialSize = 0L;
        }

        void of(RecordCursor masterCursor, RecordCursor slaveCursor, SqlExecutionCircuitBreaker circuitBreaker) {
            this.masterCursor = masterCursor;
            this.slaveCursor = slaveCursor;
            this.record.of(masterCursor.getRecord(), slaveCursor.getRecord());
            this.isMasterHasNextPending = true;
            this.circuitBreaker = circuitBreaker;
            this.isSlavePartialSizeCalculated = false;
            this.isSlaveReset = false;
            this.isSlaveSizeCalculated = false;
            this.isMasterSizeCalculated = false;
            this.tmpCounter.clear();
            this.masterSize = 0L;
            this.slaveSize = 0L;
            this.slavePartialSize = 0L;
        }
    }
}

