/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.griffin.engine.groupby.GroupByAllocator;
import io.questdb.std.Unsafe;
import io.questdb.std.str.AbstractCharSequence;
import io.questdb.std.str.DirectString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StableAwareStringHolder
implements CharSequence {
    private static final long HEADER_SIZE = 8L;
    private static final long LEN_OFFSET = 4L;
    private static final int MIN_CAPACITY = 4;
    private GroupByAllocator allocator;
    private boolean direct;
    private long ptr;

    @Override
    public char charAt(int index) {
        if (this.direct) {
            long directPtr = Unsafe.getUnsafe().getLong(this.ptr + 8L);
            assert (directPtr != 0L);
            return Unsafe.getUnsafe().getChar(directPtr + 2L * (long)index);
        }
        return Unsafe.getUnsafe().getChar(this.ptr + 8L + 2L * (long)index);
    }

    public void clearAndSet(@Nullable CharSequence cs) {
        DirectString ds;
        this.clear();
        if (cs == null) {
            return;
        }
        if (cs instanceof DirectString && (ds = (DirectString)cs).isStable()) {
            this.direct = true;
            this.checkCapacity(4);
            Unsafe.getUnsafe().putLong(this.ptr + 8L, ds.ptr());
            Unsafe.getUnsafe().putInt(this.ptr + 4L, cs.length());
            return;
        }
        int thatLen = cs.length();
        this.checkCapacity(thatLen);
        long lo = this.ptr + 8L;
        for (int i = 0; i < thatLen; ++i) {
            Unsafe.getUnsafe().putChar(lo + 2L * (long)i, cs.charAt(i));
        }
        Unsafe.getUnsafe().putInt(this.ptr + 4L, thatLen);
    }

    public long colouredPtr() {
        return this.ptr | (this.direct ? Long.MIN_VALUE : 0L);
    }

    @Override
    public int length() {
        return this.ptr != 0L ? Unsafe.getUnsafe().getInt(this.ptr + 4L) : 0;
    }

    public StableAwareStringHolder of(long colouredPtr) {
        this.ptr = colouredPtr & Long.MAX_VALUE;
        this.direct = (colouredPtr & Long.MIN_VALUE) != 0L;
        return this;
    }

    public void setAllocator(GroupByAllocator allocator) {
        this.allocator = allocator;
    }

    @Override
    @NotNull
    public CharSequence subSequence(int start, int end) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public String toString() {
        return AbstractCharSequence.getString(this);
    }

    private int capacity() {
        return this.ptr != 0L ? Unsafe.getUnsafe().getInt(this.ptr) : 0;
    }

    private void checkCapacity(int nChars) {
        int newCapacity;
        int capacity = this.capacity();
        if (capacity > 0 && nChars <= capacity) {
            return;
        }
        for (newCapacity = Math.max(capacity, 4); newCapacity < nChars; newCapacity *= 2) {
        }
        long newSize = ((long)newCapacity << 1) + 8L;
        if (this.ptr == 0L) {
            this.ptr = this.allocator.malloc(newSize);
            Unsafe.getUnsafe().putInt(this.ptr, newCapacity);
            Unsafe.getUnsafe().putInt(this.ptr + 4L, 0);
        } else {
            this.ptr = this.allocator.realloc(this.ptr, ((long)capacity << 1) + 8L, newSize);
            Unsafe.getUnsafe().putInt(this.ptr, newCapacity);
        }
        assert (this.ptr != 0L);
        assert ((this.ptr & Long.MIN_VALUE) == 0L);
    }

    private void clear() {
        if (this.ptr != 0L) {
            Unsafe.getUnsafe().putInt(this.ptr + 4L, 0);
            this.direct = false;
        }
    }
}

