/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.DataUnavailableException;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.NoRandomAccessRecordCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.TimestampFunction;
import io.questdb.griffin.engine.functions.constants.ConstantFunction;
import io.questdb.griffin.engine.functions.constants.NullConstant;
import io.questdb.griffin.engine.functions.constants.TimestampConstant;
import io.questdb.griffin.engine.groupby.TimestampSampler;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.BinarySequence;
import io.questdb.std.DirectLongList;
import io.questdb.std.Long256;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.Utf8Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FillRangeRecordCursorFactory
extends AbstractRecordCursorFactory {
    public static final Log LOG = LogFactory.getLog(FillRangeRecordCursorFactory.class);
    private final RecordCursorFactory base;
    private final FillRangeRecordCursor cursor;
    private final ObjList<Function> fillValues;
    private final Function fromFunc;
    private final long samplingInterval;
    private final char samplingIntervalUnit;
    private final int timestampIndex;
    private final Function toFunc;

    public FillRangeRecordCursorFactory(RecordMetadata metadata, RecordCursorFactory base, Function fromFunc, Function toFunc, long samplingInterval, char samplingIntervalUnit, TimestampSampler timestampSampler, ObjList<Function> fillValues, int timestampIndex) {
        super(metadata);
        this.base = base;
        this.fromFunc = fromFunc;
        this.toFunc = toFunc;
        this.samplingInterval = samplingInterval;
        this.samplingIntervalUnit = samplingIntervalUnit;
        this.timestampIndex = timestampIndex;
        this.fillValues = fillValues;
        this.cursor = new FillRangeRecordCursor(timestampSampler, fromFunc, toFunc, fillValues, timestampIndex);
    }

    @Override
    public RecordCursorFactory getBaseFactory() {
        return this.base;
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        if (this.getMetadata().getColumnCount() > this.fillValues.size() + 1) {
            if (this.fillValues.size() == 1 && this.fillValues.getQuick(0).isNullConstant()) {
                int diff = this.getMetadata().getColumnCount() - 1;
                for (int i = 1; i < diff; ++i) {
                    this.fillValues.add(NullConstant.NULL);
                }
            } else {
                throw SqlException.$(-1, "not enough fill values");
            }
        }
        RecordCursor baseCursor = this.base.getCursor(executionContext);
        try {
            this.cursor.of(baseCursor, executionContext);
            return this.cursor;
        }
        catch (Throwable th) {
            this.cursor.close();
            throw th;
        }
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return false;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("Fill Range");
        if (this.fromFunc != TimestampConstant.NULL || this.toFunc != TimestampConstant.NULL) {
            sink.attr("range").val('(').val(this.fromFunc).val(',').val(this.toFunc).val(')');
        }
        sink.attr("stride").val('\'').val(this.samplingInterval).val(this.samplingIntervalUnit).val('\'');
        sink.attr("values").val('[');
        int commaStartIndex = this.timestampIndex == 0 ? 2 : 1;
        for (int i = 0; i < this.fillValues.size(); ++i) {
            if (i == this.timestampIndex) continue;
            if (i >= commaStartIndex) {
                sink.val(',');
            }
            sink.val(this.fillValues.getQuick(i));
        }
        sink.val(']');
        sink.child(this.base);
    }

    @Override
    public boolean usesCompiledFilter() {
        return this.base.usesCompiledFilter();
    }

    @Override
    public boolean usesIndex() {
        return this.base.usesIndex();
    }

    @Override
    protected void _close() {
        this.base.close();
        Misc.free(this.fromFunc);
        Misc.free(this.toFunc);
        Misc.freeObjList(this.fillValues);
    }

    private static class FillRangeRecordCursor
    implements NoRandomAccessRecordCursor {
        private final ObjList<Function> fillValues;
        private final FillRangeRecord fillingRecord = new FillRangeRecord();
        private final FillRangeTimestampConstant fillingTimestampFunc = new FillRangeTimestampConstant();
        private final Function fromFunc;
        private final int timestampIndex;
        private final TimestampSampler timestampSampler;
        private final Function toFunc;
        private RecordCursor baseCursor;
        private Record baseRecord;
        private boolean gapFilling;
        private boolean hasNegative;
        private long lastTimestamp = Long.MIN_VALUE;
        private long maxTimestamp;
        private long minTimestamp;
        private boolean needsSorting = false;
        private long nextBucketTimestamp;
        private DirectLongList presentTimestamps;
        private long presentTimestampsIndex;
        private long presentTimestampsSize;

        private FillRangeRecordCursor(TimestampSampler timestampSampler, @NotNull Function fromFunc, @NotNull Function toFunc, ObjList<Function> fillValues, int timestampIndex) {
            this.timestampSampler = timestampSampler;
            this.fromFunc = fromFunc;
            this.toFunc = toFunc;
            this.fillValues = fillValues;
            this.timestampIndex = timestampIndex;
        }

        @Override
        public void close() {
            this.baseCursor = Misc.free(this.baseCursor);
            this.presentTimestamps = Misc.free(this.presentTimestamps);
        }

        @Override
        public Record getRecord() {
            return this.fillingRecord;
        }

        @Override
        public SymbolTable getSymbolTable(int columnIndex) {
            return this.baseCursor.getSymbolTable(columnIndex);
        }

        @Override
        public boolean hasNext() {
            if (this.gapFilling) {
                this.nextBucketTimestamp = this.timestampSampler.nextTimestamp(this.nextBucketTimestamp);
                return this.foundGapToFill();
            }
            if (this.baseCursor.hasNext()) {
                long timestamp = this.baseRecord.getTimestamp(this.timestampIndex);
                this.needsSorting |= this.lastTimestamp > timestamp;
                boolean bl = this.hasNegative = this.hasNegative || timestamp < 0L;
                if (this.hasNegative && this.needsSorting) {
                    throw CairoException.nonCritical().put("cannot FILL for the timestamps before 1970");
                }
                this.lastTimestamp = timestamp;
                this.presentTimestamps.add(this.lastTimestamp);
                return true;
            }
            this.gapFilling = true;
            this.prepareGapFilling();
            return this.foundGapToFill();
        }

        @Override
        public long preComputedStateSize() {
            return 0L;
        }

        @Override
        public long size() {
            return -1L;
        }

        @Override
        public void toTop() {
            this.baseCursor.toTop();
            this.presentTimestamps.clear();
            this.gapFilling = false;
            this.needsSorting = false;
            this.lastTimestamp = Long.MIN_VALUE;
        }

        private boolean foundGapToFill() {
            while (this.presentTimestampsIndex < this.presentTimestampsSize && this.presentTimestamps.get(this.presentTimestampsIndex) == this.nextBucketTimestamp) {
                this.nextBucketTimestamp = this.timestampSampler.nextTimestamp(this.nextBucketTimestamp);
                ++this.presentTimestampsIndex;
            }
            return this.nextBucketTimestamp < this.maxTimestamp;
        }

        private Function getFillFunction(int col) {
            if (col == this.timestampIndex) {
                return this.fillingTimestampFunc;
            }
            return this.fillValues.getQuick(col);
        }

        private void initTimestamps(Function fromFunc, Function toFunc) {
            this.minTimestamp = fromFunc == TimestampConstant.NULL ? Long.MAX_VALUE : fromFunc.getTimestamp(null);
            this.maxTimestamp = toFunc == TimestampConstant.NULL ? Long.MIN_VALUE : toFunc.getTimestamp(null);
        }

        private void initValueFuncs(ObjList<Function> valueFuncs) {
            if (valueFuncs.size() - 1 < this.timestampIndex) {
                valueFuncs.extendAndSet(this.timestampIndex, NullConstant.NULL);
                return;
            }
            Function func = valueFuncs.getQuick(this.timestampIndex);
            if (func != null) {
                valueFuncs.insert(this.timestampIndex, 1, NullConstant.NULL);
            }
        }

        private void of(RecordCursor baseCursor, SqlExecutionContext executionContext) throws SqlException {
            this.baseCursor = baseCursor;
            Function.init(this.fillValues, baseCursor, executionContext, null);
            this.fromFunc.init(baseCursor, executionContext);
            this.toFunc.init(baseCursor, executionContext);
            this.initTimestamps(this.fromFunc, this.toFunc);
            if (this.presentTimestamps == null) {
                long capacity = 8L;
                try {
                    capacity = baseCursor.size();
                    if (capacity < 0L) {
                        capacity = 8L;
                    }
                }
                catch (DataUnavailableException dataUnavailableException) {
                    // empty catch block
                }
                this.presentTimestamps = new DirectLongList(capacity, 32);
            }
            this.initValueFuncs(this.fillValues);
            this.baseRecord = baseCursor.getRecord();
            this.toTop();
        }

        private void prepareGapFilling() {
            this.presentTimestampsSize = this.presentTimestamps.size();
            if (this.needsSorting && this.presentTimestampsSize > 1L) {
                this.presentTimestamps.sortAsUnsigned();
            }
            if (this.presentTimestampsSize > 0L) {
                this.minTimestamp = Math.min(this.minTimestamp, this.presentTimestamps.get(0L));
                this.maxTimestamp = Math.max(this.maxTimestamp, this.presentTimestamps.get(this.presentTimestampsSize - 1L));
            }
            this.timestampSampler.setStart(this.minTimestamp);
            this.nextBucketTimestamp = this.minTimestamp;
            this.presentTimestampsIndex = 0L;
        }

        private class FillRangeRecord
        implements Record {
            private FillRangeRecord() {
            }

            @Override
            public BinarySequence getBin(int col) {
                if (FillRangeRecordCursor.this.gapFilling) {
                    return FillRangeRecordCursor.this.getFillFunction(col).getBin(null);
                }
                return FillRangeRecordCursor.this.baseRecord.getBin(col);
            }

            @Override
            public long getBinLen(int col) {
                if (FillRangeRecordCursor.this.gapFilling) {
                    return FillRangeRecordCursor.this.getFillFunction(col).getBinLen(null);
                }
                return FillRangeRecordCursor.this.baseRecord.getBinLen(col);
            }

            @Override
            public boolean getBool(int col) {
                if (FillRangeRecordCursor.this.gapFilling) {
                    return FillRangeRecordCursor.this.getFillFunction(col).getBool(null);
                }
                return FillRangeRecordCursor.this.baseRecord.getBool(col);
            }

            @Override
            public byte getByte(int col) {
                if (FillRangeRecordCursor.this.gapFilling) {
                    return FillRangeRecordCursor.this.getFillFunction(col).getByte(null);
                }
                return FillRangeRecordCursor.this.baseRecord.getByte(col);
            }

            @Override
            public char getChar(int col) {
                if (FillRangeRecordCursor.this.gapFilling) {
                    return FillRangeRecordCursor.this.getFillFunction(col).getChar(null);
                }
                return FillRangeRecordCursor.this.baseRecord.getChar(col);
            }

            @Override
            public double getDouble(int col) {
                if (FillRangeRecordCursor.this.gapFilling) {
                    return FillRangeRecordCursor.this.getFillFunction(col).getDouble(null);
                }
                return FillRangeRecordCursor.this.baseRecord.getDouble(col);
            }

            @Override
            public float getFloat(int col) {
                if (FillRangeRecordCursor.this.gapFilling) {
                    return FillRangeRecordCursor.this.getFillFunction(col).getFloat(null);
                }
                return FillRangeRecordCursor.this.baseRecord.getFloat(col);
            }

            @Override
            public byte getGeoByte(int col) {
                if (FillRangeRecordCursor.this.gapFilling) {
                    return FillRangeRecordCursor.this.getFillFunction(col).getGeoByte(null);
                }
                return FillRangeRecordCursor.this.baseRecord.getGeoByte(col);
            }

            @Override
            public int getGeoInt(int col) {
                if (FillRangeRecordCursor.this.gapFilling) {
                    return FillRangeRecordCursor.this.getFillFunction(col).getGeoInt(null);
                }
                return FillRangeRecordCursor.this.baseRecord.getGeoInt(col);
            }

            @Override
            public long getGeoLong(int col) {
                if (FillRangeRecordCursor.this.gapFilling) {
                    return FillRangeRecordCursor.this.getFillFunction(col).getGeoLong(null);
                }
                return FillRangeRecordCursor.this.baseRecord.getGeoLong(col);
            }

            @Override
            public short getGeoShort(int col) {
                if (FillRangeRecordCursor.this.gapFilling) {
                    return FillRangeRecordCursor.this.getFillFunction(col).getGeoShort(null);
                }
                return FillRangeRecordCursor.this.baseRecord.getGeoShort(col);
            }

            @Override
            public int getIPv4(int col) {
                if (FillRangeRecordCursor.this.gapFilling) {
                    return FillRangeRecordCursor.this.getFillFunction(col).getIPv4(null);
                }
                return FillRangeRecordCursor.this.baseRecord.getIPv4(col);
            }

            @Override
            public int getInt(int col) {
                if (FillRangeRecordCursor.this.gapFilling) {
                    return FillRangeRecordCursor.this.getFillFunction(col).getInt(null);
                }
                return FillRangeRecordCursor.this.baseRecord.getInt(col);
            }

            @Override
            public long getLong(int col) {
                if (FillRangeRecordCursor.this.gapFilling) {
                    return FillRangeRecordCursor.this.getFillFunction(col).getLong(null);
                }
                return FillRangeRecordCursor.this.baseRecord.getLong(col);
            }

            @Override
            public long getLong128Hi(int col) {
                if (FillRangeRecordCursor.this.gapFilling) {
                    return FillRangeRecordCursor.this.getFillFunction(col).getLong128Hi(null);
                }
                return FillRangeRecordCursor.this.baseRecord.getLong128Hi(col);
            }

            @Override
            public long getLong128Lo(int col) {
                if (FillRangeRecordCursor.this.gapFilling) {
                    return FillRangeRecordCursor.this.getFillFunction(col).getLong128Lo(null);
                }
                return FillRangeRecordCursor.this.baseRecord.getLong128Lo(col);
            }

            @Override
            public void getLong256(int col, CharSink<?> sink) {
                if (FillRangeRecordCursor.this.gapFilling) {
                    FillRangeRecordCursor.this.getFillFunction(col).getLong256(null, sink);
                } else {
                    FillRangeRecordCursor.this.baseRecord.getLong256(col, sink);
                }
            }

            @Override
            public Long256 getLong256A(int col) {
                if (FillRangeRecordCursor.this.gapFilling) {
                    return FillRangeRecordCursor.this.getFillFunction(col).getLong256A(null);
                }
                return FillRangeRecordCursor.this.baseRecord.getLong256A(col);
            }

            @Override
            public Long256 getLong256B(int col) {
                if (FillRangeRecordCursor.this.gapFilling) {
                    return FillRangeRecordCursor.this.getFillFunction(col).getLong256B(null);
                }
                return FillRangeRecordCursor.this.baseRecord.getLong256B(col);
            }

            @Override
            public short getShort(int col) {
                if (FillRangeRecordCursor.this.gapFilling) {
                    return FillRangeRecordCursor.this.getFillFunction(col).getShort(null);
                }
                return FillRangeRecordCursor.this.baseRecord.getShort(col);
            }

            @Override
            @Nullable
            public CharSequence getStrA(int col) {
                if (FillRangeRecordCursor.this.gapFilling) {
                    return FillRangeRecordCursor.this.getFillFunction(col).getStrA(null);
                }
                return FillRangeRecordCursor.this.baseRecord.getStrA(col);
            }

            @Override
            public CharSequence getStrB(int col) {
                if (FillRangeRecordCursor.this.gapFilling) {
                    return FillRangeRecordCursor.this.getFillFunction(col).getStrB(null);
                }
                return FillRangeRecordCursor.this.baseRecord.getStrB(col);
            }

            @Override
            public int getStrLen(int col) {
                if (FillRangeRecordCursor.this.gapFilling) {
                    return FillRangeRecordCursor.this.getFillFunction(col).getStrLen(null);
                }
                return FillRangeRecordCursor.this.baseRecord.getStrLen(col);
            }

            @Override
            public CharSequence getSymA(int col) {
                if (FillRangeRecordCursor.this.gapFilling) {
                    return FillRangeRecordCursor.this.getFillFunction(col).getSymbol(null);
                }
                return FillRangeRecordCursor.this.baseRecord.getSymA(col);
            }

            @Override
            public CharSequence getSymB(int col) {
                if (FillRangeRecordCursor.this.gapFilling) {
                    return FillRangeRecordCursor.this.getFillFunction(col).getSymbolB(null);
                }
                return FillRangeRecordCursor.this.baseRecord.getSymB(col);
            }

            @Override
            public long getTimestamp(int col) {
                if (FillRangeRecordCursor.this.gapFilling) {
                    if (col == FillRangeRecordCursor.this.timestampIndex) {
                        return FillRangeRecordCursor.this.nextBucketTimestamp;
                    }
                    return FillRangeRecordCursor.this.getFillFunction(col).getLong(null);
                }
                return FillRangeRecordCursor.this.baseRecord.getTimestamp(col);
            }

            @Override
            @Nullable
            public Utf8Sequence getVarcharA(int col) {
                if (FillRangeRecordCursor.this.gapFilling) {
                    return FillRangeRecordCursor.this.getFillFunction(col).getVarcharA(null);
                }
                return FillRangeRecordCursor.this.baseRecord.getVarcharA(col);
            }

            @Override
            @Nullable
            public Utf8Sequence getVarcharB(int col) {
                if (FillRangeRecordCursor.this.gapFilling) {
                    return FillRangeRecordCursor.this.getFillFunction(col).getVarcharB(null);
                }
                return FillRangeRecordCursor.this.baseRecord.getVarcharB(col);
            }

            @Override
            public int getVarcharSize(int col) {
                if (FillRangeRecordCursor.this.gapFilling) {
                    return FillRangeRecordCursor.this.getFillFunction(col).getVarcharSize(null);
                }
                return FillRangeRecordCursor.this.baseRecord.getVarcharSize(col);
            }
        }

        private class FillRangeTimestampConstant
        extends TimestampFunction
        implements ConstantFunction {
            private FillRangeTimestampConstant() {
            }

            @Override
            public long getTimestamp(Record rec) {
                return FillRangeRecordCursor.this.nextBucketTimestamp;
            }
        }
    }
}

