/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.str;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.VarcharFunction;
import io.questdb.std.BinarySequence;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import io.questdb.std.str.Digest;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8StringSink;

public class SHA256BinFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "sha256(U)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function func = args.get(0);
        return new SHA256Func(func);
    }

    private static class SHA256Func
    extends VarcharFunction
    implements UnaryFunction {
        private final Function data;
        private final Utf8StringSink sinkA = new Utf8StringSink();
        private final Utf8StringSink sinkB = new Utf8StringSink();
        private final Digest hashFn = new Digest(Digest.DigestAlgorithm.SHA256);

        public SHA256Func(Function data) {
            this.data = data;
        }

        @Override
        public Function getArg() {
            return this.data;
        }

        @Override
        public Utf8Sequence getVarcharA(Record rec) {
            BinarySequence sequence = this.getArg().getBin(rec);
            if (sequence == null) {
                return null;
            }
            this.sinkA.clear();
            this.hashFn.hash(sequence, this.sinkA);
            return this.sinkA;
        }

        @Override
        public Utf8Sequence getVarcharB(Record rec) {
            BinarySequence sequence = this.getArg().getBin(rec);
            if (sequence == null) {
                return null;
            }
            this.sinkB.clear();
            this.hashFn.hash(sequence, this.sinkB);
            return this.sinkB;
        }

        @Override
        public boolean isThreadSafe() {
            return false;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val("sha256(").val(this.data).val(')');
        }
    }
}

