/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.lt;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.NegatableBooleanFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.constants.BooleanConstant;
import io.questdb.griffin.engine.functions.lt.LtStrFunctionFactory;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8s;

public class LtStrVarcharFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "<(S\u00d8)";
    }

    @Override
    public boolean isBoolean() {
        return true;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function a = args.getQuick(0);
        Function b = args.getQuick(1);
        if (a.isConstant() && !b.isConstant()) {
            Utf8Sequence constValue = a.getVarcharA(null);
            if (constValue == null) {
                return BooleanConstant.FALSE;
            }
            return new ConstOnLeftFunc(constValue, b);
        }
        if (!a.isConstant() && b.isConstant()) {
            CharSequence constValue = b.getStrA(null);
            if (constValue == null) {
                return BooleanConstant.FALSE;
            }
            return new LtStrFunctionFactory.ConstOnRightFunc(a, constValue);
        }
        return new LtStrFunctionFactory.Func(a, b);
    }

    static class ConstOnLeftFunc
    extends NegatableBooleanFunction
    implements UnaryFunction {
        private final Utf8Sequence constant;
        private final Function right;

        public ConstOnLeftFunc(Utf8Sequence constant, Function right) {
            this.constant = constant;
            this.right = right;
        }

        @Override
        public Function getArg() {
            return this.right;
        }

        @Override
        public boolean getBool(Record rec) {
            return Utf8s.lessThan(this.constant, this.right.getVarcharB(rec), this.negated);
        }

        @Override
        public String getName() {
            if (this.negated) {
                return ">=";
            }
            return "<";
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val('\'').val(this.constant).val('\'');
            sink.val(this.getName());
            sink.val(this.right);
        }
    }
}

