/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.date;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.date.AbstractDayIntervalWithTimezoneFunction;
import io.questdb.std.IntList;
import io.questdb.std.Interval;
import io.questdb.std.ObjList;
import org.jetbrains.annotations.NotNull;

public class TodayWithTimezoneFunctionFactory
implements FunctionFactory {
    private static final String SIGNATURE = "today(S)";

    @Override
    public String getSignature() {
        return SIGNATURE;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function tzFunc = args.getQuick(0);
        if (tzFunc.isConstant() || tzFunc.isRuntimeConstant()) {
            return new RuntimeConstFunc(tzFunc);
        }
        return new Func(tzFunc);
    }

    private static class RuntimeConstFunc
    extends AbstractDayIntervalWithTimezoneFunction {
        public RuntimeConstFunc(Function tzFunc) {
            super(tzFunc);
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
            super.init(symbolTableSource, executionContext);
            this.calculateInterval(executionContext.getNow(), this.tzFunc.getStrA(null));
        }

        @Override
        public boolean isRuntimeConstant() {
            return true;
        }

        @Override
        public boolean isThreadSafe() {
            return true;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(TodayWithTimezoneFunctionFactory.SIGNATURE);
        }

        @Override
        protected int shiftFromToday() {
            return 0;
        }
    }

    private static class Func
    extends AbstractDayIntervalWithTimezoneFunction {
        private long now;

        public Func(Function tzFunc) {
            super(tzFunc);
        }

        @Override
        @NotNull
        public Interval getInterval(Record rec) {
            return this.calculateInterval(this.now, this.tzFunc.getStrA(rec));
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
            super.init(symbolTableSource, executionContext);
            this.now = executionContext.getNow();
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(TodayWithTimezoneFunctionFactory.SIGNATURE);
        }

        @Override
        protected int shiftFromToday() {
            return 0;
        }
    }
}

