/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.conditional;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.StrFunction;
import io.questdb.std.Chars;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class NullIfStrFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "nullif(SS)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new Func(args.getQuick(0), args.getQuick(1));
    }

    private static class Func
    extends StrFunction
    implements BinaryFunction {
        private final Function strFunc1;
        private final Function strFunc2;

        public Func(Function strFunc1, Function strFunc2) {
            this.strFunc1 = strFunc1;
            this.strFunc2 = strFunc2;
        }

        @Override
        public Function getLeft() {
            return this.strFunc1;
        }

        @Override
        public String getName() {
            return "nullif";
        }

        @Override
        public Function getRight() {
            return this.strFunc2;
        }

        @Override
        public CharSequence getStrA(Record rec) {
            CharSequence cs1 = this.strFunc1.getStrA(rec);
            if (cs1 == null) {
                return null;
            }
            CharSequence cs2 = this.strFunc2.getStrA(rec);
            if (cs2 == null || !Chars.equals(cs1, cs2)) {
                return cs1;
            }
            return null;
        }

        @Override
        public CharSequence getStrB(Record rec) {
            CharSequence cs1 = this.strFunc1.getStrB(rec);
            if (cs1 == null) {
                return null;
            }
            CharSequence cs2 = this.strFunc2.getStrB(rec);
            if (cs2 == null || !Chars.equals(cs1, cs2)) {
                return cs1;
            }
            return null;
        }
    }
}

