/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.bool;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.GeoHashes;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.SqlUtil;
import io.questdb.griffin.engine.functions.MultiArgFunction;
import io.questdb.griffin.engine.functions.NegatableBooleanFunction;
import io.questdb.std.IntList;
import io.questdb.std.LongList;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;

public class WithinGeohashFunctionFactory
implements FunctionFactory {
    public static long getGeoHashAsLong(Record rec, Function geoHashFunc, int geoHashType) {
        switch (ColumnType.tagOf(geoHashType)) {
            case 14: {
                return geoHashFunc.getGeoByte(rec);
            }
            case 15: {
                return geoHashFunc.getGeoShort(rec);
            }
            case 16: {
                return geoHashFunc.getGeoInt(rec);
            }
            case 17: {
                return geoHashFunc.getGeoLong(rec);
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public String getSignature() {
        return "within(GV)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        int constCount = 0;
        int runtimeConstCount = 0;
        Function firstArg = args.getQuick(0);
        int argCount = args.size() - 1;
        for (int i = 1; i <= argCount; ++i) {
            Function func = args.getQuick(i);
            short funcType = ColumnType.tagOf(func.getType());
            if ((funcType < 14 || funcType > 17) && func.getType() != 0) {
                throw SqlException.position(argPositions.getQuick(i)).put("cannot compare GEOHASH with type ").put(ColumnType.nameOf(funcType));
            }
            if (func.isConstant()) {
                ++constCount;
            }
            if (!func.isRuntimeConstant()) continue;
            ++runtimeConstCount;
        }
        if (firstArg.isConstant() && constCount == 0 && runtimeConstCount == 0) {
            return new WithinGeohashConstVarFunction(new ObjList<Function>(args));
        }
        if (firstArg.isConstant() && constCount == argCount && runtimeConstCount == 0) {
            return new WithinGeohashConstConstFunction(new ObjList<Function>(args));
        }
        if (constCount == argCount && runtimeConstCount == 0) {
            try {
                return new WithinGeohashVarConstFunction(new ObjList<Function>(args));
            }
            catch (NumericException ex) {
                return new WithinGeohashVarVarFunction(new ObjList<Function>(args));
            }
        }
        if (runtimeConstCount == argCount || runtimeConstCount + constCount == argCount) {
            IntList positions = new IntList();
            positions.addAll(argPositions);
            return new WithinGeohashRuntimeConstFunction(new ObjList<Function>(args), positions);
        }
        return new WithinGeohashVarVarFunction(new ObjList<Function>(args));
    }

    private static class WithinGeohashConstVarFunction
    extends AbstractWithinGeohashFunction {
        final long geoHashValue;

        public WithinGeohashConstVarFunction(ObjList<Function> args) {
            super(args);
            this.geoHashValue = WithinGeohashFunctionFactory.getGeoHashAsLong(null, this.geoHashFunc, this.geoHashType);
        }

        @Override
        public boolean getBool(Record rec) {
            for (int i = 1; i <= this.argCount; ++i) {
                long convertedGeoHashValue;
                int prefixFuncType;
                Function prefixFunc = (Function)this.args.getQuick(i);
                long prefixValue = WithinGeohashFunctionFactory.getGeoHashAsLong(rec, prefixFunc, prefixFuncType = prefixFunc.getType());
                if (prefixValue != (convertedGeoHashValue = SqlUtil.implicitCastGeoHashAsGeoHash(this.geoHashValue, this.geoHashType, prefixFuncType))) continue;
                return !this.negated;
            }
            return this.negated;
        }
    }

    private static class WithinGeohashConstConstFunction
    extends AbstractWithinGeohashFunction {
        boolean result;

        public WithinGeohashConstConstFunction(ObjList<Function> args) {
            super(args);
            this.geoHashValue = WithinGeohashFunctionFactory.getGeoHashAsLong(null, this.geoHashFunc, this.geoHashType);
            for (int i = 1; i <= this.argCount; ++i) {
                long convertedGeoHashValue;
                int prefixFuncType;
                Function prefixFunc = args.getQuick(i);
                long prefixValue = WithinGeohashFunctionFactory.getGeoHashAsLong(null, prefixFunc, prefixFuncType = prefixFunc.getType());
                if (prefixValue != (convertedGeoHashValue = SqlUtil.implicitCastGeoHashAsGeoHash(this.geoHashValue, this.geoHashType, prefixFuncType))) continue;
                this.result = !this.negated;
                break;
            }
        }

        @Override
        public boolean getBool(Record rec) {
            return this.result;
        }
    }

    private static class WithinGeohashVarConstFunction
    extends AbstractWithinGeohashFunction {
        final LongList prefixList;
        final int preflixListSize;

        public WithinGeohashVarConstFunction(ObjList<Function> args) throws NumericException {
            super(args);
            this.prefixList = new LongList((args.size() - 1) * 2);
            for (int i = 1; i <= this.argCount; ++i) {
                Function prefixFunc = args.getQuick(i);
                int prefixFuncType = prefixFunc.getType();
                long prefixValue = WithinGeohashFunctionFactory.getGeoHashAsLong(null, prefixFunc, prefixFuncType);
                GeoHashes.addNormalizedGeoPrefix(prefixValue, prefixFuncType, args.getQuick(0).getType(), this.prefixList);
            }
            this.preflixListSize = this.prefixList.size();
        }

        @Override
        public boolean getBool(Record rec) {
            this.geoHashValue = WithinGeohashFunctionFactory.getGeoHashAsLong(rec, this.geoHashFunc, this.geoHashType);
            for (int i = 0; i < this.preflixListSize; i += 2) {
                long prefixValue = this.prefixList.getQuick(i);
                long prefixMask = this.prefixList.getQuick(i + 1);
                if ((this.geoHashValue & prefixMask) != prefixValue) continue;
                return !this.negated;
            }
            return this.negated;
        }
    }

    private static class WithinGeohashVarVarFunction
    extends AbstractWithinGeohashFunction {
        public WithinGeohashVarVarFunction(ObjList<Function> args) {
            super(args);
        }

        @Override
        public boolean getBool(Record rec) {
            this.geoHashValue = WithinGeohashFunctionFactory.getGeoHashAsLong(rec, this.geoHashFunc, this.geoHashType);
            for (int i = 1; i <= this.argCount; ++i) {
                long convertedGeoHashValue;
                int prefixFuncType;
                Function prefixFunc = (Function)this.args.getQuick(i);
                long prefixValue = WithinGeohashFunctionFactory.getGeoHashAsLong(rec, prefixFunc, prefixFuncType = prefixFunc.getType());
                if (prefixValue != (convertedGeoHashValue = SqlUtil.implicitCastGeoHashAsGeoHash(this.geoHashValue, this.geoHashType, prefixFuncType))) continue;
                return !this.negated;
            }
            return this.negated;
        }
    }

    private static class WithinGeohashRuntimeConstFunction
    extends AbstractWithinGeohashFunction {
        IntList argPositions;
        long geoHashValue;
        ObjList<Function> prefixFuncs;
        LongList prefixList;
        int prefixListSize;

        public WithinGeohashRuntimeConstFunction(ObjList<Function> args, IntList argPositions) {
            super(args);
            this.prefixFuncs = args;
            this.argPositions = argPositions;
        }

        @Override
        public boolean getBool(Record rec) {
            this.geoHashValue = WithinGeohashFunctionFactory.getGeoHashAsLong(rec, this.geoHashFunc, this.geoHashType);
            for (int i = 0; i < this.prefixListSize; i += 2) {
                long prefixValue = this.prefixList.getQuick(i);
                long prefixMask = this.prefixList.getQuick(i + 1);
                if ((this.geoHashValue & prefixMask) != prefixValue) continue;
                return !this.negated;
            }
            return this.negated;
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
            super.init(symbolTableSource, executionContext);
            this.prefixList = new LongList(this.argCount * 2);
            for (int i = 1; i <= this.argCount; ++i) {
                Function prefixFunc = (Function)this.args.getQuick(i);
                int prefixFuncType = prefixFunc.getType();
                long prefixValue = WithinGeohashFunctionFactory.getGeoHashAsLong(null, prefixFunc, prefixFuncType);
                try {
                    GeoHashes.addNormalizedGeoPrefix(prefixValue, prefixFuncType, this.geoHashType, this.prefixList);
                    continue;
                }
                catch (NumericException ex) {
                    throw CairoException.nonCritical().position(this.argPositions.getQuick(0)).put("could not process geohash: ").put(GeoHashes.toString0(prefixValue, prefixFuncType));
                }
            }
            this.prefixListSize = this.prefixList.size();
        }
    }

    private static abstract class AbstractWithinGeohashFunction
    extends NegatableBooleanFunction
    implements MultiArgFunction {
        protected final int argCount;
        protected final ObjList<Function> args;
        protected final Function geoHashFunc;
        protected final int geoHashType;
        protected long geoHashValue;

        public AbstractWithinGeohashFunction(ObjList<Function> args) {
            this.args = args;
            this.argCount = args.size() - 1;
            this.geoHashFunc = args.getQuick(0);
            this.geoHashType = this.geoHashFunc.getType();
        }

        @Override
        public ObjList<Function> getArgs() {
            return new ObjList<Function>(this.args);
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.args.getQuick(0));
            if (this.negated) {
                sink.val(" not");
            }
            sink.val(" in ");
            sink.val(this.args, 1);
        }
    }
}

