/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.array;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.arr.ArrayView;
import io.questdb.cairo.arr.DirectArray;
import io.questdb.cairo.arr.FlatArrayView;
import io.questdb.cairo.sql.ArrayFunction;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.vm.api.MemoryA;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class DoubleNegArrayFunctionFactory
implements FunctionFactory {
    private static final String OPERATOR_NAME = "-";

    @Override
    public String getSignature() {
        return "-(D[])";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        return new Func(args.getQuick(0), configuration);
    }

    private static class Func
    extends ArrayFunction
    implements UnaryFunction {
        private final DirectArray array;
        private final Function arrayArg;

        public Func(Function arrayArg, CairoConfiguration configuration) {
            this.arrayArg = arrayArg;
            this.array = new DirectArray(configuration);
            this.type = arrayArg.getType();
        }

        @Override
        public void close() {
            UnaryFunction.super.close();
            this.array.close();
        }

        @Override
        public Function getArg() {
            return this.arrayArg;
        }

        @Override
        public ArrayView getArray(Record rec) {
            ArrayView arr = this.arrayArg.getArray(rec);
            if (arr.isNull()) {
                this.array.ofNull();
                return this.array;
            }
            MemoryA memory = this.array.copyShapeAndStartMemoryA(arr);
            if (arr.isVanilla()) {
                FlatArrayView flatView = arr.flatView();
                int n = arr.getHi();
                for (int i = arr.getLo(); i < n; ++i) {
                    memory.putDouble(-flatView.getDoubleAtAbsIndex(i));
                }
            } else {
                Func.calculateRecursive(arr, 0, 0, memory);
            }
            return this.array;
        }

        @Override
        public String getName() {
            return DoubleNegArrayFunctionFactory.OPERATOR_NAME;
        }

        @Override
        public boolean isOperator() {
            return true;
        }

        @Override
        public boolean isThreadSafe() {
            return false;
        }

        private static void calculateRecursive(ArrayView view, int dim, int flatIndex, MemoryA memOut) {
            boolean atDeepestDim;
            int count = view.getDimLen(dim);
            int stride = view.getStride(dim);
            boolean bl = atDeepestDim = dim == view.getDimCount() - 1;
            if (atDeepestDim) {
                for (int i = 0; i < count; ++i) {
                    memOut.putDouble(-view.getDouble(flatIndex));
                    flatIndex += stride;
                }
            } else {
                for (int i = 0; i < count; ++i) {
                    Func.calculateRecursive(view, dim + 1, flatIndex, memOut);
                    flatIndex += stride;
                }
            }
        }
    }
}

