/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.array;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.arr.ArrayView;
import io.questdb.cairo.arr.DirectArray;
import io.questdb.cairo.arr.FunctionArray;
import io.questdb.cairo.sql.ArrayFunction;
import io.questdb.cairo.sql.BindVariableService;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.vm.api.MemoryA;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.MultiArgFunction;
import io.questdb.griffin.engine.functions.constants.ArrayConstant;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import org.jetbrains.annotations.NotNull;

public class ArrayCreateFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "array(V)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        int nestedNDims;
        short commonElemType;
        block15: {
            int outerDimLen;
            int n = outerDimLen = args == null ? 0 : args.size();
            if (outerDimLen == 0) {
                return ArrayConstant.emptyUntyped(1);
            }
            Function arg0 = args.getQuick(0);
            int arg0Pos = argPositions.getQuick(0);
            int type0 = arg0.getType();
            commonElemType = 10;
            if (!ColumnType.isArray(type0)) {
                for (int i = 1; i < outerDimLen; ++i) {
                    Function argI = args.getQuick(i);
                    short typeI = (short)argI.getType();
                    if (!ColumnType.isArray(typeI)) continue;
                    throw SqlException.$(argPositions.getQuick(i), "mixed array and non-array elements");
                }
                if (!ColumnType.isSupportedArrayElementType(commonElemType)) {
                    throw SqlException.position(arg0Pos).put("unsupported array element type [type=").put(ColumnType.nameOf(commonElemType)).put(']');
                }
                FunctionArray array = new FunctionArray(commonElemType, 1);
                array.setDimLen(0, outerDimLen);
                array.applyShape(configuration, arg0Pos);
                for (int i = 0; i < outerDimLen; ++i) {
                    Function argI = args.getQuick(i);
                    array.putFunction(i, argI);
                }
                return new FunctionArrayFunction(array);
            }
            commonElemType = ColumnType.decodeArrayElementType(type0);
            nestedNDims = ColumnType.decodeArrayDimensionality(arg0.getType());
            int n2 = args.size();
            for (int i = 1; i < n2; ++i) {
                Function argI = args.getQuick(i);
                int typeI = argI.getType();
                int argPosI = argPositions.getQuick(i);
                if (!ColumnType.isArray(typeI)) {
                    throw SqlException.$(argPosI, "mixed array and non-array elements");
                }
                if (ColumnType.decodeArrayDimensionality(typeI) != nestedNDims) {
                    throw SqlException.$(argPosI, "sub-arrays don't match in number of dimensions");
                }
                commonElemType = ColumnType.commonWideningType(commonElemType, ColumnType.decodeArrayElementType(typeI));
            }
            if (arg0 instanceof FunctionArrayFunction) {
                int i;
                for (int i2 = 1; i2 < outerDimLen; ++i2) {
                    if (args.getQuick(i2) instanceof FunctionArrayFunction) {
                        continue;
                    }
                    break block15;
                }
                FunctionArray array0 = (FunctionArray)arg0.getArray(null);
                int nestedElemCount = array0.getFlatViewLength();
                int n3 = args.size();
                for (i = 1; i < n3; ++i) {
                    if (args.getQuick(i).getArray(null).getFlatViewLength() == nestedElemCount) continue;
                    throw SqlException.$(argPositions.getQuick(i), "element counts in sub-arrays don't match");
                }
                FunctionArray array = new FunctionArray(commonElemType, nestedNDims + 1);
                array.setDimLen(0, outerDimLen);
                for (i = 0; i < nestedNDims; ++i) {
                    array.setDimLen(i + 1, array0.getDimLen(i));
                }
                array.applyShape(configuration, arg0Pos);
                int flatIndex = 0;
                for (int i3 = 0; i3 < outerDimLen; ++i3) {
                    FunctionArray arrayI = (FunctionArray)args.getQuick(i3).getArray(null);
                    for (int j = 0; j < nestedElemCount; ++j) {
                        array.putFunction(flatIndex++, arrayI.getFunctionAtFlatIndex(j));
                    }
                }
                return new FunctionArrayFunction(array);
            }
        }
        return new ArrayFunctionArrayFunction(configuration, new ObjList<Function>(args), new IntList(argPositions), commonElemType, nestedNDims);
    }

    @Override
    public int resolvePreferredVariadicType(int sqlPos, int argPos, ObjList<Function> args) {
        return 27;
    }

    private static class FunctionArrayFunction
    extends ArrayFunction
    implements MultiArgFunction {
        private final FunctionArray array;

        public FunctionArrayFunction(FunctionArray array) {
            this.array = array;
            this.type = array.getType();
        }

        @Override
        public void assignType(int type, BindVariableService bindVariableService) {
            assert (this.array.isEmpty()) : "array is not empty";
            this.type = type;
            this.array.setType(type);
        }

        @Override
        public void close() {
            Misc.free(this.array);
        }

        @Override
        public ObjList<Function> getArgs() {
            return this.array.getFunctions();
        }

        @Override
        public ArrayView getArray(Record rec) {
            this.array.setRecord(rec);
            return this.array;
        }

        @Override
        public boolean isThreadSafe() {
            return false;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val("ARRAY");
            this.array.toPlan(sink);
        }
    }

    private static class ArrayFunctionArrayFunction
    extends ArrayFunction
    implements MultiArgFunction {
        @NotNull
        private final IntList argPositions;
        @NotNull
        private final ObjList<Function> args;
        private final DirectArray arrayOut;

        public ArrayFunctionArrayFunction(@NotNull CairoConfiguration configuration, @NotNull ObjList<Function> args, @NotNull IntList argPositions, short commonElemType, int nestedNDims) {
            try {
                this.type = ColumnType.encodeArrayType(commonElemType, nestedNDims + 1);
                this.args = args;
                this.argPositions = argPositions;
                this.arrayOut = new DirectArray(configuration);
                this.arrayOut.setType(this.type);
            }
            catch (Throwable th) {
                this.close();
                throw th;
            }
        }

        @Override
        public void assignType(int type, BindVariableService bindVariableService) {
            this.type = type;
            this.arrayOut.setType(type);
        }

        @Override
        public void close() {
            MultiArgFunction.super.close();
            Misc.free(this.arrayOut);
        }

        @Override
        @NotNull
        public ObjList<Function> getArgs() {
            return this.args;
        }

        @Override
        public ArrayView getArray(Record rec) {
            ArrayView array0 = this.args.getQuick(0).getArray(rec);
            short type0 = array0.getElemType();
            short outType = this.arrayOut.getElemType();
            if (type0 != 0 && type0 != outType) {
                throw CairoException.nonCritical().position(this.argPositions.getQuick(0)).put("sub-array has different type [subArrayType=").put(type0).put(", thisArrayType=").put(outType);
            }
            int nDims = array0.getDimCount();
            this.arrayOut.clear();
            this.arrayOut.setDimLen(0, this.args.size());
            for (int dim = 0; dim < nDims; ++dim) {
                this.arrayOut.setDimLen(dim + 1, array0.getDimLen(dim));
            }
            this.arrayOut.applyShape(this.argPositions.getQuick(0));
            MemoryA memA = this.arrayOut.startMemoryA();
            array0.appendDataToMem(memA);
            int n = this.args.size();
            for (int i = 1; i < n; ++i) {
                ArrayView arrayI = this.args.getQuick(i).getArray(rec);
                int argPosI = this.argPositions.getQuick(i);
                for (int dim = 0; dim < nDims; ++dim) {
                    if (arrayI.getDimLen(dim) == this.arrayOut.getDimLen(dim + 1)) continue;
                    throw CairoException.nonCritical().position(argPosI).put("array shapes don't match");
                }
                arrayI.appendDataToMem(memA);
            }
            return this.arrayOut;
        }

        @Override
        public boolean isThreadSafe() {
            return false;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val("ARRAY[");
            String comma = "";
            int n = this.args.size();
            for (int i = 0; i < n; ++i) {
                sink.val(comma);
                sink.val(this.args.getQuick(i));
                comma = ",";
            }
            sink.val(']');
        }
    }
}

