/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin;

import io.questdb.griffin.OperatorExpression;
import io.questdb.std.LowerCaseAsciiCharSequenceObjHashMap;
import io.questdb.std.ObjList;

public class OperatorRegistry {
    public final LowerCaseAsciiCharSequenceObjHashMap<OperatorExpression> map = new LowerCaseAsciiCharSequenceObjHashMap();
    public final ObjList<OperatorExpression> operators = new ObjList();
    public OperatorExpression dot;
    public OperatorExpression unaryComplement;
    public OperatorExpression unaryMinus;
    public OperatorExpression unarySetNegation;

    public OperatorRegistry(ObjList<OperatorExpression> operators) {
        int k = operators.size();
        block6: for (int i = 0; i < k; ++i) {
            OperatorExpression op = operators.getQuick(i);
            switch (op.operator) {
                case UnaryMinus: {
                    this.unaryMinus = op;
                    continue block6;
                }
                case UnaryComplement: {
                    this.unaryComplement = op;
                    continue block6;
                }
                case UnarySetNegation: {
                    this.unarySetNegation = op;
                    continue block6;
                }
                case Dot: {
                    this.dot = op;
                }
                default: {
                    assert (!this.map.contains(op.operator.token)) : "unexpected operator conflict";
                    this.map.put(op.operator.token, op);
                    this.operators.add(op);
                }
            }
        }
        assert (this.dot != null) : "dot operator ('.') must be present in operators list";
        assert (this.unaryMinus != null) : "unary minus operator ('-') must be present in operators list";
        assert (this.unaryComplement != null) : "unary complement operator ('~') must be present in operators list";
        assert (this.unarySetNegation != null) : "unary set negation operator (e.g. 'not within') must be present in operators list";
    }

    public OperatorExpression getOperatorDefinition(CharSequence symbolName) {
        return this.map.get(symbolName);
    }

    public int getOperatorType(CharSequence name) {
        int index = this.map.keyIndex(name);
        if (index < 0) {
            return this.map.valueAt((int)index).type;
        }
        return 0;
    }

    public boolean isOperator(CharSequence name) {
        return this.map.contains(name);
    }

    public OperatorExpression tryGetOperator(OperatorExpression.Operator operator) {
        return operator == this.unaryMinus.operator ? this.unaryMinus : (operator == this.unaryComplement.operator ? this.unaryComplement : (operator == this.unarySetNegation.operator ? this.unarySetNegation : this.map.get(operator.token)));
    }

    public OperatorExpression tryGuessOperator(CharSequence token, int precedence) {
        if (this.unaryMinus.operator.token.contentEquals(token) && this.unaryMinus.precedence == precedence) {
            return this.unaryMinus;
        }
        if (this.unaryComplement.operator.token.contentEquals(token) && this.unaryMinus.precedence == precedence) {
            return this.unaryComplement;
        }
        OperatorExpression op = this.map.get(token);
        if (op != null && op.precedence == precedence) {
            return op;
        }
        return null;
    }
}

