/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin;

import io.questdb.griffin.OperatorRegistry;
import io.questdb.std.ObjList;

public final class OperatorExpression {
    public static final int BINARY = 2;
    public static final int SET = 3;
    public static final int UNARY = 1;
    private static final OperatorRegistry legacyRegistry = new OperatorRegistry(new ObjList<OperatorExpression>(){
        {
            this.add(new OperatorExpression(Operator.UnaryMinus, 3, false, 1));
            this.add(new OperatorExpression(Operator.UnaryComplement, 3, false, 1));
            this.add(new OperatorExpression(Operator.UnarySetNegation, 11, false, 1));
            this.add(new OperatorExpression(Operator.Dot, 1, false, 2));
            this.add(new OperatorExpression(Operator.DoubleColon, 2, true, 2));
            this.add(new OperatorExpression(Operator.Multiplication, 3, true, 2));
            this.add(new OperatorExpression(Operator.Division, 3, true, 2));
            this.add(new OperatorExpression(Operator.Modulo, 3, true, 2));
            this.add(new OperatorExpression(Operator.Plus, 4, true, 2));
            this.add(new OperatorExpression(Operator.Minus, 4, true, 2));
            this.add(new OperatorExpression(Operator.IpContainsStrictLeft, 4, true, 2));
            this.add(new OperatorExpression(Operator.IpContainsStrictRight, 4, true, 2));
            this.add(new OperatorExpression(Operator.IpContainsLeft, 4, true, 2));
            this.add(new OperatorExpression(Operator.IpContainsRight, 4, true, 2));
            this.add(new OperatorExpression(Operator.Concatenation, 5, true, 2));
            this.add(new OperatorExpression(Operator.BitAnd, 8, true, 2));
            this.add(new OperatorExpression(Operator.BitXor, 9, true, 2));
            this.add(new OperatorExpression(Operator.BitOr, 10, true, 2));
            this.add(new OperatorExpression(Operator.In, 7, true, 3, false));
            this.add(new OperatorExpression(Operator.Between, 7, true, 3, false));
            this.add(new OperatorExpression(Operator.Within, 7, true, 3, false));
            this.add(new OperatorExpression(Operator.Less, 6, true, 2));
            this.add(new OperatorExpression(Operator.LessOrEqual, 6, true, 2));
            this.add(new OperatorExpression(Operator.Greater, 6, true, 2));
            this.add(new OperatorExpression(Operator.GreaterOrEqual, 6, true, 2));
            this.add(new OperatorExpression(Operator.Equal, 7, true, 2));
            this.add(new OperatorExpression(Operator.NotEqual, 7, true, 2));
            this.add(new OperatorExpression(Operator.NotEqualSqlStyle, 7, true, 2));
            this.add(new OperatorExpression(Operator.LikeRegex, 7, true, 2));
            this.add(new OperatorExpression(Operator.NotLikeRegex, 7, true, 2));
            this.add(new OperatorExpression(Operator.LikeSqlStyle, 7, true, 2, false));
            this.add(new OperatorExpression(Operator.ILikeSqlStyle, 7, true, 2, false));
            this.add(new OperatorExpression(Operator.BinaryNot, 11, true, 1, false));
            this.add(new OperatorExpression(Operator.BinaryAnd, 11, true, 2, false));
            this.add(new OperatorExpression(Operator.BinaryOr, 11, true, 2, false));
        }
    });
    private static final OperatorRegistry registry = new OperatorRegistry(new ObjList<OperatorExpression>(){
        {
            this.add(new OperatorExpression(Operator.DeclareVariableAssignment, 100, false, 2));
            this.add(new OperatorExpression(Operator.UnaryMinus, 3, false, 1));
            this.add(new OperatorExpression(Operator.UnaryComplement, 3, false, 1));
            this.add(new OperatorExpression(Operator.UnarySetNegation, 11, false, 1));
            this.add(new OperatorExpression(Operator.Dot, 1, false, 2));
            this.add(new OperatorExpression(Operator.DoubleColon, 2, true, 2));
            this.add(new OperatorExpression(Operator.Multiplication, 4, true, 2));
            this.add(new OperatorExpression(Operator.Division, 4, true, 2));
            this.add(new OperatorExpression(Operator.Modulo, 4, true, 2));
            this.add(new OperatorExpression(Operator.Plus, 5, true, 2));
            this.add(new OperatorExpression(Operator.Minus, 5, true, 2));
            this.add(new OperatorExpression(Operator.IpContainsStrictLeft, 6, true, 2));
            this.add(new OperatorExpression(Operator.IpContainsStrictRight, 6, true, 2));
            this.add(new OperatorExpression(Operator.IpContainsLeft, 6, true, 2));
            this.add(new OperatorExpression(Operator.IpContainsRight, 6, true, 2));
            this.add(new OperatorExpression(Operator.Concatenation, 7, true, 2));
            this.add(new OperatorExpression(Operator.BitAnd, 8, true, 2));
            this.add(new OperatorExpression(Operator.BitXor, 9, true, 2));
            this.add(new OperatorExpression(Operator.BitOr, 10, true, 2));
            this.add(new OperatorExpression(Operator.In, 11, false, 3, false));
            this.add(new OperatorExpression(Operator.Between, 11, false, 3, false));
            this.add(new OperatorExpression(Operator.Within, 11, false, 3, false));
            this.add(new OperatorExpression(Operator.Less, 12, true, 2));
            this.add(new OperatorExpression(Operator.LessOrEqual, 12, true, 2));
            this.add(new OperatorExpression(Operator.Greater, 12, true, 2));
            this.add(new OperatorExpression(Operator.GreaterOrEqual, 12, true, 2));
            this.add(new OperatorExpression(Operator.Equal, 13, true, 2));
            this.add(new OperatorExpression(Operator.NotEqual, 13, true, 2));
            this.add(new OperatorExpression(Operator.NotEqualSqlStyle, 13, true, 2));
            this.add(new OperatorExpression(Operator.LikeRegex, 13, true, 2));
            this.add(new OperatorExpression(Operator.NotLikeRegex, 13, true, 2));
            this.add(new OperatorExpression(Operator.LikeSqlStyle, 13, true, 2, false));
            this.add(new OperatorExpression(Operator.ILikeSqlStyle, 13, true, 2, false));
            this.add(new OperatorExpression(Operator.BinaryNot, 14, false, 1, false));
            this.add(new OperatorExpression(Operator.BinaryAnd, 15, true, 2, false));
            this.add(new OperatorExpression(Operator.BinaryOr, 16, true, 2, false));
            this.add(new OperatorExpression(Operator.Colon, 17, false, 2));
        }
    });
    final boolean leftAssociative;
    final Operator operator;
    final int precedence;
    final boolean symbol;
    final int type;

    private OperatorExpression(Operator operator, int precedence, boolean leftAssociative, int type, boolean symbol) {
        this.operator = operator;
        this.precedence = precedence;
        this.leftAssociative = leftAssociative;
        this.type = type;
        this.symbol = symbol;
    }

    private OperatorExpression(Operator operator, int precedence, boolean leftAssociative, int type) {
        this.operator = operator;
        this.precedence = precedence;
        this.leftAssociative = leftAssociative;
        this.type = type;
        this.symbol = true;
    }

    public static OperatorRegistry chooseRegistry(boolean cairoSqlLegacyOperatorPrecedence) {
        return cairoSqlLegacyOperatorPrecedence ? legacyRegistry : registry;
    }

    public static OperatorRegistry getLegacyRegistry() {
        return legacyRegistry;
    }

    public static OperatorRegistry getRegistry() {
        return registry;
    }

    public int getType() {
        return this.type;
    }

    public String getToken() {
        return this.operator.token;
    }

    public boolean greaterPrecedence(int otherPrecedence) {
        return this.leftAssociative && this.precedence >= otherPrecedence || !this.leftAssociative && this.precedence > otherPrecedence;
    }

    public static enum Operator {
        DeclareVariableAssignment(":="),
        UnaryMinus("-"),
        UnaryComplement("~"),
        UnarySetNegation("not"),
        Dot("."),
        Colon(":"),
        DoubleColon("::"),
        Multiplication("*"),
        Division("/"),
        Modulo("%"),
        Plus("+"),
        Minus("-"),
        IpContainsStrictLeft("<<"),
        IpContainsStrictRight(">>"),
        IpContainsLeft("<<="),
        IpContainsRight(">>="),
        Concatenation("||"),
        BitAnd("&"),
        BitXor("^"),
        BitOr("|"),
        In("in"),
        Between("between"),
        Within("within"),
        Less("<"),
        LessOrEqual("<="),
        Greater(">"),
        GreaterOrEqual(">="),
        Equal("="),
        NotEqual("!="),
        NotEqualSqlStyle("<>"),
        LikeRegex("~"),
        NotLikeRegex("!~"),
        LikeSqlStyle("like"),
        ILikeSqlStyle("ilike"),
        BinaryNot("not"),
        BinaryAnd("and"),
        BinaryOr("or");

        public final String token;

        private Operator(String token) {
            this.token = token;
        }
    }
}

