/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin;

import io.questdb.griffin.CharacterStoreEntry;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.BufferWindowCharSequence;
import io.questdb.std.Mutable;
import io.questdb.std.Numbers;
import io.questdb.std.ObjectPool;
import io.questdb.std.str.AbstractCharSequence;
import io.questdb.std.str.Utf16Sink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CharacterStore
implements CharacterStoreEntry,
Mutable,
Utf16Sink {
    private static final Log LOG = LogFactory.getLog(CharacterStore.class);
    private final ObjectPool<NameAssemblerCharSequence> csPool;
    private int capacity;
    private char[] chars;
    private NameAssemblerCharSequence next = null;
    private int size = 0;

    public CharacterStore(int capacity, int poolCapacity) {
        this.capacity = capacity;
        this.chars = new char[Numbers.ceilPow2(capacity)];
        this.csPool = new ObjectPool<NameAssemblerCharSequence>(() -> new NameAssemblerCharSequence(), poolCapacity);
    }

    @Override
    public void clear() {
        this.csPool.clear();
        this.size = 0;
        this.next = null;
    }

    @Override
    public int length() {
        return this.size;
    }

    public CharacterStoreEntry newEntry() {
        this.next = this.csPool.next();
        this.next.lo = this.size;
        return this;
    }

    @Override
    public Utf16Sink put(char c) {
        if (this.size < this.capacity) {
            this.chars[this.size++] = c;
        } else {
            this.resizeAndPut(c);
        }
        return this;
    }

    @Override
    public Utf16Sink put(char @NotNull [] chars, int start, int len) {
        for (int i = 0; i < len; ++i) {
            this.put(chars[start + i]);
        }
        return this;
    }

    @Override
    public Utf16Sink put(@Nullable CharSequence cs) {
        if (cs != null) {
            this.put(cs, 0, cs.length());
        }
        return this;
    }

    @Override
    public CharSequence toImmutable() {
        this.next.hi = this.size;
        return this.next;
    }

    @Override
    public void trimTo(int size) {
        this.size = size;
    }

    private void resizeAndPut(char c) {
        char[] next = new char[this.capacity * 2];
        System.arraycopy(this.chars, 0, next, 0, this.capacity);
        this.chars = next;
        this.capacity *= 2;
        this.chars[this.size++] = c;
        LOG.info().$("resize [capacity=").$(this.capacity).$(']').$();
    }

    public class NameAssemblerCharSequence
    extends AbstractCharSequence
    implements Mutable,
    BufferWindowCharSequence {
        int hi;
        int lo;

        @Override
        public char charAt(int index) {
            return CharacterStore.this.chars[this.lo + index];
        }

        @Override
        public void clear() {
        }

        @Override
        public int length() {
            return this.hi - this.lo;
        }

        @Override
        public void shiftLo(int positiveOffset) {
            this.lo += positiveOffset;
        }

        @Override
        protected CharSequence _subSequence(int start, int end) {
            NameAssemblerCharSequence that = CharacterStore.this.csPool.next();
            that.lo = this.lo + start;
            that.hi = this.lo + end;
            assert (that.lo < that.hi);
            return that;
        }
    }
}

